/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.horse.HitchableHorse;
import net.minecraft.world.Container;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HorseInventoryMenu.class})
public abstract class HorseInventoryMenuMixin
extends AbstractContainerMenu {
    @Shadow
    @Final
    private Container f_39653_;
    @Shadow
    @Final
    private AbstractHorse f_39654_;
    @Unique
    private boolean horseman$leadSlotAdded = false;

    protected HorseInventoryMenuMixin(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @Inject(method={"hasChest"}, at={@At(value="HEAD")})
    private void onHasChest(final AbstractHorse horse, CallbackInfoReturnable<Boolean> cir) {
        if (this.horseman$leadSlotAdded) {
            return;
        }
        if (!(horse instanceof HitchableHorse)) {
            return;
        }
        final HitchableHorse hitchableHorse = (HitchableHorse)horse;
        if (!HitchableHorse.shouldHaveLeadSlot(hitchableHorse)) {
            return;
        }
        int leadSlotIndex = HitchableHorse.getLeadSlotIndex(hitchableHorse);
        this.m_38897_(new Slot(this.f_39653_, leadSlotIndex, 8, 54){

            public boolean m_5857_(ItemStack stack) {
                return HitchableHorse.mayPlaceInLeadSlot(hitchableHorse, stack);
            }

            public boolean m_8010_(Player player) {
                ItemStack stack = this.m_7993_();
                return !stack.m_150930_(Items.f_42655_) || !HitchableHorse.isHitched(hitchableHorse);
            }

            public int m_6641_() {
                return 1;
            }

            public boolean m_6659_() {
                return horse.m_9236_().f_46443_ || HitchableHorse.isLeadSlotActive(hitchableHorse);
            }
        });
        this.horseman$leadSlotAdded = true;
    }

    @Inject(method={"quickMoveStack"}, at={@At(value="HEAD")}, cancellable=true)
    private void onQuickMoveStack(Player player, int index, CallbackInfoReturnable<ItemStack> cir) {
        AbstractHorse abstractHorse = this.f_39654_;
        if (!(abstractHorse instanceof HitchableHorse)) {
            return;
        }
        HitchableHorse hitchableHorse = (HitchableHorse)abstractHorse;
        if (!HitchableHorse.shouldHaveLeadSlot(hitchableHorse)) {
            return;
        }
        if (index < this.f_39653_.m_6643_()) {
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return;
        }
        ItemStack clickedStack = slot.m_7993_();
        if (!clickedStack.m_150930_(Items.f_42655_)) {
            return;
        }
        ItemStack clickedStackCopy = clickedStack.m_41777_();
        Slot leadSlot = this.m_38853_(2);
        if (!leadSlot.m_5857_(clickedStack)) {
            return;
        }
        ItemStack movedStack = clickedStack.m_255036_(1);
        if (!leadSlot.m_7993_().m_41619_()) {
            if (!this.m_38903_(clickedStack, 3, this.f_39653_.m_6643_(), false)) {
                cir.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
            if (clickedStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() == clickedStackCopy.m_41613_()) {
                cir.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
            slot.m_142406_(player, clickedStack);
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        clickedStack.m_41774_(1);
        ((Slot)this.f_38839_.get(2)).m_269060_(movedStack);
        if (clickedStack.m_41619_()) {
            slot.m_269060_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (clickedStack.m_41613_() == clickedStackCopy.m_41613_()) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        slot.m_142406_(player, clickedStack);
        cir.setReturnValue((Object)ItemStack.f_41583_);
    }
}

