/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight;

import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;

public class LightMovementBehaviour
implements MovementBehaviour {
    private final int luminance;
    private static final String LightBlockPrevPosKey = "LightBlockPrevPos";

    public LightMovementBehaviour(int luminance) {
        this.luminance = luminance;
    }

    public void stopMoving(MovementContext context) {
        if (context.world.m_5776_()) {
            return;
        }
        this.cleanPreviousLightBlock(context);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.m_5776_()) {
            return;
        }
        this.cleanPreviousLightBlock(context);
        this.createNewLightBlock(context, pos);
    }

    private void cleanPreviousLightBlock(MovementContext context) {
        if (context.data.m_128441_(LightBlockPrevPosKey)) {
            CompoundTag tag = context.data.m_128469_(LightBlockPrevPosKey);
            BlockPos prevBlockPos = NbtUtils.m_129239_((CompoundTag)tag);
            context.world.m_7731_(prevBlockPos, Blocks.f_50016_.m_49966_(), 2);
            context.data.m_128473_(LightBlockPrevPosKey);
        }
    }

    private void createNewLightBlock(MovementContext context, BlockPos pos) {
        if (!((Boolean)CreateDynLightAllConfigs.server().enableLightBlock.get()).booleanValue() || (Integer)CreateDynLightAllConfigs.server().lightBlockEmissionLowerLimit.get() > this.luminance) {
            return;
        }
        BlockState originBlockState = context.world.m_8055_(pos);
        if (originBlockState.m_60713_(Blocks.f_50016_)) {
            context.world.m_7731_(pos, Blocks.f_152480_.m_49966_(), 2);
            context.data.m_128365_(LightBlockPrevPosKey, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
    }
}

