/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight.lamb;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.Level;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;
import top.leonx.dynlight.lamb.CreateDynLightSourceHolder;

public class ContraptionEntityEventHandler {
    private static final List<AbstractContraptionEntity> scheduledToAddContraptionEntities = new ArrayList<AbstractContraptionEntity>();
    private static boolean lastDynamicLightEnabled = (Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get();
    private static final List<AbstractContraptionEntity> contraptionEntities = new ArrayList<AbstractContraptionEntity>();

    public static void onContraptionEntityJoin(AbstractContraptionEntity contraptionEntity) {
        contraptionEntities.add(contraptionEntity);
        if (!((Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get()).booleanValue()) {
            return;
        }
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption != null) {
            ContraptionEntityEventHandler.addLightSourcesOfContraption(contraption);
            return;
        }
        scheduledToAddContraptionEntities.add(contraptionEntity);
    }

    public static void onContraptionEntityLeave(AbstractContraptionEntity contraptionEntity) {
        contraptionEntities.remove(contraptionEntity);
        CreateDynLightSourceHolder.INSTANCE.removeAll(contraptionEntity);
    }

    private static void addLightSourcesOfContraption(Contraption contraption) {
        Map blocks = contraption.getBlocks();
        blocks.forEach((pos, blockInfo) -> {
            if (blockInfo.f_74676_().m_60791_() > 0) {
                CreateDynLightSourceHolder.INSTANCE.getOrCreate(contraption.entity, blockInfo.f_74675_(), blockInfo.f_74676_().m_60791_());
            }
        });
    }

    public static void onTick(Level level) {
        ArrayList<AbstractContraptionEntity> toRemove = new ArrayList<AbstractContraptionEntity>();
        for (AbstractContraptionEntity entity : scheduledToAddContraptionEntities) {
            Contraption contraption = entity.getContraption();
            if (contraption == null) continue;
            ContraptionEntityEventHandler.addLightSourcesOfContraption(contraption);
            toRemove.add(entity);
        }
        scheduledToAddContraptionEntities.removeAll(toRemove);
        Boolean curEnabled = (Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get();
        if (curEnabled != lastDynamicLightEnabled) {
            ContraptionEntityEventHandler.onDynamicLightEnabledChanged();
            lastDynamicLightEnabled = curEnabled;
        }
    }

    public static void onDynamicLightEnabledChanged() {
        Boolean curEnabled = (Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get();
        if (curEnabled.booleanValue()) {
            for (AbstractContraptionEntity entity : contraptionEntities) {
                Contraption contraption = entity.getContraption();
                if (contraption == null) continue;
                ContraptionEntityEventHandler.addLightSourcesOfContraption(contraption);
            }
        } else {
            scheduledToAddContraptionEntities.clear();
            for (AbstractContraptionEntity entity : contraptionEntities) {
                CreateDynLightSourceHolder.INSTANCE.removeAll(entity);
            }
        }
    }
}

