/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.palegardenbackport.content.blocks.creakingHeart;

import com.dannbrown.palegardenbackport.content.blocks.ResinClumpBlock;
import com.dannbrown.palegardenbackport.content.blocks.creakingHeart.CreakingHeartBlock;
import com.dannbrown.palegardenbackport.content.entity.creaking.CreakingEntity;
import com.dannbrown.palegardenbackport.init.ModBlocks;
import com.dannbrown.palegardenbackport.init.ModConfig;
import com.dannbrown.palegardenbackport.init.ModEntityTypes;
import com.dannbrown.palegardenbackport.init.ModSounds;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 P2\u00020\u0001:\u0001PB%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\n2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010$\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\n2\u0006\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b(\u0010#J\u0015\u0010*\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0019\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010*\u001a\u00020\n2\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b*\u0010.J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b/\u00100R0\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020,\u0018\u0001018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b*\u00106R\"\u00107\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010\u000f\"\u0004\b:\u0010;R$\u0010=\u001a\u0004\u0018\u00010<8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\"\u0010C\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u00108\u001a\u0004\bD\u0010\u000f\"\u0004\bE\u0010;R\"\u0010F\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u00108\u001a\u0004\bG\u0010\u000f\"\u0004\bH\u0010;R\"\u0010J\u001a\u00020I8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u00a8\u0006Q"}, d2={"Lcom/dannbrown/palegardenbackport/content/blocks/creakingHeart/CreakingHeartBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "clearCreakingInfo", "()V", "", "computeAnalogOutputSignal", "()I", "Lnet/minecraft/world/entity/player/Player;", "player", "creakingHurt", "(Lnet/minecraft/world/entity/player/Player;)V", "", "distanceToCreaking", "()D", "getAnalogOutputSignal", "Ljava/util/Optional;", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "getCreakingProtector", "()Ljava/util/Optional;", "mob", "", "isProtector", "(Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)Z", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "load", "(Lnet/minecraft/nbt/CompoundTag;)V", "Lnet/minecraft/world/damagesource/DamageSource;", "damageSource", "removeProtector", "(Lnet/minecraft/world/damagesource/DamageSource;)V", "saveAdditional", "entity", "setCreakingInfo", "(Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)V", "Ljava/util/UUID;", "uuid", "(Ljava/util/UUID;)V", "spreadResin", "(Lnet/minecraft/world/entity/player/Player;)Ljava/util/Optional;", "Lcom/mojang/datafixers/util/Either;", "creakingInfo", "Lcom/mojang/datafixers/util/Either;", "getCreakingInfo", "()Lcom/mojang/datafixers/util/Either;", "(Lcom/mojang/datafixers/util/Either;)V", "emitter", "I", "getEmitter", "setEmitter", "(I)V", "Lnet/minecraft/world/phys/Vec3;", "emitterTarget", "Lnet/minecraft/world/phys/Vec3;", "getEmitterTarget", "()Lnet/minecraft/world/phys/Vec3;", "setEmitterTarget", "(Lnet/minecraft/world/phys/Vec3;)V", "outputSignal", "getOutputSignal", "setOutputSignal", "ticker", "getTicker", "setTicker", "", "ticksExisted", "J", "getTicksExisted", "()J", "setTicksExisted", "(J)V", "Companion", "palegardenbackport-2.0.2-common-1.20.1"})
public final class CreakingHeartBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int outputSignal;
    private int emitter;
    @Nullable
    private Vec3 emitterTarget;
    @Nullable
    private Either<CreakingEntity, UUID> creakingInfo;
    private long ticksExisted;
    private int ticker;
    @NotNull
    private static final Optional<CreakingEntity> NO_CREAKING;
    @NotNull
    private static final SpawnUtil.Strategy ON_TOP_OF_COLLIDER_NO_LEAVES;

    public CreakingHeartBlockEntity(@NotNull BlockEntityType<CreakingHeartBlockEntity> type, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(type, blockPos, blockState);
    }

    public final int getOutputSignal() {
        return this.outputSignal;
    }

    public final void setOutputSignal(int n) {
        this.outputSignal = n;
    }

    public final int getEmitter() {
        return this.emitter;
    }

    public final void setEmitter(int n) {
        this.emitter = n;
    }

    @Nullable
    public final Vec3 getEmitterTarget() {
        return this.emitterTarget;
    }

    public final void setEmitterTarget(@Nullable Vec3 vec3) {
        this.emitterTarget = vec3;
    }

    @Nullable
    public final Either<CreakingEntity, UUID> getCreakingInfo() {
        return this.creakingInfo;
    }

    public final void setCreakingInfo(@Nullable Either<CreakingEntity, UUID> either) {
        this.creakingInfo = either;
    }

    public final long getTicksExisted() {
        return this.ticksExisted;
    }

    public final void setTicksExisted(long l) {
        this.ticksExisted = l;
    }

    public final int getTicker() {
        return this.ticker;
    }

    public final void setTicker(int n) {
        this.ticker = n;
    }

    public final int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    public final int computeAnalogOutputSignal() {
        if (this.creakingInfo != null && !this.getCreakingProtector().isEmpty()) {
            double distance = this.distanceToCreaking();
            double value = (distance < 0.0 ? 0.0 : (distance > 32.0 ? 32.0 : distance)) / 32.0;
            return 15 - (int)Math.floor(value * 15.0);
        }
        return 0;
    }

    public final void removeProtector(@Nullable DamageSource damageSource) {
        CreakingEntity mob = this.getCreakingProtector().orElse(null);
        if (mob != null) {
            if (damageSource == null) {
                mob.tearDown();
            } else {
                mob.creakingDeathEffects(damageSource);
                mob.setTearingDown();
            }
            this.clearCreakingInfo();
        }
    }

    public final void creakingHurt(@Nullable Player player) {
        Level level;
        CreakingEntity mob = this.getCreakingProtector().orElse(null);
        if (mob != null && (level = this.f_58857_) instanceof ServerLevel && this.emitter <= 0) {
            Vec3 vec3 = mob.m_20191_().m_82399_().m_82520_(((ServerLevel)level).f_46441_.m_188500_() * mob.m_20191_().m_82362_() / (double)3 * (double)(((ServerLevel)level).f_46441_.m_188499_() ? 1 : -1), ((ServerLevel)level).f_46441_.m_188500_() * mob.m_20191_().m_82376_() / (double)3 * (double)(((ServerLevel)level).f_46441_.m_188499_() ? 1 : -1), ((ServerLevel)level).f_46441_.m_188500_() * mob.m_20191_().m_82385_() / (double)3 * (double)(((ServerLevel)level).f_46441_.m_188499_() ? 1 : -1));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            Vec3 mobPos = vec3;
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec32 = Vec3.m_82512_((Vec3i)((Vec3i)this.m_58899_()));
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"atCenterOf(...)");
            CreakingHeartBlock.Companion.emitParticleTrail(serverLevel, mobPos, vec32, 16545810, 10);
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            int chance = level2.m_213780_().m_216332_(2, 3);
            for (int i = 0; i < chance; ++i) {
                this.spreadResin(player).ifPresent(arg_0 -> CreakingHeartBlockEntity.creakingHurt$lambda$0((Function1)new Function1<BlockPos, Unit>(level, player){
                    final /* synthetic */ Level $level;
                    final /* synthetic */ Player $player;
                    {
                        this.$level = $level;
                        this.$player = $player;
                        super(1);
                    }

                    public final void invoke(@NotNull BlockPos blockPos) {
                        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
                        ((ServerLevel)this.$level).m_5594_(this.$player, blockPos, ModSounds.INSTANCE.getBLOCK_OF_RESIN_PLACE().get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        ((ServerLevel)this.$level).m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223722_((BlockState)((ServerLevel)this.$level).m_8055_(blockPos)));
                    }
                }, arg_0));
            }
            this.emitter = 50;
            this.emitterTarget = mob.m_20191_().m_82399_();
        }
    }

    public final boolean isProtector(@NotNull CreakingEntity mob) {
        Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
        Boolean bl = this.getCreakingProtector().map(arg_0 -> CreakingHeartBlockEntity.isProtector$lambda$1((Function1)new Function1<CreakingEntity, Boolean>(mob){
            final /* synthetic */ CreakingEntity $mob;
            {
                this.$mob = $mob;
                super(1);
            }

            public final Boolean invoke(@NotNull CreakingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
                return entity == this.$mob;
            }
        }, arg_0)).orElse(false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        return bl;
    }

    private final Optional<BlockPos> spreadResin(Player player) {
        Level level = this.f_58857_;
        if (level == null) {
            Optional<BlockPos> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        Level level2 = level;
        if (level2.f_46443_) {
            Optional<BlockPos> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        BlockPos currentPos = this.f_58858_;
        int maxIterations = 10;
        while (maxIterations-- > 0) {
            Direction randomDir = (Direction)ArraysKt.random((Object[])Direction.values(), (Random)((Random)Random.Default));
            BlockPos relativePos = currentPos.m_121945_(randomDir);
            BlockState blockState = level2.m_8055_(relativePos);
            if (!level2.m_46739_(relativePos)) continue;
            if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76170_()) {
                Intrinsics.checkNotNull((Object)relativePos);
                if (CreakingHeartBlockEntity.Companion.hasAdjacentPaleOakLog(level2, relativePos)) {
                    BlockState resinState = ((ResinClumpBlock)ModBlocks.INSTANCE.getRESIN_CLUMP().get()).m_5573_(new BlockPlaceContext(level2, player, InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ModBlocks.INSTANCE.getRESIN_CLUMP().get()), new BlockHitResult(Vec3.m_82512_((Vec3i)((Vec3i)relativePos)), randomDir, relativePos, false)));
                    if (resinState == null) continue;
                    if (blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76170_()) {
                        resinState = (BlockState)resinState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    }
                    level2.m_7731_(relativePos, resinState, 3);
                    Optional<BlockPos> optional = Optional.of(relativePos);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
            }
            currentPos = relativePos;
        }
        Optional<BlockPos> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        return optional;
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("creaking")) {
            UUID uUID = compoundTag.m_128342_("creaking");
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.setCreakingInfo(uUID);
        } else {
            this.clearCreakingInfo();
        }
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.m_183515_(compoundTag);
        if (!this.getCreakingProtector().isEmpty()) {
            compoundTag.m_128362_("creaking", this.getCreakingProtector().get().m_20148_());
        }
    }

    private final Optional<CreakingEntity> getCreakingProtector() {
        CreakingEntity mob;
        if (this.creakingInfo == null) {
            return NO_CREAKING;
        }
        Either<CreakingEntity, UUID> either = this.creakingInfo;
        Intrinsics.checkNotNull(either);
        if (either.left().isPresent()) {
            Either<CreakingEntity, UUID> either2 = this.creakingInfo;
            Intrinsics.checkNotNull(either2);
            Object t = either2.left().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            mob = (CreakingEntity)((Object)t);
            if (!mob.m_213877_()) {
                Optional<CreakingEntity> optional = Optional.of(mob);
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                return optional;
            }
            UUID uUID = mob.m_20148_();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            this.setCreakingInfo(uUID);
        }
        if (this.f_58857_ instanceof ServerLevel) {
            Either<CreakingEntity, UUID> either3 = this.creakingInfo;
            Intrinsics.checkNotNull(either3);
            if (either3.right().isPresent()) {
                Level level = this.f_58857_;
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                Either<CreakingEntity, UUID> either4 = this.creakingInfo;
                Intrinsics.checkNotNull(either4);
                mob = serverLevel.m_8791_((UUID)either4.right().get());
                if (mob instanceof CreakingEntity) {
                    this.setCreakingInfo(mob);
                    Optional<CreakingEntity> optional = Optional.of(mob);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    return optional;
                }
                if (this.ticksExisted >= 30L) {
                    this.clearCreakingInfo();
                }
                return NO_CREAKING;
            }
        }
        return NO_CREAKING;
    }

    private final double distanceToCreaking() {
        Double d = this.getCreakingProtector().map(arg_0 -> CreakingHeartBlockEntity.distanceToCreaking$lambda$2((Function1)new Function1<CreakingEntity, Double>(this){
            final /* synthetic */ CreakingHeartBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Double invoke(@NotNull CreakingEntity entity) {
                Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
                return Math.sqrt(entity.m_20238_(Vec3.m_82539_((Vec3i)((Vec3i)this.this$0.m_58899_()))));
            }
        }, arg_0)).orElse(0.0);
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"orElse(...)");
        return ((Number)d).doubleValue();
    }

    public final void clearCreakingInfo() {
        this.creakingInfo = null;
        this.m_6596_();
    }

    public final void setCreakingInfo(@NotNull CreakingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.creakingInfo = Either.left((Object)((Object)entity));
        this.m_6596_();
    }

    public final void setCreakingInfo(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.creakingInfo = Either.right((Object)uuid);
        this.ticksExisted = 0L;
        this.m_6596_();
    }

    private static final void creakingHurt$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Boolean isProtector$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Double distanceToCreaking$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Double)$tmp0.invoke(p0);
    }

    private static final boolean ON_TOP_OF_COLLIDER_NO_LEAVES$lambda$3(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, BlockPos blockPos2, BlockState blockState2) {
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockPos2, (String)"blockPos2");
        Intrinsics.checkNotNullParameter((Object)blockState2, (String)"blockState2");
        BlockState aboveState = serverLevel.m_8055_(blockPos2.m_7494_());
        boolean middleBlockEmpty = blockState2.m_60812_((BlockGetter)serverLevel, blockPos2).m_83281_() || blockState2.m_247087_();
        boolean standingBlockSolid = !blockState.m_204336_(BlockTags.f_13035_) && Block.m_49918_((VoxelShape)blockState.m_60812_((BlockGetter)serverLevel, blockPos), (Direction)Direction.UP);
        boolean aboveBlockEmpty = aboveState.m_60812_((BlockGetter)serverLevel, blockPos2.m_7494_()).m_83281_() || aboveState.m_247087_();
        return aboveBlockEmpty && middleBlockEmpty && standingBlockSolid;
    }

    static {
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        NO_CREAKING = optional;
        ON_TOP_OF_COLLIDER_NO_LEAVES = CreakingHeartBlockEntity::ON_TOP_OF_COLLIDER_NO_LEAVES$lambda$3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/dannbrown/palegardenbackport/content/blocks/creakingHeart/CreakingHeartBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "", "hasAdjacentPaleOakLog", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lcom/dannbrown/palegardenbackport/content/blocks/creakingHeart/CreakingHeartBlockEntity;", "blockEntity", "", "serverTick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/dannbrown/palegardenbackport/content/blocks/creakingHeart/CreakingHeartBlockEntity;)V", "Lnet/minecraft/server/level/ServerLevel;", "serverLevel", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "spawnProtector", "(Lnet/minecraft/server/level/ServerLevel;Lcom/dannbrown/palegardenbackport/content/blocks/creakingHeart/CreakingHeartBlockEntity;)Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "Ljava/util/Optional;", "NO_CREAKING", "Ljava/util/Optional;", "getNO_CREAKING", "()Ljava/util/Optional;", "Lnet/minecraft/util/SpawnUtil$Strategy;", "ON_TOP_OF_COLLIDER_NO_LEAVES", "Lnet/minecraft/util/SpawnUtil$Strategy;", "getON_TOP_OF_COLLIDER_NO_LEAVES", "()Lnet/minecraft/util/SpawnUtil$Strategy;", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Optional<CreakingEntity> getNO_CREAKING() {
            return NO_CREAKING;
        }

        @NotNull
        public final SpawnUtil.Strategy getON_TOP_OF_COLLIDER_NO_LEAVES() {
            return ON_TOP_OF_COLLIDER_NO_LEAVES;
        }

        private final boolean hasAdjacentPaleOakLog(Level level, BlockPos pos) {
            for (Direction dir : Direction.values()) {
                BlockPos adjacentPos = pos.m_121945_(dir);
                BlockState adjacentState = level.m_8055_(adjacentPos);
                Intrinsics.checkNotNull((Object)adjacentState);
                if (!CreakingHeartBlock.Companion.isPaleOakLog(adjacentState)) continue;
                return true;
            }
            return false;
        }

        private final CreakingEntity spawnProtector(ServerLevel serverLevel, CreakingHeartBlockEntity blockEntity) {
            BlockPos blockPos = blockEntity.m_58899_();
            Optional optional = SpawnUtil.m_216403_(ModEntityTypes.INSTANCE.getCREAKING().get(), (MobSpawnType)MobSpawnType.SPAWNER, (ServerLevel)serverLevel, (BlockPos)blockPos, (int)5, (int)16, (int)8, (SpawnUtil.Strategy)this.getON_TOP_OF_COLLIDER_NO_LEAVES());
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"trySpawnMob(...)");
            Optional spawnedMob = optional;
            if (spawnedMob.isEmpty()) {
                return null;
            }
            Object t = spawnedMob.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            CreakingEntity entity = (CreakingEntity)((Object)t);
            serverLevel.m_220400_((Entity)entity, GameEvent.f_157810_, entity.m_20182_());
            serverLevel.m_7605_((Entity)entity, (byte)60);
            Intrinsics.checkNotNull((Object)blockPos);
            entity.setTransient(blockPos);
            return entity;
        }

        public final void serverTick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull CreakingHeartBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            blockEntity.setTicksExisted(blockEntity.getTicksExisted() + 1L);
            blockEntity.getTicksExisted();
            if (level instanceof ServerLevel) {
                int analogSignal = blockEntity.computeAnalogOutputSignal();
                if (blockEntity.getOutputSignal() != analogSignal) {
                    blockEntity.setOutputSignal(analogSignal);
                    level.m_46717_(blockPos, ModBlocks.INSTANCE.getCREAKING_HEART().get());
                }
                if (blockEntity.getEmitter() > 0) {
                    if (blockEntity.getEmitter() > 50) {
                        Optional protector = blockEntity.getCreakingProtector();
                        ServerLevel serverLevel = (ServerLevel)level;
                        Vec3 vec3 = ((CreakingEntity)((Object)protector.get())).m_20182_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                        Vec3 vec32 = Vec3.m_82512_((Vec3i)((Vec3i)blockPos));
                        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"atCenterOf(...)");
                        CreakingHeartBlock.Companion.emitParticleTrail(serverLevel, vec3, vec32, 16545810, 10);
                        ServerLevel serverLevel2 = (ServerLevel)level;
                        Vec3 vec33 = ((CreakingEntity)((Object)protector.get())).m_20182_();
                        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
                        Vec3 vec34 = Vec3.m_82512_((Vec3i)((Vec3i)blockPos));
                        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"atCenterOf(...)");
                        CreakingHeartBlock.Companion.emitParticleTrail(serverLevel2, vec33, vec34, 0x5F5F5F, 10);
                    }
                    if (blockEntity.getEmitter() % 10 == 0 && blockEntity.getEmitterTarget() != null) {
                        blockEntity.getCreakingProtector().ifPresent(arg_0 -> Companion.serverTick$lambda$0((Function1)new Function1<CreakingEntity, Unit>(blockEntity){
                            final /* synthetic */ CreakingHeartBlockEntity $blockEntity;
                            {
                                this.$blockEntity = $blockEntity;
                                super(1);
                            }

                            public final void invoke(@NotNull CreakingEntity creakingEntity) {
                                Intrinsics.checkNotNullParameter((Object)((Object)creakingEntity), (String)"creakingEntity");
                                this.$blockEntity.setEmitterTarget(creakingEntity.m_20191_().m_82399_());
                            }
                        }, arg_0));
                        Vec3 center = Vec3.m_82512_((Vec3i)((Vec3i)blockPos));
                        float dis = 0.2f + 0.8f * (float)(100 - blockEntity.getEmitter()) / 100.0f;
                        Vec3 diff = center.m_82546_(blockEntity.getEmitterTarget()).m_82490_((double)dis).m_82549_(blockEntity.getEmitterTarget());
                        BlockPos pos = BlockPos.m_274446_((Position)((Position)diff));
                        float pVolume = (float)blockEntity.getEmitter() / 2.0f / 100.0f + 0.5f;
                        level.m_5594_(null, pos, ModSounds.INSTANCE.getCREAKING_HEART_HURT().get(), SoundSource.BLOCKS, pVolume, 1.0f);
                    }
                    blockEntity.setEmitter(blockEntity.getEmitter() + -1);
                    blockEntity.getEmitter();
                }
                int center = blockEntity.getTicker();
                blockEntity.setTicker(center + -1);
                if (center < 0) {
                    int n;
                    if (blockEntity.f_58857_ == null) {
                        n = 20;
                    } else {
                        Level level2 = blockEntity.f_58857_;
                        Intrinsics.checkNotNull((Object)level2);
                        n = level2.f_46441_.m_188503_(5) + 20;
                    }
                    blockEntity.setTicker(n);
                    CreakingEntity mob = null;
                    if (blockEntity.getCreakingInfo() == null) {
                        if (!CreakingHeartBlock.Companion.hasRequiredLogs(blockState, (LevelReader)level, blockPos)) {
                            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CreakingHeartBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(false)), 3);
                        } else {
                            Player player;
                            Comparable comparable = blockState.m_61143_((Property)CreakingHeartBlock.Companion.getACTIVE());
                            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
                            if (((Boolean)comparable).booleanValue() && CreakingHeartBlock.Companion.isNaturalNight(level, blockPos) && level.m_46791_() != Difficulty.PEACEFUL && level.m_46469_().m_46207_(GameRules.f_46134_) && (player = level.m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 32.0, false)) != null && (mob = this.spawnProtector((ServerLevel)level, blockEntity)) != null) {
                                blockEntity.setCreakingInfo(mob);
                                mob.m_216990_(ModSounds.INSTANCE.getCREAKING_SPAWN().get());
                                level.m_5594_(null, blockEntity.m_58899_(), ModSounds.INSTANCE.getCREAKING_SPAWN().get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        Optional entityOptional = blockEntity.getCreakingProtector();
                        if (entityOptional.isPresent()) {
                            if (!CreakingHeartBlock.Companion.isNaturalNight(level, blockPos) && !((CreakingEntity)((Object)blockEntity.getCreakingProtector().get())).m_8077_() || blockEntity.distanceToCreaking() > (double)((Number)ModConfig.INSTANCE.getCREAKING_DISTANCE_TO_HEART().get()).floatValue() || ((CreakingEntity)((Object)entityOptional.get())).playerIsStuckInYou()) {
                                blockEntity.removeProtector(null);
                                return;
                            }
                            if (!CreakingHeartBlock.Companion.hasRequiredLogs(blockState, (LevelReader)level, blockPos) && blockEntity.getCreakingInfo() == null) {
                                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CreakingHeartBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(false)), 3);
                            }
                        }
                    }
                }
            }
        }

        private static final void serverTick$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

