/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.palegardenbackport.content.entity.creaking;

import com.dannbrown.palegardenbackport.content.entity.creaking.CreakingEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001aR\u0016\u0010\u001e\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0016R\u0016\u0010$\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/AnimattedAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "Lnet/minecraft/world/entity/PathfinderMob;", "pMob", "", "pSpeedModifier", "", "pFollowingTargetEvenIfNotSeen", "<init>", "(Lnet/minecraft/world/entity/PathfinderMob;DZ)V", "Lnet/minecraft/world/entity/LivingEntity;", "pEnemy", "pDistToEnemySqr", "", "checkAndPerformAttack", "(Lnet/minecraft/world/entity/LivingEntity;D)V", "", "getTicksUntilNextAttack", "()I", "isEnemyWithinAttackDistance", "(Lnet/minecraft/world/entity/LivingEntity;D)Z", "isTimeToAttack", "()Z", "performAttack", "(Lnet/minecraft/world/entity/LivingEntity;)V", "resetAttackCooldown", "()V", "start", "stop", "tick", "attackDelay", "I", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "entity", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "isTimeToStartAttackAnimation", "shouldCountTillNextAttack", "Z", "ticksUntilNextAttack", "palegardenbackport-2.0.2-common-1.20.1"})
public final class AnimattedAttackGoal
extends MeleeAttackGoal {
    @NotNull
    private final CreakingEntity entity;
    private int attackDelay;
    private int ticksUntilNextAttack;
    private boolean shouldCountTillNextAttack;

    public AnimattedAttackGoal(@NotNull PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)pMob, (String)"pMob");
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (CreakingEntity)pMob;
        this.attackDelay = 10;
        this.ticksUntilNextAttack = 20;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 10;
        this.ticksUntilNextAttack = 20;
    }

    protected void m_6739_(@NotNull LivingEntity pEnemy, double pDistToEnemySqr) {
        Intrinsics.checkNotNullParameter((Object)pEnemy, (String)"pEnemy");
        if (this.isEnemyWithinAttackDistance(pEnemy, pDistToEnemySqr)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.entity.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20188_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.setAttackAnimationTimeout(0);
        }
    }

    private final boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected void m_25563_() {
        this.ticksUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    protected boolean m_25564_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected final boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected int m_25565_() {
        return this.ticksUntilNextAttack;
    }

    protected final void performAttack(@Nullable LivingEntity pEnemy) {
        this.m_25563_();
        this.entity.m_6674_(InteractionHand.MAIN_HAND);
        this.entity.m_7327_((Entity)pEnemy);
        this.entity.playAttackSound();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = (int)Math.max((double)(this.ticksUntilNextAttack - 1), 0.0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
    }
}

