/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.palegardenbackport.content.entity.creaking;

import com.dannbrown.deltaboxlib.registrate.presets.family.BlockFamily;
import com.dannbrown.deltaboxlib.registrate.registry.BlockEntry;
import com.dannbrown.palegardenbackport.content.blocks.creakingHeart.CreakingHeartBlock;
import com.dannbrown.palegardenbackport.content.blocks.creakingHeart.CreakingHeartBlockEntity;
import com.dannbrown.palegardenbackport.content.entity.creaking.AbstractCreaking;
import com.dannbrown.palegardenbackport.content.entity.creaking.AnimattedAttackGoal;
import com.dannbrown.palegardenbackport.content.entity.creaking.CreakingAi;
import com.dannbrown.palegardenbackport.content.entity.creaking.CreakingFreezeWhenLookedAt;
import com.dannbrown.palegardenbackport.init.ModBlocks;
import com.dannbrown.palegardenbackport.init.ModConfig;
import com.dannbrown.palegardenbackport.init.ModItems;
import com.dannbrown.palegardenbackport.init.ModSounds;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 |2\u00020\u0001:\u0004|}~\u007fB\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b \u0010\u0012J\u000f\u0010!\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b!\u0010\u0012J\u0011\u0010#\u001a\u0004\u0018\u00010\"H\u0014\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\"H\u0014\u00a2\u0006\u0004\b%\u0010$J\u000f\u0010'\u001a\u0004\u0018\u00010&\u00a2\u0006\u0004\b'\u0010(J\u0019\u0010)\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b)\u0010*J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0+\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u001d\u00102\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0000\u00a2\u0006\u0004\b2\u00103J\u001f\u00107\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u00132\u0006\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b7\u00108J\r\u00109\u001a\u00020\u001a\u00a2\u0006\u0004\b9\u0010\u001cJ\r\u0010:\u001a\u00020\u001a\u00a2\u0006\u0004\b:\u0010\u001cJ\r\u0010;\u001a\u00020\u001a\u00a2\u0006\u0004\b;\u0010\u001cJ\u001d\u0010<\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\b2\u0006\u00101\u001a\u00020\u0000\u00a2\u0006\u0004\b<\u00103J\r\u0010=\u001a\u00020\u001a\u00a2\u0006\u0004\b=\u0010\u001cJ\u001f\u0010A\u001a\u0006\u0012\u0002\b\u00030@2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030>H\u0014\u00a2\u0006\u0004\bA\u0010BJ\r\u0010C\u001a\u00020\n\u00a2\u0006\u0004\bC\u0010\u0012J\u001f\u0010G\u001a\u00020\n2\u0006\u0010D\u001a\u00020&2\u0006\u0010F\u001a\u00020EH\u0014\u00a2\u0006\u0004\bG\u0010HJ\r\u0010I\u001a\u00020\u001a\u00a2\u0006\u0004\bI\u0010\u001cJ\u0017\u0010J\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\bJ\u0010\u0010J\u000f\u0010K\u001a\u00020\nH\u0014\u00a2\u0006\u0004\bK\u0010\u0012J\u0017\u0010L\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\bL\u0010\u001fJ\u0019\u0010M\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\bM\u0010\u0016J\u0015\u0010O\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u001a\u00a2\u0006\u0004\bO\u0010PJ\u0015\u0010R\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\u001a\u00a2\u0006\u0004\bR\u0010PJ\u0015\u0010T\u001a\u00020\n2\u0006\u0010S\u001a\u00020&\u00a2\u0006\u0004\bT\u0010UJ\u0015\u0010V\u001a\u00020\n2\u0006\u00109\u001a\u00020\u001a\u00a2\u0006\u0004\bV\u0010PJ\r\u0010W\u001a\u00020\n\u00a2\u0006\u0004\bW\u0010\u0012J\u0015\u0010X\u001a\u00020\n2\u0006\u0010S\u001a\u00020&\u00a2\u0006\u0004\bX\u0010UJ\u000f\u0010Y\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bY\u0010\u0012J\u000f\u0010Z\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\bZ\u0010\u001cJ\r\u0010[\u001a\u00020\n\u00a2\u0006\u0004\b[\u0010\u0012J\r\u0010\\\u001a\u00020\n\u00a2\u0006\u0004\b\\\u0010\u0012J\u000f\u0010]\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b]\u0010\u0012J\u000f\u0010^\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b^\u0010\u0012R\"\u0010`\u001a\u00020_8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b`\u0010a\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR\u0017\u0010g\u001a\u00020f8\u0006\u00a2\u0006\f\n\u0004\bg\u0010h\u001a\u0004\bi\u0010jR\"\u0010k\u001a\u00020_8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010a\u001a\u0004\bl\u0010c\"\u0004\bm\u0010eR\u0017\u0010n\u001a\u00020f8\u0006\u00a2\u0006\f\n\u0004\bn\u0010h\u001a\u0004\bo\u0010jR\u0016\u0010p\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010aR\u0017\u0010q\u001a\u00020f8\u0006\u00a2\u0006\f\n\u0004\bq\u0010h\u001a\u0004\br\u0010jR\u0016\u0010s\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bs\u0010aR\u0016\u0010t\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010aR\u0017\u0010u\u001a\u00020f8\u0006\u00a2\u0006\f\n\u0004\bu\u0010h\u001a\u0004\bv\u0010jR\u0016\u0010w\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010aR\u0016\u0010x\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010aR\"\u0010y\u001a\u00020_8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\by\u0010a\u001a\u0004\bz\u0010c\"\u0004\b{\u0010e\u00a8\u0006\u0080\u0001"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/AbstractCreaking;", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "activate", "(Lnet/minecraft/world/entity/player/Player;)V", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "aiStep", "()V", "Lnet/minecraft/world/damagesource/DamageSource;", "damageSource", "blameSourceForDamage", "(Lnet/minecraft/world/damagesource/DamageSource;)Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/entity/ai/Brain$Provider;", "brainProvider", "()Lnet/minecraft/world/entity/ai/Brain$Provider;", "", "canMove", "()Z", "checkCanMove", "creakingDeathEffects", "(Lnet/minecraft/world/damagesource/DamageSource;)V", "deactivate", "defineSynchedData", "Lnet/minecraft/sounds/SoundEvent;", "getAmbientSound", "()Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "Lnet/minecraft/core/BlockPos;", "getHomePos", "()Lnet/minecraft/core/BlockPos;", "getHurtSound", "(Lnet/minecraft/world/damagesource/DamageSource;)Lnet/minecraft/sounds/SoundEvent;", "", "getNearestPlayers", "()Ljava/util/List;", "Lnet/minecraft/world/item/ItemStack;", "getPickResult", "()Lnet/minecraft/world/item/ItemStack;", "mob", "hasLineOfSight", "(Lnet/minecraft/world/entity/player/Player;Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)Z", "source", "", "amount", "hurt", "(Lnet/minecraft/world/damagesource/DamageSource;F)Z", "isActive", "isAttacking", "isHeartBound", "isLookingAtMe", "isTearingDown", "Lcom/mojang/serialization/Dynamic;", "dynamic", "Lnet/minecraft/world/entity/ai/Brain;", "makeBrain", "(Lcom/mojang/serialization/Dynamic;)Lnet/minecraft/world/entity/ai/Brain;", "playAttackSound", "pPos", "Lnet/minecraft/world/level/block/state/BlockState;", "pState", "playStepSound", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "playerIsStuckInYou", "readAdditionalSaveData", "registerGoals", "resolveMobResponsibleForDamage", "resolvePlayerResponsibleForDamage", "attacking", "setAttacking", "(Z)V", "value", "setCanMove", "blockPos", "setHomePos", "(Lnet/minecraft/core/BlockPos;)V", "setIsActive", "setTearingDown", "setTransient", "setupAnimationStates", "shouldDropExperience", "stopInPlace", "tearDown", "tick", "tickDeath", "", "attackAnimationRemainingTicks", "I", "getAttackAnimationRemainingTicks", "()I", "setAttackAnimationRemainingTicks", "(I)V", "Lnet/minecraft/world/entity/AnimationState;", "attackAnimationState", "Lnet/minecraft/world/entity/AnimationState;", "getAttackAnimationState", "()Lnet/minecraft/world/entity/AnimationState;", "attackAnimationTimeout", "getAttackAnimationTimeout", "setAttackAnimationTimeout", "deathAnimationState", "getDeathAnimationState", "deathAnimationTimeout", "idleAnimationState", "getIdleAnimationState", "idleAnimationTimeout", "invulnerabilityAnimationRemainingTicks", "invulnerabilityAnimationState", "getInvulnerabilityAnimationState", "invulnerabilityAnimationTimeout", "playerStuckCounter", "tearingTicks", "getTearingTicks", "setTearingTicks", "Companion", "CreakingJumpControl", "CreakingLookControl", "CreakingMoveControl", "palegardenbackport-2.0.2-common-1.20.1"})
@SourceDebugExtension(value={"SMAP\nCreakingEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreakingEntity.kt\ncom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,541:1\n1747#2,3:542\n800#2,11:545\n766#2:556\n857#2,2:557\n1855#2,2:559\n*S KotlinDebug\n*F\n+ 1 CreakingEntity.kt\ncom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity\n*L\n234#1:542,3\n300#1:545,11\n300#1:556\n300#1:557,2\n312#1:559,2\n*E\n"})
public final class CreakingEntity
extends AbstractCreaking {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationState idleAnimationState;
    private int idleAnimationTimeout;
    @NotNull
    private final AnimationState attackAnimationState;
    private int attackAnimationTimeout;
    private int attackAnimationRemainingTicks;
    @NotNull
    private final AnimationState invulnerabilityAnimationState;
    private int invulnerabilityAnimationTimeout;
    private int invulnerabilityAnimationRemainingTicks;
    @NotNull
    private final AnimationState deathAnimationState;
    private int deathAnimationTimeout;
    private int tearingTicks;
    private int playerStuckCounter;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTACKING;
    private static final EntityDataAccessor<Boolean> CAN_MOVE;
    private static final EntityDataAccessor<Boolean> IS_ACTIVE;
    private static final EntityDataAccessor<Boolean> IS_TEARING_DOWN;
    private static final EntityDataAccessor<Optional<BlockPos>> HOME_POS;

    public CreakingEntity(@NotNull EntityType<? extends AbstractCreaking> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.idleAnimationState = new AnimationState();
        this.attackAnimationState = new AnimationState();
        this.invulnerabilityAnimationState = new AnimationState();
        this.deathAnimationState = new AnimationState();
        this.f_21365_ = new CreakingLookControl(this);
        this.f_21342_ = new CreakingMoveControl(this);
        this.f_21343_ = new CreakingJumpControl(this);
        PathNavigation pathNavigation = this.m_21573_();
        Intrinsics.checkNotNull((Object)pathNavigation, (String)"null cannot be cast to non-null type net.minecraft.world.entity.ai.navigation.GroundPathNavigation");
        GroundPathNavigation groundPathNavigation = (GroundPathNavigation)pathNavigation;
        groundPathNavigation.m_7008_(true);
        this.f_21364_ = 0;
    }

    @NotNull
    public final AnimationState getIdleAnimationState() {
        return this.idleAnimationState;
    }

    @NotNull
    public final AnimationState getAttackAnimationState() {
        return this.attackAnimationState;
    }

    public final int getAttackAnimationTimeout() {
        return this.attackAnimationTimeout;
    }

    public final void setAttackAnimationTimeout(int n) {
        this.attackAnimationTimeout = n;
    }

    public final int getAttackAnimationRemainingTicks() {
        return this.attackAnimationRemainingTicks;
    }

    public final void setAttackAnimationRemainingTicks(int n) {
        this.attackAnimationRemainingTicks = n;
    }

    @NotNull
    public final AnimationState getInvulnerabilityAnimationState() {
        return this.invulnerabilityAnimationState;
    }

    @NotNull
    public final AnimationState getDeathAnimationState() {
        return this.deathAnimationState;
    }

    public final int getTearingTicks() {
        return this.tearingTicks;
    }

    public final void setTearingTicks(int n) {
        this.tearingTicks = n;
    }

    @NotNull
    protected Brain.Provider<CreakingEntity> m_5490_() {
        return CreakingAi.INSTANCE.brainProvider();
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        Intrinsics.checkNotNullParameter(dynamic, (String)"dynamic");
        Brain brain = this.m_5490_().m_22073_(dynamic);
        Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"makeBrain(...)");
        return CreakingAi.INSTANCE.makeBrain((Brain<CreakingEntity>)brain);
    }

    public final boolean canMove() {
        Object object = this.f_19804_.m_135370_(CAN_MOVE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("home_pos")) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("home_pos"));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"readBlockPos(...)");
            this.setTransient(blockPos);
        }
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        super.m_7380_(compoundTag);
        BlockPos blockPos = this.getHomePos();
        if (blockPos != null) {
            compoundTag.m_128365_("home_pos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            BlockPos blockPos = this.getHomePos();
            if (blockPos != null) {
                boolean isProtector2 = false;
                BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                if (blockEntity instanceof CreakingHeartBlockEntity) {
                    isProtector2 = ((CreakingHeartBlockEntity)blockEntity).isProtector(this);
                }
                if (!isProtector2) {
                    if (this.isTearingDown()) {
                        if (this.tearingTicks > 50 && !this.m_213877_()) {
                            this.tearDown();
                        }
                    } else {
                        this.m_21153_(0.0f);
                    }
                }
            }
            if (this.isTearingDown()) {
                int n = this.tearingTicks;
                this.tearingTicks = n + 1;
            }
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private final void setupAnimationStates() {
        this.attackAnimationState.m_246184_(this.attackAnimationRemainingTicks > 0, this.f_19797_);
        this.invulnerabilityAnimationState.m_246184_(this.invulnerabilityAnimationRemainingTicks > 0, this.f_19797_);
        this.deathAnimationState.m_246184_(this.isTearingDown(), this.f_19797_);
        this.idleAnimationState.m_246184_(this.idleAnimationTimeout > 0, this.f_19797_);
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationRemainingTicks = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (this.attackAnimationTimeout > 0) {
            this.attackAnimationTimeout += -1;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            if (!this.isAttacking()) {
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            this.idleAnimationTimeout += -1;
        }
    }

    public final void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public final boolean isAttacking() {
        Object object = this.f_19804_.m_135370_(ATTACKING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CAN_MOVE, (Object)true);
        this.f_19804_.m_135372_(IS_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(IS_TEARING_DOWN, (Object)false);
        this.f_19804_.m_135372_(HOME_POS, Optional.empty());
    }

    public final void activate(@Nullable Player player) {
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)player);
        this.m_216990_(ModSounds.INSTANCE.getCREAKING_ACTIVATE().get());
        this.setIsActive(true);
    }

    public final void deactivate() {
        this.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        this.m_216990_(ModSounds.INSTANCE.getCREAKING_DEACTIVATE().get());
        this.setIsActive(false);
    }

    public final void setIsActive(boolean isActive) {
        this.f_19804_.m_135381_(IS_ACTIVE, (Object)isActive);
    }

    public final boolean isActive() {
        Object object = this.f_19804_.m_135370_(IS_ACTIVE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLookingAtMe(@NotNull Player player, @NotNull CreakingEntity mob) {
        ItemStack it;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20188_() - player.m_20188_(), mob.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        Vec3 vec32 = vec31.m_82541_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
        vec31 = vec32;
        double d1 = vec3.m_82526_(vec31);
        double fovThreshold = Math.cos(Math.toRadians(((Number)ModConfig.INSTANCE.getPLAYER_FOV_ANGLE().get()).floatValue()));
        if (!(d1 > fovThreshold / d0)) return false;
        if (!this.hasLineOfSight(player, mob)) return false;
        Iterable iterable = player.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Iterable $this$any$iv = iterable;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (ItemStack)element$iv;
            boolean bl = false;
        } while (!it.m_150930_(Items.f_42047_));
        return false;
    }

    public final boolean hasLineOfSight(@NotNull Player player, @NotNull CreakingEntity mob) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
        if (mob.m_9236_() != player.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 vec31 = new Vec3(mob.m_20185_(), mob.m_20188_(), mob.m_20189_());
        return vec31.m_82554_(vec3) > (double)((Number)ModConfig.INSTANCE.getCREAKING_FREEZE_DISTANCE().get()).floatValue() ? false : player.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() == HitResult.Type.MISS;
    }

    public final void stopInPlace() {
        this.m_21573_().m_26573_();
        this.m_21570_(0.0f);
        this.m_21567_(0.0f);
        this.m_7910_(0.0f);
    }

    public final void setCanMove(boolean value) {
        this.f_19804_.m_135381_(CAN_MOVE, (Object)value);
    }

    @Override
    public void m_8107_() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            this.invulnerabilityAnimationRemainingTicks += -1;
        }
        if (this.attackAnimationRemainingTicks > 0) {
            this.attackAnimationRemainingTicks += -1;
        }
        if (!this.m_9236_().f_46443_) {
            CreakingAi.INSTANCE.updateActivity(this);
            Object object = this.f_19804_.m_135370_(CAN_MOVE);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean canMoveFlag = (Boolean)object;
            boolean canMoveNow = this.checkCanMove();
            if (canMoveNow != canMoveFlag) {
                if (canMoveNow) {
                    this.m_216990_(ModSounds.INSTANCE.getCREAKING_UNFREEZE().get());
                } else {
                    this.stopInPlace();
                    this.m_216990_(ModSounds.INSTANCE.getCREAKING_FREEZE().get());
                }
            }
            this.setCanMove(canMoveNow);
        }
        super.m_8107_();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> getNearestPlayers() {
        List fromBrain = this.f_20939_.m_21952_(MemoryModuleType.f_26367_).orElse(CollectionsKt.emptyList());
        if (fromBrain.isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            AABB AABB2 = this.m_20191_().m_82400_(16.0);
            List entities = this.m_9236_().m_45933_((Entity)this, AABB2);
            Intrinsics.checkNotNull((Object)entities);
            Iterable $this$filterIsInstance$iv = entities;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Player)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Player it = (Player)element$iv$iv;
                boolean bl = false;
                if (!(it.m_6084_() && !it.m_5833_() && !it.m_7500_())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List players = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            this.f_20939_.m_21879_(MemoryModuleType.f_26367_, (Object)players);
            return players;
        }
        Intrinsics.checkNotNull((Object)fromBrain);
        return fromBrain;
    }

    public final boolean checkCanMove() {
        List<Player> nearestPlayers = this.getNearestPlayers();
        if (nearestPlayers.isEmpty()) {
            return true;
        }
        Iterable $this$forEach$iv = nearestPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Player player = it;
            if (!this.isLookingAtMe(player, this)) continue;
            if (this.isActive()) {
                return false;
            }
            if (!(player.m_20280_((Entity)this) < 144.0)) continue;
            this.activate(player);
            return false;
        }
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CreakingFreezeWhenLookedAt(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimattedAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_6153_() {
        if (this.isHeartBound() && this.isTearingDown()) {
            ++this.f_20919_;
            if (!this.m_9236_().m_5776_() && this.f_20919_ > 45 && !this.m_213877_()) {
                this.tearDown();
            }
        } else {
            super.m_6153_();
        }
    }

    public final boolean isHeartBound() {
        return this.getHomePos() != null;
    }

    @Nullable
    public final BlockPos getHomePos() {
        return ((Optional)this.f_19804_.m_135370_(HOME_POS)).orElse(null);
    }

    public final void setTearingDown() {
        this.f_19804_.m_135381_(IS_TEARING_DOWN, (Object)true);
    }

    public final boolean isTearingDown() {
        Object object = this.f_19804_.m_135370_(IS_TEARING_DOWN);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    public final void tearDown() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            AABB aabb = this.m_20191_();
            Vec3 vec3 = aabb.m_82399_();
            double d0 = aabb.m_82362_() * 0.3;
            double d1 = aabb.m_82376_() * 0.3;
            double d2 = aabb.m_82385_() * 0.3;
            ServerLevel serverLevel = (ServerLevel)level;
            Object v = ModBlocks.INSTANCE.getPALE_OAK().getBlockFamily().getBlocks().get(BlockFamily.Type.WOOD);
            Intrinsics.checkNotNull(v);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((BlockEntry)v).get().m_49966_()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 100, d0, d1, d2, 0.0);
            ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, (BlockState)((CreakingHeartBlock)ModBlocks.INSTANCE.getCREAKING_HEART().get()).m_49966_().m_61124_((Property)CreakingHeartBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(true))), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 10, d0, d1, d2, 0.0);
        }
        this.m_216990_(this.m_5592_());
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public final void playAttackSound() {
        this.m_216990_(ModSounds.INSTANCE.getCREAKING_ATTACK().get());
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        this.m_216990_(ModSounds.INSTANCE.getCREAKING_STEP().get());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isActive() ? null : ModSounds.INSTANCE.getCREAKING_AMBIENT().get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return this.isHeartBound() ? ModSounds.INSTANCE.getCREAKING_HIT().get() : super.m_7975_(damageSource);
    }

    @NotNull
    protected SoundEvent m_5592_() {
        SoundEvent soundEvent = ModSounds.INSTANCE.getCREAKING_DEATH().get();
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"get(...)");
        return soundEvent;
    }

    public final void creakingDeathEffects(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        this.blameSourceForDamage(damageSource);
        this.m_216990_(ModSounds.INSTANCE.getCREAKING_TWITCH().get());
    }

    @Nullable
    public final Player blameSourceForDamage(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        this.resolveMobResponsibleForDamage(damageSource);
        return this.resolvePlayerResponsibleForDamage(damageSource);
    }

    private final void resolveMobResponsibleForDamage(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity && !damageSource.m_269533_(DamageTypeTags.f_268718_)) {
            this.m_6703_((LivingEntity)entity);
        }
    }

    private final Player resolvePlayerResponsibleForDamage(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            this.f_20889_ = 100;
            this.f_20888_ = (Player)entity;
            return (Player)entity;
        }
        if (entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_()) {
            this.f_20889_ = 100;
            LivingEntity var6 = ((TamableAnimal)entity).m_269323_();
            this.f_20888_ = var6 instanceof Player ? (Player)var6 : null;
            return this.f_20888_;
        }
        return null;
    }

    public final void setTransient(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.setHomePos(blockPos);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    public final void setHomePos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.f_19804_.m_135381_(HOME_POS, Optional.of(blockPos));
    }

    public final boolean playerIsStuckInYou() {
        Object e;
        List list = this.f_20939_.m_21952_(MemoryModuleType.f_26367_).orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"orElse(...)");
        List list2 = list;
        if (list2.isEmpty()) {
            this.playerStuckCounter = 0;
            return false;
        }
        AABB aabb = this.m_20191_();
        Iterator iterator = list2.iterator();
        Player player = null;
        do {
            if (!iterator.hasNext()) {
                this.playerStuckCounter = 0;
                return false;
            }
            e = iterator.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        } while (!aabb.m_82390_((player = (Player)e).m_146892_()));
        ++this.playerStuckCounter;
        return this.playerStuckCounter > 4;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BlockPos blockPos = this.getHomePos();
        if (blockPos != null && !source.m_269533_(DamageTypeTags.f_268738_)) {
            if (!this.m_6673_(source) && this.invulnerabilityAnimationRemainingTicks <= 0 && !this.m_21224_()) {
                Player player = this.blameSourceForDamage(source);
                Entity entity = source.m_7640_();
                if (!(entity instanceof LivingEntity) && !(entity instanceof Projectile) && player == null) {
                    return false;
                }
                this.invulnerabilityAnimationRemainingTicks = 8;
                this.m_9236_().m_7605_((Entity)this, (byte)66);
                BlockEntity blockEntity = this.m_9236_().m_7702_(blockPos);
                if (blockEntity instanceof CreakingHeartBlockEntity && ((CreakingHeartBlockEntity)blockEntity).isProtector(this) && player != null) {
                    ((CreakingHeartBlockEntity)blockEntity).creakingHurt(player);
                }
                this.m_6677_(source);
                return true;
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6149_() {
        return false;
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.INSTANCE.getCREAKING_SPAWN_EGG().get());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(CreakingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        ATTACKING = entityDataAccessor;
        CAN_MOVE = SynchedEntityData.m_135353_(CreakingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_ACTIVE = SynchedEntityData.m_135353_(CreakingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_TEARING_DOWN = SynchedEntityData.m_135353_(CreakingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        HOME_POS = SynchedEntityData.m_135353_(CreakingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR;\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\tRs\u0010\u000f\u001a^\u0012(\u0012&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r \n*.\u0012(\u0012&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0007\u001a\u0004\b\u0010\u0010\tR;\u0010\u0011\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0007\u001a\u0004\b\u0012\u0010\tR;\u0010\u0013\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "ATTACKING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getATTACKING", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "kotlin.jvm.PlatformType", "CAN_MOVE", "getCAN_MOVE", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "HOME_POS", "getHOME_POS", "IS_ACTIVE", "getIS_ACTIVE", "IS_TEARING_DOWN", "getIS_TEARING_DOWN", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTACKING() {
            return ATTACKING;
        }

        public final EntityDataAccessor<Boolean> getCAN_MOVE() {
            return CAN_MOVE;
        }

        public final EntityDataAccessor<Boolean> getIS_ACTIVE() {
            return IS_ACTIVE;
        }

        public final EntityDataAccessor<Boolean> getIS_TEARING_DOWN() {
            return IS_TEARING_DOWN;
        }

        public final EntityDataAccessor<Optional<BlockPos>> getHOME_POS() {
            return HOME_POS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\t\u00a8\u0006\n"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity$CreakingJumpControl;", "Lnet/minecraft/world/entity/ai/control/JumpControl;", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "creakingEntity", "<init>", "(Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)V", "", "tick", "()V", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class CreakingJumpControl
    extends JumpControl {
        @NotNull
        private final CreakingEntity creakingEntity;

        public CreakingJumpControl(@NotNull CreakingEntity creakingEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)creakingEntity), (String)"creakingEntity");
            super((Mob)creakingEntity);
            this.creakingEntity = creakingEntity;
        }

        public void m_8124_() {
            if (this.creakingEntity.canMove()) {
                super.m_8124_();
            } else {
                this.creakingEntity.m_6862_(false);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\t\u00a8\u0006\n"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity$CreakingLookControl;", "Lnet/minecraft/world/entity/ai/control/LookControl;", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "creakingEntity", "<init>", "(Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)V", "", "tick", "()V", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class CreakingLookControl
    extends LookControl {
        @NotNull
        private final CreakingEntity creakingEntity;

        public CreakingLookControl(@NotNull CreakingEntity creakingEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)creakingEntity), (String)"creakingEntity");
            super((Mob)creakingEntity);
            this.creakingEntity = creakingEntity;
        }

        public void m_8128_() {
            if (this.creakingEntity.canMove()) {
                super.m_8128_();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\t\u00a8\u0006\n"}, d2={"Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity$CreakingMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "creakingEntity", "<init>", "(Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;)V", "", "tick", "()V", "Lcom/dannbrown/palegardenbackport/content/entity/creaking/CreakingEntity;", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class CreakingMoveControl
    extends MoveControl {
        @NotNull
        private final CreakingEntity creakingEntity;

        public CreakingMoveControl(@NotNull CreakingEntity creakingEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)creakingEntity), (String)"creakingEntity");
            super((Mob)creakingEntity);
            this.creakingEntity = creakingEntity;
        }

        public void m_8126_() {
            if (this.creakingEntity.canMove()) {
                super.m_8126_();
            }
        }
    }
}

