/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.palegardenbackport.content.worldgen.placerTypes;

import com.dannbrown.palegardenbackport.content.blocks.creakingHeart.CreakingHeartBlock;
import com.dannbrown.palegardenbackport.init.ModConfig;
import com.dannbrown.palegardenbackport.init.ModPlacerTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007JQ\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/dannbrown/palegardenbackport/content/worldgen/placerTypes/PaleOakHeartTrunkPlacer;", "Lnet/minecraft/world/level/levelgen/feature/trunkplacers/DarkOakTrunkPlacer;", "", "baseHeight", "heightRandA", "heightRandB", "<init>", "(III)V", "Lnet/minecraft/world/level/LevelSimulatedReader;", "level", "Ljava/util/function/BiConsumer;", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "blockConsumer", "Lnet/minecraft/util/RandomSource;", "random", "height", "startPos", "Lnet/minecraft/world/level/levelgen/feature/configurations/TreeConfiguration;", "config", "", "Lnet/minecraft/world/level/levelgen/feature/foliageplacers/FoliagePlacer$FoliageAttachment;", "placeTrunk", "(Lnet/minecraft/world/level/LevelSimulatedReader;Ljava/util/function/BiConsumer;Lnet/minecraft/util/RandomSource;ILnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/feature/configurations/TreeConfiguration;)Ljava/util/List;", "Lnet/minecraft/world/level/levelgen/feature/trunkplacers/TrunkPlacerType;", "type", "()Lnet/minecraft/world/level/levelgen/feature/trunkplacers/TrunkPlacerType;", "Companion", "palegardenbackport-2.0.2-common-1.20.1"})
public final class PaleOakHeartTrunkPlacer
extends DarkOakTrunkPlacer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Codec<PaleOakHeartTrunkPlacer> CODEC;

    public PaleOakHeartTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> blockConsumer, @NotNull RandomSource random, int height, @NotNull BlockPos startPos, @NotNull TreeConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(blockConsumer, (String)"blockConsumer");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ArrayList foliageAttachments = Lists.newArrayList();
        BlockPos groundPos = startPos.m_7495_();
        DarkOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockConsumer, (RandomSource)random, (BlockPos)groundPos, (TreeConfiguration)config);
        DarkOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockConsumer, (RandomSource)random, (BlockPos)groundPos.m_122029_(), (TreeConfiguration)config);
        DarkOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockConsumer, (RandomSource)random, (BlockPos)groundPos.m_122019_(), (TreeConfiguration)config);
        DarkOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockConsumer, (RandomSource)random, (BlockPos)groundPos.m_122019_().m_122029_(), (TreeConfiguration)config);
        Direction horizontalDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
        int branchStartHeight = height - random.m_188503_(4);
        int branchLength = 2 - random.m_188503_(3);
        int startX = startPos.m_123341_();
        int startY = startPos.m_123342_();
        int startZ = startPos.m_123343_();
        int currentX = startX;
        int currentZ = startZ;
        int topY = startY + height - 1;
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockPos trunkPos;
            if (currentHeight >= branchStartHeight && branchLength > 0) {
                currentX += horizontalDirection.m_122429_();
                currentZ += horizontalDirection.m_122431_();
                --branchLength;
            }
            if (!level.m_7433_(trunkPos = new BlockPos(currentX, startY + currentHeight, currentZ), PaleOakHeartTrunkPlacer::placeTrunk$lambda$0)) continue;
            boolean isSecondToLastLayer = currentHeight == height - 2;
            float randomChanceOfHeart = ((Number)ModConfig.INSTANCE.getCREAKING_HEART_CHANCE().get()).floatValue();
            int randomLogIndex = random.m_188500_() <= (double)randomChanceOfHeart ? random.m_188503_(4) : -1;
            BlockState logBlock = isSecondToLastLayer && randomLogIndex == 0 ? CreakingHeartBlock.Companion.getNaturalState() : config.f_68185_.m_213972_(random, trunkPos);
            blockConsumer.accept(trunkPos, logBlock);
            BlockState logBlockEast = isSecondToLastLayer && randomLogIndex == 1 ? CreakingHeartBlock.Companion.getNaturalState() : config.f_68185_.m_213972_(random, trunkPos.m_122029_());
            blockConsumer.accept(trunkPos.m_122029_(), logBlockEast);
            BlockState logBlockSouth = isSecondToLastLayer && randomLogIndex == 2 ? CreakingHeartBlock.Companion.getNaturalState() : config.f_68185_.m_213972_(random, trunkPos.m_122019_());
            blockConsumer.accept(trunkPos.m_122019_(), logBlockSouth);
            BlockState logBlockDiagonal = isSecondToLastLayer && randomLogIndex == 3 ? CreakingHeartBlock.Companion.getNaturalState() : config.f_68185_.m_213972_(random, trunkPos.m_122029_().m_122019_());
            blockConsumer.accept(trunkPos.m_122029_().m_122019_(), logBlockDiagonal);
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(currentX, topY, currentZ), 0, true));
        for (int offsetX = -1; offsetX < 3; ++offsetX) {
            for (int offsetZ = -1; offsetZ < 3; ++offsetZ) {
                if (offsetX >= 0 && offsetX <= 1 && offsetZ >= 0 && offsetZ <= 1 || random.m_188503_(3) > 0) continue;
                int branchHeight = random.m_188503_(3) + 2;
                for (int branchStep = 0; branchStep < branchHeight; ++branchStep) {
                    this.m_226187_(level, blockConsumer, random, new BlockPos(startX + offsetX, topY - branchStep - 1, startZ + offsetZ), config);
                }
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(currentX + offsetX, topY, currentZ + offsetZ), 0, false));
            }
        }
        Intrinsics.checkNotNull((Object)foliageAttachments);
        return foliageAttachments;
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        Object object = ModPlacerTypes.INSTANCE.getPALE_OAK_HEART_TRUNK_PLACER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (TrunkPlacerType)object;
    }

    private static final boolean placeTrunk$lambda$0(BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state.m_60795_() || state.m_247087_() || state.m_204336_(BlockTags.f_13035_);
    }

    private static final PaleOakHeartTrunkPlacer CODEC$lambda$2$lambda$1(Integer baseHeight, Integer heightRandA, Integer heightRandB) {
        Integer n = baseHeight;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = heightRandA;
        Intrinsics.checkNotNull((Object)n3);
        int n4 = n3;
        Integer n5 = heightRandB;
        Intrinsics.checkNotNull((Object)n5);
        return new PaleOakHeartTrunkPlacer(n2, n4, n5);
    }

    private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
        return DarkOakTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PaleOakHeartTrunkPlacer::CODEC$lambda$2$lambda$1);
    }

    static {
        Codec codec = RecordCodecBuilder.create(PaleOakHeartTrunkPlacer::CODEC$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/dannbrown/palegardenbackport/content/worldgen/placerTypes/PaleOakHeartTrunkPlacer$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/dannbrown/palegardenbackport/content/worldgen/placerTypes/PaleOakHeartTrunkPlacer;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "palegardenbackport-2.0.2-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<PaleOakHeartTrunkPlacer> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

