/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.HudMod;
import xaero.hud.HudSession;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.world.MapWorld;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientPlaySessionFinalizedEvent;
import xaeroplus.feature.render.DrawManager;
import xaeroplus.settings.Settings;

public class Globals {
    public static final DrawManager drawManager = new DrawManager();
    public static boolean nullOverworldDimensionFolder = false;
    public static Settings.DataFolderResolutionMode dataFolderResolutionMode = Settings.DataFolderResolutionMode.IP;
    public static int minimapScaleMultiplier = 1;
    public static int minimapSizeMultiplier = 1;
    public static boolean shouldResetFBO = false;
    public static boolean minimapSettingsInitialized = false;
    public static boolean switchingDimension = false;
    public static ByteArrayOutputStream zipFastByteBuffer = new ByteArrayOutputStream();
    public static final Supplier<ExecutorService> cacheRefreshExecutorService = Suppliers.memoize(() -> Executors.newFixedThreadPool(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 2)), new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Cache-Refresh-%d").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Caught unhandled exception in cache refresh executor", e)).setDaemon(true).build()));
    public static final Supplier<ExecutorService> moduleExecutorService = Suppliers.memoize(() -> Executors.newFixedThreadPool(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 2)), new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Module-%d").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Caught unhandled exception in module executor", e)).setDaemon(true).build()));

    public static ResourceKey<Level> getCurrentDimensionId() {
        try {
            ResourceKey dim = XaeroWorldMapCore.currentSession.getMapProcessor().getMapWorld().getCurrentDimensionId();
            if (dim == null) {
                return Level.f_46428_;
            }
            return dim;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed getting current dimension id", (Throwable)e);
            return Level.f_46428_;
        }
    }

    public static void initStickySettings() {
        nullOverworldDimensionFolder = Settings.REGISTRY.nullOverworldDimensionFolder.get();
        dataFolderResolutionMode = Settings.REGISTRY.dataFolderResolutionMode.get();
        minimapScaleMultiplier = Settings.REGISTRY.minimapScaleMultiplierSetting.getAsInt();
        minimapSizeMultiplier = Settings.REGISTRY.minimapSizeMultiplierSetting.getAsInt();
        XaeroPlus.EVENT_BUS.registerConsumer(e -> {
            nullOverworldDimensionFolder = Settings.REGISTRY.nullOverworldDimensionFolder.get();
            dataFolderResolutionMode = Settings.REGISTRY.dataFolderResolutionMode.get();
        }, new Class[]{ClientPlaySessionFinalizedEvent.class});
    }

    public static void initSyncedSettings() {
        try {
            boolean baseSetting = HudMod.INSTANCE.getSettings().radarHideInvisibleEntities;
            Settings.REGISTRY.radarHideInvisibleEntities.setValue(baseSetting);
        }
        catch (Exception ex) {
            XaeroPlus.LOGGER.error("Failed syncing setting: radarHideInvisibleEntities", (Throwable)ex);
        }
    }

    public static void switchToDimension(ResourceKey<Level> newDimId) {
        if (newDimId == null) {
            return;
        }
        try {
            WorldMapSession session = XaeroWorldMapCore.currentSession;
            if (session == null) {
                return;
            }
            MapProcessor mapProcessor = session.getMapProcessor();
            if (mapProcessor == null) {
                return;
            }
            MapWorld mapWorld = mapProcessor.getMapWorld();
            if (mapWorld == null) {
                return;
            }
            mapWorld.setCustomDimensionId(newDimId);
            mapProcessor.checkForWorldUpdate();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed switching to dimension: {}", newDimId, (Object)e);
        }
    }

    public static void setNullOverworldDimFolderIfAble(boolean b) {
        try {
            WorldMapSession currentWMSession = XaeroWorldMapCore.currentSession;
            HudSession currentMMSession = HudSession.getCurrentSession();
            if (currentWMSession != null || currentMMSession != null) {
                return;
            }
            nullOverworldDimensionFolder = b;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed setting nullOverworldDimensionFolder", (Throwable)e);
        }
    }

    public static void setDataFolderResolutionModeIfAble(Settings.DataFolderResolutionMode mode) {
        try {
            WorldMapSession currentWMSession = XaeroWorldMapCore.currentSession;
            HudSession currentMMSession = HudSession.getCurrentSession();
            if (currentWMSession != null || currentMMSession != null) {
                return;
            }
            dataFolderResolutionMode = mode;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed setting data folder resolution mode", (Throwable)e);
        }
    }
}

