/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.shader.MinimapShaders;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.DrawFeatureRegistry;
import xaeroplus.feature.render.DrawHelper;
import xaeroplus.feature.render.HighlightShader;
import xaeroplus.feature.render.Line;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.util.ColorHelper;

public class DrawManager {
    private final DrawFeatureRegistry registry = new DrawFeatureRegistry();

    public final DrawFeatureRegistry registry() {
        return this.registry;
    }

    public DrawManager() {
        XaeroPlus.EVENT_BUS.register((Object)this);
    }

    @EventHandler
    public void onXaeroWorldChange(XaeroWorldChangeEvent event) {
        this.registry.invalidateCaches();
    }

    public void drawMinimapFeatures(int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(-(chunkX * 64) - tileX * 16 - insideX), (float)(-(chunkZ * 64) - tileZ * 16 - insideZ), 0.0f);
        matrixStack.m_85836_();
        matrixStack.m_85841_(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, false);
        matrixStack.m_85849_();
        this.drawMinimapLines(matrixStack, renderTypeBuffers);
        matrixStack.m_85849_();
    }

    public void drawMinimapLines(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers) {
        MinimapShaders.ensureShaders();
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            VertexConsumer lineBuffer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * Mth.m_14036_((float)feature.lineWidth(), (float)(0.1f * (float)Globals.minimapScaleMultiplier), (float)1000.0f);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.m_85850_(), lineBuffer, x1, z1, x2, z2, r, g, b, a);
            }
            renderTypeBuffers.m_109912_(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawWorldMapFeatures(int flooredCameraX, int flooredCameraZ, PoseStack matrixStack, double fboScale, MultiBufferSource.BufferSource renderTypeBuffers) {
        if (HudMod.INSTANCE.isFairPlay()) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(-flooredCameraX), (float)(-flooredCameraZ), 1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85841_(16.0f, 16.0f, 1.0f);
        this.drawChunkHighlights(matrixStack, true);
        matrixStack.m_85849_();
        this.drawWorldMapLines(matrixStack, fboScale, renderTypeBuffers);
        matrixStack.m_85849_();
    }

    public void drawWorldMapLines(PoseStack matrixStack, double fboScale, MultiBufferSource.BufferSource renderTypeBuffers) {
        MinimapShaders.ensureShaders();
        Minecraft mc = Minecraft.m_91087_();
        MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)mc.m_91268_().m_85441_(), (float)mc.m_91268_().m_85442_());
        this.registry.forEachLineDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            VertexConsumer lineBuffer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_LINES);
            float lineWidthScale = 16.0f * (float)Mth.m_14008_((double)((double)feature.lineWidth() * fboScale), (double)0.1f, (double)1000.0);
            RenderSystem.lineWidth((float)lineWidthScale);
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            List<Line> lines = feature.getLines();
            for (int j = 0; j < lines.size(); ++j) {
                Line line = lines.get(j);
                int x1 = line.x1();
                int z1 = line.z1();
                int x2 = line.x2();
                int z2 = line.z2();
                if (z2 < z1) {
                    int tz1 = z1;
                    z1 = z2;
                    z2 = tz1;
                    int tx1 = x1;
                    x1 = x2;
                    x2 = tx1;
                }
                DrawHelper.addColoredLineToExistingBuffer(matrixStack.m_85850_(), lineBuffer, x2, z2, x1, z1, r, g, b, a);
            }
            renderTypeBuffers.m_109912_(CustomRenderTypes.MAP_LINES);
        });
    }

    public void drawChunkHighlights(PoseStack matrixStack, boolean worldmap) {
        XaeroPlusShaders.ensureShaders();
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        shader.setMapViewMatrix(matrixStack.m_85850_().m_252922_());
        RenderSystem.enableBlend();
        this.registry.forEachChunkHighlightDrawFeature(feature -> {
            int color = feature.colorInt();
            float a = ColorHelper.getA(color);
            if (a == 0.0f) {
                return;
            }
            float r = ColorHelper.getR(color);
            float g = ColorHelper.getG(color);
            float b = ColorHelper.getB(color);
            shader.setHighlightColor(r, g, b, a);
            feature.render(worldmap);
        });
        RenderSystem.disableBlend();
    }
}

