/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.Nullable;
import xaeroplus.feature.render.HighlightShader;
import xaeroplus.feature.render.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;

public class HighlightDrawBuffer {
    private boolean stale = true;
    @Nullable
    private VertexBuffer vertexBuffer = null;
    private boolean flipped = false;
    long lastRefreshed = 0L;

    public boolean needsRefresh(boolean needsFlip) {
        return this.vertexBuffer == null || this.vertexBuffer.m_231230_() || this.stale || this.flipped != needsFlip;
    }

    public void refresh(Long2LongMap highlights, boolean needsFlip) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = needsFlip;
        if (highlights.isEmpty()) {
            this.close();
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = needsFlip ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = needsFlip ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.m_5483_((double)x1, (double)y2, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y2, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y1, 0.0).m_5752_();
            bufferBuilder.m_5483_((double)x1, (double)y1, 0.0).m_5752_();
        }
        if (this.vertexBuffer == null || this.vertexBuffer.m_231230_()) {
            this.close();
            this.vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        }
        BufferBuilder.RenderedBuffer meshData = bufferBuilder.m_231175_();
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_231221_(meshData);
    }

    public void render() {
        if (this.vertexBuffer == null || this.vertexBuffer.m_231230_()) {
            return;
        }
        HighlightShader shader = XaeroPlusShaders.HIGHLIGHT_SHADER;
        if (shader == null) {
            return;
        }
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_253207_(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), (ShaderInstance)shader);
    }

    public void markStale() {
        this.stale = true;
    }

    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

