/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.feature.render.Line;
import xaeroplus.feature.render.LineProvider;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.TickTaskExecutor;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class LineDrawFeature {
    private final AsyncLoadingCache<Long, List<Line>> lineRenderCache;
    private final LineProvider lineProvider;

    public LineDrawFeature(LineProvider lineProvider, int refreshIntervalMs) {
        this.lineProvider = lineProvider;
        this.lineRenderCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite((long)refreshIntervalMs, TimeUnit.MILLISECONDS).executor((Executor)ModuleManager.getModule(TickTaskExecutor.class)).buildAsync(k -> this.loadLinesInWindow());
    }

    private List<Line> loadLinesInWindow() {
        int windowSize;
        int windowZ;
        int windowX;
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
        } else {
            windowX = ChunkUtils.getPlayerRegionX();
            windowZ = ChunkUtils.getPlayerRegionZ();
            windowSize = Math.max(3, Globals.minimapScaleMultiplier);
        }
        return this.lineProvider.lineSupplier().getLines(windowX, windowZ, windowSize, Globals.getCurrentDimensionId());
    }

    public int colorInt() {
        return this.lineProvider.colorSupplier().getAsInt();
    }

    public float lineWidth() {
        return this.lineProvider.lineWidthSupplier().getFloat();
    }

    public void invalidateCache() {
        this.lineRenderCache.synchronous().invalidateAll();
    }

    public List<Line> getLines() {
        return this.lineRenderCache.get((Object)0L).getNow(Collections.emptyList());
    }
}

