/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.util.ChunkUtils;

public abstract class ChunkHighlightBaseCacheHandler
implements ChunkHighlightCache {
    public final Long2LongMap chunks = new Long2LongOpenHashMap();
    Minecraft mc = Minecraft.m_91087_();

    public ChunkHighlightBaseCacheHandler() {
        this.chunks.defaultReturnValue(-1L);
    }

    @Override
    public void addHighlight(int x, int z) {
        this.addHighlight(x, z, System.currentTimeMillis());
    }

    public void addHighlight(int x, int z, long foundTime) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("addHighlight must be called on the main thread!");
        }
        this.chunks.put(ChunkUtils.chunkPosToLong(x, z), foundTime);
    }

    @Override
    public void removeHighlight(int x, int z) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("removeHighlight must be called on the main thread!");
        }
        this.chunks.remove(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public boolean isHighlighted(int x, int z, ResourceKey<Level> dimensionId) {
        return this.isHighlighted(ChunkUtils.chunkPosToLong(x, z));
    }

    @Override
    public Long2LongMap getCacheMap(ResourceKey<Level> dimension) {
        return this.chunks;
    }

    public boolean isHighlighted(long chunkPos) {
        return this.chunks.containsKey(chunkPos);
    }

    public void replaceState(Long2LongOpenHashMap state) {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("replaceState must be called on the main thread!");
        }
        this.chunks.clear();
        this.chunks.putAll((Map)state);
    }

    public void reset() {
        if (!this.mc.m_18695_()) {
            throw new RuntimeException("reset must be called on the main thread!");
        }
        this.chunks.clear();
    }
}

