/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xaero.map.MapProcessor;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightCacheDimensionHandler;
import xaeroplus.feature.render.highlights.ChunkHighlightDatabase;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class ChunkHighlightSavingCache
implements ChunkHighlightCache,
Closeable {
    @Nullable
    private ChunkHighlightDatabase database = null;
    @Nullable
    private String currentWorldId;
    private final AtomicBoolean cacheReady = new AtomicBoolean(false);
    @Nullable
    private final String databaseName;
    @Nullable
    private ListeningExecutorService dbExecutor;
    @NotNull
    private final ListeningExecutorService parentExecutor;
    private final Map<ResourceKey<Level>, ChunkHighlightCacheDimensionHandler> dimensionCacheMap = new ConcurrentHashMap<ResourceKey<Level>, ChunkHighlightCacheDimensionHandler>(3);
    private final Queue<Runnable> initializeTaskQueue = new ConcurrentLinkedQueue<Runnable>();
    Minecraft mc = Minecraft.m_91087_();
    int tickCounter = 0;

    public ChunkHighlightSavingCache(@NotNull String databaseName) {
        this.databaseName = databaseName;
        this.parentExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(databaseName + "-Manager").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception in {}", (Object)t.getName(), (Object)e)).build()));
    }

    @Override
    public void addHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForActualDimension();
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.addHighlight(x, z));
                return;
            }
            cacheForActualDimension.addHighlight(x, z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error adding highlight to {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    @Override
    public void removeHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForActualDimension();
            if (cacheForActualDimension == null) {
                this.initializeTaskQueue.add(() -> this.removeHighlight(x, z));
                return;
            }
            cacheForActualDimension.removeHighlight(x, z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Error removing highlight from {} disk cache: {}, {}", new Object[]{this.databaseName, x, z, e});
        }
    }

    @Override
    public boolean isHighlighted(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        if (dimensionId == null) {
            return false;
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return false;
        }
        return cacheForDimension.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    @Override
    public Long2LongMap getCacheMap(ResourceKey<Level> dimensionId) {
        if (dimensionId == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId, false);
        if (cacheForDimension == null) {
            return Long2LongMaps.EMPTY_MAP;
        }
        return cacheForDimension.getCacheMap(dimensionId);
    }

    @Override
    public CompletableFuture<Long2LongMap> getHighlightsInCustomWindow(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        if (dimension == null) {
            return CompletableFuture.completedFuture(Long2LongMaps.EMPTY_MAP);
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimension, true);
        if (cacheForDimension == null) {
            return CompletableFuture.completedFuture(Long2LongMaps.EMPTY_MAP);
        }
        return cacheForDimension.getHighlightsInCustomWindow(windowRegionX, windowRegionZ, windowRegionSize, dimension);
    }

    @Override
    public void handleWorldChange(XaeroWorldChangeEvent event) {
        this.parentExecutor.execute(() -> {
            switch (event.worldChangeType()) {
                case ENTER_WORLD: {
                    if (!this.cacheReady.get()) {
                        if (!this.initializeWorld()) break;
                        this.cacheReady.set(true);
                        break;
                    }
                    XaeroPlus.LOGGER.warn("[{}] Entered world when cache was already initialized", (Object)this.databaseName);
                    break;
                }
                case EXIT_WORLD: {
                    if (this.cacheReady.compareAndSet(true, false)) {
                        try {
                            CompletableFuture.allOf(this.flushAllChunks().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            XaeroPlus.LOGGER.error("Error saving all chunks before world change", (Throwable)e);
                        }
                    } else {
                        XaeroPlus.LOGGER.warn("[{}] Exited world when cache was already uninitialized", (Object)this.databaseName);
                    }
                    this.reset();
                    break;
                }
                case VIEWED_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadChunksInViewedDimension);
                    break;
                }
                case ACTUAL_DIMENSION_SWITCH: {
                    this.submitTickTask(this::loadChunksOnActualDimensionSwitch);
                }
            }
        });
    }

    private synchronized void reset() {
        this.currentWorldId = null;
        if (this.dbExecutor != null) {
            ListenableFuture closeFuture = this.dbExecutor.submit(() -> {
                if (this.database != null) {
                    this.database.close();
                }
            });
            try {
                this.dbExecutor.shutdown();
                closeFuture.get(3L, TimeUnit.SECONDS);
                this.dbExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Timed out waiting for {} executor to shutdown", (Object)this.databaseName, (Object)e);
            }
        }
        if (this.database != null) {
            this.database.close();
        }
        this.dimensionCacheMap.clear();
        this.database = null;
        this.initializeTaskQueue.clear();
    }

    private List<CompletableFuture<?>> flushAllChunks() {
        return this.getAllCaches().stream().map(cache -> this.submitTickTask(cache::writeStaleHighlightsToDatabase)).collect(Collectors.toList());
    }

    public ChunkHighlightCacheDimensionHandler getCacheForActualDimension() {
        if (!this.cacheReady.get()) {
            return null;
        }
        return this.getCacheForDimension(ChunkUtils.getActualDimension(), true);
    }

    private ChunkHighlightCacheDimensionHandler initializeDimensionCacheHandler(ResourceKey<Level> dimension) {
        if (dimension == null) {
            return null;
        }
        ChunkHighlightDatabase db = this.database;
        ListeningExecutorService executor = this.dbExecutor;
        if (db == null || executor == null) {
            XaeroPlus.LOGGER.error("[{}] Unable to initialize {} disk cache handler for: {}, database: {} or executor: {} is null", new Object[]{Thread.currentThread().getName(), this.databaseName, dimension.m_135782_(), db, executor});
            return null;
        }
        ChunkHighlightCacheDimensionHandler cacheHandler = new ChunkHighlightCacheDimensionHandler(dimension, db, executor);
        db.initializeDimension(dimension);
        this.dimensionCacheMap.put(dimension, cacheHandler);
        return cacheHandler;
    }

    public ChunkHighlightCacheDimensionHandler getCacheForDimension(ResourceKey<Level> dimension, boolean create) {
        if (!this.cacheReady.get()) {
            return null;
        }
        if (dimension == null) {
            return null;
        }
        ChunkHighlightCacheDimensionHandler dimensionCache = this.dimensionCacheMap.get(dimension);
        if (dimensionCache == null) {
            if (!create) {
                return null;
            }
            XaeroPlus.LOGGER.info("Initializing {} disk cache for dimension: {}", (Object)this.databaseName, (Object)dimension.m_135782_());
            dimensionCache = this.initializeDimensionCacheHandler(dimension);
        }
        return dimensionCache;
    }

    public List<ChunkHighlightCacheDimensionHandler> getAllCaches() {
        return List.copyOf(this.dimensionCacheMap.values());
    }

    public List<ChunkHighlightCacheDimensionHandler> getCachesExceptDimension(ResourceKey<Level> dimension) {
        ArrayList<ChunkHighlightCacheDimensionHandler> caches = new ArrayList<ChunkHighlightCacheDimensionHandler>(this.dimensionCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, ChunkHighlightCacheDimensionHandler> entry : this.dimensionCacheMap.entrySet()) {
            if (entry.getKey().equals(dimension)) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    public List<ChunkHighlightCacheDimensionHandler> getCachesExceptDimensions(List<ResourceKey<Level>> dimensions) {
        ArrayList<ChunkHighlightCacheDimensionHandler> caches = new ArrayList<ChunkHighlightCacheDimensionHandler>(this.dimensionCacheMap.size());
        for (Map.Entry<ResourceKey<Level>, ChunkHighlightCacheDimensionHandler> entry : this.dimensionCacheMap.entrySet()) {
            if (dimensions.contains(entry.getKey())) continue;
            caches.add(entry.getValue());
        }
        return caches;
    }

    private synchronized boolean initializeWorld() {
        try {
            MapProcessor mapProcessor = XaeroWorldMapCore.currentSession.getMapProcessor();
            if (mapProcessor == null) {
                return false;
            }
            String worldId = mapProcessor.getCurrentWorldId();
            if (worldId == null) {
                return false;
            }
            this.currentWorldId = worldId;
            this.dbExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(this.databaseName + "-Worker").setUncaughtExceptionHandler((t, e) -> XaeroPlus.LOGGER.error("Uncaught exception handler in {}", (Object)t.getName(), (Object)e)).build()));
            this.database = new ChunkHighlightDatabase(worldId, this.databaseName);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.f_46428_);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.f_46429_);
            this.initializeDimensionCacheHandler((ResourceKey<Level>)Level.f_46430_);
            this.loadChunksInViewedDimension();
            if (!this.initializeTaskQueue.isEmpty()) {
                XaeroPlus.LOGGER.info("[{}] Running {} queued tasks", (Object)this.databaseName, (Object)this.initializeTaskQueue.size());
            }
            while (!this.initializeTaskQueue.isEmpty()) {
                this.submitTickTask(this.initializeTaskQueue.poll());
            }
            return true;
        }
        catch (Exception e2) {
            this.reset();
            return false;
        }
    }

    private void loadChunksOnActualDimensionSwitch() {
        ChunkHighlightCacheDimensionHandler cacheForActualDimension = this.getCacheForActualDimension();
        if (cacheForActualDimension == null) {
            return;
        }
        cacheForActualDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), this.getMinimapRegionWindowSize());
    }

    private void loadChunksInViewedDimension() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        ResourceKey<Level> viewedDim = Globals.getCurrentDimensionId();
        ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForDimension(viewedDim, true);
        if (cacheForCurrentDimension == null) {
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        cacheForCurrentDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
    }

    @Override
    public void onEnable() {
        this.handleWorldChange(new XaeroWorldChangeEvent(XaeroWorldChangeEvent.WorldChangeType.ENTER_WORLD, null, ChunkUtils.getActualDimension()));
    }

    @Override
    public void onDisable() {
        this.parentExecutor.execute(() -> {
            this.cacheReady.set(false);
            try {
                CompletableFuture.allOf(this.flushAllChunks().toArray(new CompletableFuture[0])).get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error saving all chunks before disabling", (Throwable)e);
            }
            this.reset();
        });
    }

    public int getMinimapRegionWindowSize() {
        return Math.max(3, Globals.minimapScaleMultiplier);
    }

    @Override
    public void handleTick() {
        int windowCenterZ;
        int windowCenterX;
        int windowSize;
        if (!this.cacheReady.get()) {
            return;
        }
        if (XaeroWorldMapCore.currentSession == null) {
            return;
        }
        int jitter = ThreadLocalRandom.current().nextInt(0, 10);
        if (++this.tickCounter < 10 + jitter) {
            return;
        }
        this.tickCounter = 0;
        ResourceKey<Level> mapDimension = Globals.getCurrentDimensionId();
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        int actualPlayerRegionX = ChunkUtils.actualPlayerRegionX();
        int actualPlayerRegionZ = ChunkUtils.actualPlayerRegionZ();
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            windowSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            windowCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            windowCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
        } else {
            windowSize = this.getMinimapRegionWindowSize();
            windowCenterX = ChunkUtils.getPlayerRegionX();
            windowCenterZ = ChunkUtils.getPlayerRegionZ();
        }
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(mapDimension, true);
        if (cacheForDimension != null) {
            cacheForDimension.setWindow(windowCenterX, windowCenterZ, windowSize);
        }
        if (mapDimension == actualDimension) {
            this.getCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
        } else {
            ChunkHighlightCacheDimensionHandler actualDimCache = this.getCacheForDimension(actualDimension, true);
            if (actualDimCache != null) {
                actualDimCache.setWindow(actualPlayerRegionX, actualPlayerRegionZ, windowSize);
            }
            this.getCachesExceptDimensions(List.of(mapDimension, actualDimension)).forEach(cache -> cache.setWindow(0, 0, 0));
        }
    }

    @Override
    public void close() throws IOException {
        this.parentExecutor.shutdown();
    }
}

