/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.forge;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.map.gui.GuiWorldMapSettings;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.extensions.GuiXaeroPlusWorldMapSettings;
import xaeroplus.forge.EmbeddiumHelper;
import xaeroplus.forge.XaeroPlusEmbeddiumOptionsInit;
import xaeroplus.forge.XaeroPlusForgeResourceReloadListener;
import xaeroplus.settings.Settings;
import xaeroplus.util.DataFolderResolveUtil;
import xaeroplus.util.XaeroPlusGameTest;

public class XaeroPlusForgeClient {
    public void init(IEventBus modEventBus, IEventBus forgeEventBus) {
        modEventBus.addListener(this::onInitialize);
        modEventBus.addListener(this::onRegisterKeyMappingsEvent);
        modEventBus.addListener(this::onRegisterClientResourceReloadListeners);
        forgeEventBus.addListener(this::onRegisterClientCommandsEvent);
        forgeEventBus.register((Object)modEventBus);
        if (EmbeddiumHelper.isEmbeddiumPresent()) {
            forgeEventBus.addListener(XaeroPlusEmbeddiumOptionsInit::onEmbeddiumOptionGUIConstructionEvent);
        }
        RemovalCause explicit = RemovalCause.EXPLICIT;
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new GuiXaeroPlusWorldMapSettings((Screen)new GuiWorldMapSettings(screen), (Screen)screen)));
    }

    public void onInitialize(FMLClientSetupEvent event) {
    }

    public void onRegisterKeyMappingsEvent(RegisterKeyMappingsEvent event) {
        if (XaeroPlus.initialized.compareAndSet(false, true)) {
            XaeroPlus.XP_VERSION = FMLLoader.getLoadingModList().getModFileById("xaeroplus").versionString();
            XaeroPlus.initializeSettings();
            Settings.REGISTRY.getKeybindings().forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
            if (System.getenv("XP_CI_TEST") != null) {
                Minecraft.m_91087_().execute(XaeroPlusGameTest::applyMixinsTest);
            }
        }
    }

    public void onRegisterClientCommandsEvent(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"xaeroDataDir").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_288197_(DataFolderResolveUtil::getCurrentDataDirPath, false);
            return 1;
        }));
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"xaeroWaypointDir").executes(c -> {
            ((CommandSourceStack)c.getSource()).m_288197_(DataFolderResolveUtil::getCurrentWaypointDataDirPath, false);
            return 1;
        }));
    }

    public void onRegisterClientResourceReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new XaeroPlusForgeResourceReloadListener());
    }
}

