/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.feature.render.Line;
import xaeroplus.module.Module;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class RenderDistance
extends Module {
    private final int color = ColorHelper.getColor(255, 255, 0, 204);

    @Override
    public void onEnable() {
        Globals.drawManager.registry().registerLineProvider(this.getClass().getName(), this::getLines, this::getColor, this::getLineWidth, 50);
    }

    @Override
    public void onDisable() {
        Globals.drawManager.registry().unregisterLineProvider(this.getClass().getName());
    }

    List<Line> getLines(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return Collections.emptyList();
        }
        if (dimension != ChunkUtils.getActualDimension()) {
            return Collections.emptyList();
        }
        int viewDistance = mc.f_91066_.f_193765_;
        int width = viewDistance * 2 + 1;
        int middleChunkX = ChunkUtils.coordToChunkCoord(Mth.m_14107_((double)player.m_20185_()));
        int middleChunkZ = ChunkUtils.coordToChunkCoord(Mth.m_14107_((double)player.m_20189_()));
        int chunkLeftX = middleChunkX - width / 2;
        int chunkTopZ = middleChunkZ - width / 2;
        int chunkRightX = chunkLeftX + width;
        int chunkBottomZ = chunkTopZ + width;
        int minBlockX = ChunkUtils.chunkCoordToCoord(chunkLeftX);
        int minBlockZ = ChunkUtils.chunkCoordToCoord(chunkTopZ);
        int maxBlockX = ChunkUtils.chunkCoordToCoord(chunkRightX);
        int maxBlockZ = ChunkUtils.chunkCoordToCoord(chunkBottomZ);
        return List.of(new Line(minBlockX, minBlockZ, maxBlockX, minBlockZ), new Line(maxBlockX, minBlockZ, maxBlockX, maxBlockZ), new Line(maxBlockX, maxBlockZ, minBlockX, maxBlockZ), new Line(minBlockX, minBlockZ, minBlockX, maxBlockZ));
    }

    int getColor() {
        return this.color;
    }

    float getLineWidth() {
        return 0.1f;
    }
}

