/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.Globals;
import xaeroplus.feature.render.Line;
import xaeroplus.module.Module;
import xaeroplus.settings.Settings;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public abstract class SpawnChunksBase
extends Module {
    final String entityProcessingId = this.getClass().getName() + "$EntityProcessing";
    final String redstoneProcessingId = this.getClass().getName() + "$RedstoneProcessing";
    final String lazyChunkId = this.getClass().getName() + "$LazyChunk";
    final String outerChunksId = this.getClass().getName() + "$OuterChunks";
    final List<Line> entityProcessingCache = new ArrayList<Line>();
    final List<Line> redstoneProcessingCache = new ArrayList<Line>();
    final List<Line> lazyChunksCache = new ArrayList<Line>();
    final List<Line> outerChunksCache = new ArrayList<Line>();
    int alpha = 204;
    int entityProcessingColor = ColorHelper.getColor(0, 255, 0, this.alpha);
    int redstoneProcessingColor = ColorHelper.getColor(255, 0, 0, this.alpha);
    int lazyChunksColor = ColorHelper.getColor(0, 0, 255, this.alpha);
    int outerChunksColor = ColorHelper.getColor(255, 255, 0, this.alpha);
    float lineWidth = 0.1f;

    public abstract ResourceKey<Level> dimension();

    abstract int getSpawnRadius();

    abstract long getSpawnChunkPos();

    void onClientTick() {
        this.updateCaches();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registry().registerLineProvider(this.entityProcessingId, this::entityProcessing, this::entityProcessingColor, this::getLineWidth, 50);
        Globals.drawManager.registry().registerLineProvider(this.redstoneProcessingId, this::redstoneProcessing, this::redstoneProcessingColor, this::getLineWidth, 50);
        Globals.drawManager.registry().registerLineProvider(this.lazyChunkId, this::lazyChunks, this::lazyChunksColor, this::getLineWidth, 50);
        Globals.drawManager.registry().registerLineProvider(this.outerChunksId, this::outerChunks, this::outerChunksColor, this::getLineWidth, 50);
    }

    @Override
    public void onDisable() {
        Globals.drawManager.registry().unregisterLineProvider(this.entityProcessingId);
        Globals.drawManager.registry().unregisterLineProvider(this.redstoneProcessingId);
        Globals.drawManager.registry().unregisterLineProvider(this.lazyChunkId);
        Globals.drawManager.registry().unregisterLineProvider(this.outerChunksId);
    }

    public List<Line> entityProcessing(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        if (dimension != this.dimension()) {
            return Collections.emptyList();
        }
        return this.entityProcessingCache;
    }

    public List<Line> redstoneProcessing(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        if (dimension != this.dimension()) {
            return Collections.emptyList();
        }
        return this.redstoneProcessingCache;
    }

    public List<Line> lazyChunks(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        if (dimension != this.dimension()) {
            return Collections.emptyList();
        }
        return this.lazyChunksCache;
    }

    public List<Line> outerChunks(int windowRegionX, int windowRegionZ, int windowRegionSize, ResourceKey<Level> dimension) {
        if (dimension != this.dimension()) {
            return Collections.emptyList();
        }
        return this.outerChunksCache;
    }

    int entityProcessingColor() {
        return this.entityProcessingColor;
    }

    int redstoneProcessingColor() {
        return this.redstoneProcessingColor;
    }

    int lazyChunksColor() {
        return this.lazyChunksColor;
    }

    int outerChunksColor() {
        return this.outerChunksColor;
    }

    public void setEntityProcessingColor(int color) {
        this.entityProcessingColor = ColorHelper.getColorWithAlpha(color, this.alpha);
    }

    public void setRedstoneProcessingColor(int color) {
        this.redstoneProcessingColor = ColorHelper.getColorWithAlpha(color, this.alpha);
    }

    public void setLazyChunksColor(int color) {
        this.lazyChunksColor = ColorHelper.getColorWithAlpha(color, this.alpha);
    }

    public void setOuterChunksColor(int color) {
        this.outerChunksColor = ColorHelper.getColorWithAlpha(color, this.alpha);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.setEntityProcessingColor(this.entityProcessingColor);
        this.setRedstoneProcessingColor(this.redstoneProcessingColor);
        this.setLazyChunksColor(this.lazyChunksColor);
        this.setOuterChunksColor(this.outerChunksColor);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    void updateCaches() {
        int spawnChunkRadius = this.getSpawnRadius();
        this.clearCaches();
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return;
        }
        long spawnChunkPosLong = this.getSpawnChunkPos();
        int spawnChunkX = ChunkUtils.longToChunkX(spawnChunkPosLong);
        int spawnChunkZ = ChunkUtils.longToChunkZ(spawnChunkPosLong);
        int lazyRadius = spawnChunkRadius + 1;
        int redstoneRadius = spawnChunkRadius;
        int entityProcessingRadius = spawnChunkRadius - 1;
        int worldGenRadius = lazyRadius + 11;
        this.populateCache(this.entityProcessingCache, spawnChunkX, spawnChunkZ, entityProcessingRadius);
        if (Settings.REGISTRY.spawnChunksRedstoneProcessingEnabled.get()) {
            this.populateCache(this.redstoneProcessingCache, spawnChunkX, spawnChunkZ, redstoneRadius);
        }
        this.populateCache(this.lazyChunksCache, spawnChunkX, spawnChunkZ, lazyRadius);
        if (Settings.REGISTRY.spawnChunksOuterChunksEnabled.get()) {
            this.populateCache(this.outerChunksCache, spawnChunkX, spawnChunkZ, worldGenRadius);
        }
    }

    void populateCache(List<Line> cache, int centerX, int centerZ, int radius) {
        int minChunkX = centerX - radius;
        int maxChunkX = centerX + radius;
        int minChunkZ = centerZ - radius;
        int maxChunkZ = centerZ + radius;
        int minBlockX = ChunkUtils.chunkCoordToCoord(minChunkX);
        int maxBlockX = ChunkUtils.chunkCoordToCoord(maxChunkX + 1);
        int minBlockZ = ChunkUtils.chunkCoordToCoord(minChunkZ);
        int maxBlockZ = ChunkUtils.chunkCoordToCoord(maxChunkZ + 1);
        cache.add(new Line(minBlockX, minBlockZ, maxBlockX, minBlockZ));
        cache.add(new Line(minBlockX, minBlockZ, minBlockX, maxBlockZ));
        cache.add(new Line(maxBlockX, minBlockZ, maxBlockX, maxBlockZ));
        cache.add(new Line(minBlockX, maxBlockZ, maxBlockX, maxBlockZ));
    }

    void clearCaches() {
        this.entityProcessingCache.clear();
        this.redstoneProcessingCache.clear();
        this.lazyChunksCache.clear();
        this.outerChunksCache.clear();
    }
}

