/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.compat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.defaultresources.api.ResourceProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import me.ultrusmods.missingwilds.Constants;
import me.ultrusmods.missingwilds.compat.JsonDefinedModCompatInstance;
import me.ultrusmods.missingwilds.compat.ModCompatHandler;
import me.ultrusmods.missingwilds.data.ModCompatJsonData;
import me.ultrusmods.missingwilds.platform.Services;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ForgeModCompatHandler
extends ModCompatHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void loadModCompat() {
        ResourceProvider.forceInitialization();
        Collection resourceLocations = ResourceProvider.instance().getResources("missingwilds", "compat", predicate -> true);
        for (ResourceLocation resource : resourceLocations) {
            try {
                Stream resourceStream = ResourceProvider.instance().getResourceStreams("missingwilds", resource);
                try {
                    Optional optional = resourceStream.findFirst();
                    if (!optional.isPresent() || !resource.m_135815_().endsWith(".json")) continue;
                    InputStream stream = (InputStream)optional.get();
                    JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream), JsonObject.class);
                    ModCompatJsonData modCompatJsonData = (ModCompatJsonData)ModCompatJsonData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, arg_0 -> ((Logger)Constants.LOG).error(arg_0));
                    if (!Services.PLATFORM.isModLoaded(modCompatJsonData.modid()) || this.getModCompats().stream().anyMatch(modCompatInstance -> modCompatInstance.getModid().equals(modCompatJsonData.modid()))) continue;
                    this.addModCompat(new JsonDefinedModCompatInstance(modCompatJsonData));
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load mod compat file {} with error {}", (Object)resource, (Object)e.getMessage());
            }
        }
    }

    @Override
    public boolean isJsonModCompatEnabled() {
        return Services.PLATFORM.isModLoaded("dynamic_asset_generator");
    }
}

