/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.compat;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ultrusmods.missingwilds.Constants;
import me.ultrusmods.missingwilds.JarMaps;
import me.ultrusmods.missingwilds.compat.RegisteringModCompat;
import me.ultrusmods.missingwilds.data.JarData;
import me.ultrusmods.missingwilds.data.LogData;
import me.ultrusmods.missingwilds.data.ModCompatJsonData;
import me.ultrusmods.missingwilds.platform.Services;
import me.ultrusmods.missingwilds.register.MissingWildsBlocks;
import me.ultrusmods.missingwilds.register.MissingWildsItems;
import me.ultrusmods.missingwilds.register.RegistryObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class JsonDefinedModCompatInstance
extends RegisteringModCompat {
    private final ModCompatJsonData modCompatJsonData;
    Map<LogData, RegistryObject<Block>> fallenLogBlocks = new HashMap<LogData, RegistryObject<Block>>();
    Map<JarData, RegistryObject<Block>> jarBlocks = new HashMap<JarData, RegistryObject<Block>>();
    Map<JarData, RegistryObject<Block>> fireflyJarBlocks = new HashMap<JarData, RegistryObject<Block>>();

    public JsonDefinedModCompatInstance(ModCompatJsonData modCompatJsonData) {
        super(modCompatJsonData.modid());
        this.modCompatJsonData = modCompatJsonData;
    }

    @Override
    public void init() {
    }

    @Override
    public void clientInit() {
    }

    @Override
    public void registerBlocks() {
        this.modCompatJsonData.logs().forEach(logData -> {
            RegistryObject<Block> block = MissingWildsBlocks.registerFallenLogFromData(logData, this.modCompatJsonData.modid());
            Services.PLATFORM.getModCompatHandler().addFallenLogBlock(block);
            this.fallenLogBlocks.put((LogData)logData, block);
        });
        this.modCompatJsonData.jars().forEach(jarData -> {
            RegistryObject<Block> block = MissingWildsBlocks.register(this.modCompatJsonData.modid() + "_" + jarData.name() + "_jar", MissingWildsBlocks::createJarBlock);
            RegistryObject<Block> foodJar = MissingWildsBlocks.register(this.modCompatJsonData.modid() + "_" + jarData.name() + "_food_jar", MissingWildsBlocks::createFoodJarBlock);
            RegistryObject<Block> fireflyJar = MissingWildsBlocks.register(this.modCompatJsonData.modid() + "_" + jarData.name() + "_firefly_jar", MissingWildsBlocks::createFireflyJarBlock);
            Services.PLATFORM.getModCompatHandler().addJarBlock((JarData)jarData, block);
            Services.PLATFORM.getModCompatHandler().addFoodJarBlock((JarData)jarData, foodJar);
            Services.PLATFORM.getModCompatHandler().addFireflyJarBlock((JarData)jarData, fireflyJar);
            JarMaps.JAR_TO_FIREFLY_JAR.put((Object)block.get(), (Object)fireflyJar.get());
            JarMaps.JAR_TO_FOOD_JAR.put((Object)block.get(), (Object)foodJar.get());
            this.jarBlocks.put((JarData)jarData, block);
            this.fireflyJarBlocks.put((JarData)jarData, fireflyJar);
        });
    }

    @Override
    public void registerItems() {
        this.fallenLogBlocks.forEach((logData, block) -> {
            RegistryObject<Item> item = MissingWildsItems.register(this.modCompatJsonData.modid() + "_" + logData.name(), block);
            Services.PLATFORM.getModCompatHandler().addFallenLogItem(item, (LogData)logData);
        });
        this.jarBlocks.forEach((jarData, block) -> MissingWildsItems.register(this.modCompatJsonData.modid() + "_" + jarData.name() + "_jar", block));
        this.fireflyJarBlocks.forEach((jarData, block) -> MissingWildsItems.registerFireflyJar(this.modCompatJsonData.modid() + "_" + jarData.name() + "_firefly_jar", block));
    }

    @Override
    public void registerBlockEntities() {
    }

    public ModCompatJsonData getModCompatJsonData() {
        return this.modCompatJsonData;
    }

    public void generateAssets(ResourceAdder resourceAdder) {
        for (LogData logData : this.modCompatJsonData.logs()) {
            this.createFallenLogBlockState(resourceAdder, logData);
            this.createFallenLogModels(resourceAdder, logData);
            this.createFallenLogRecipes(resourceAdder, logData);
            this.createFallenLogAdvancement(resourceAdder, logData);
            this.createFallenLogLootTable(resourceAdder, logData);
        }
        for (JarData jarData : this.modCompatJsonData.jars()) {
            this.createJarModels(resourceAdder, jarData);
            this.createJarRecipe(resourceAdder, jarData);
            this.createJarAdvancement(resourceAdder, jarData);
            this.createJarLootTables(resourceAdder, jarData);
        }
    }

    public void createFallenLogBlockState(ResourceAdder resourceAdder, LogData logData) {
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("blockstates/" + this.modid + "_" + logData.name() + ".json"), String.format("{\n  \"variants\": {\n    \"axis=x,cover=moss\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_mossy\",\n      \"y\": 90\n    },\n    \"axis=x,cover=none\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s\",\n      \"y\": 90\n    },\n    \"axis=x,cover=snow\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_snowy\",\n      \"y\": 90\n    },\n    \"axis=y,cover=moss\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_mossy\",\n      \"x\": 90\n    },\n    \"axis=y,cover=none\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s\",\n      \"x\": 90\n    },\n    \"axis=y,cover=snow\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_snowy\",\n      \"x\": 90\n    },\n    \"axis=z,cover=moss\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_mossy\"\n    },\n    \"axis=z,cover=none\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s\"\n    },\n    \"axis=z,cover=snow\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_snowy\"\n    }\n  }\n}\n", logData.name(), this.modid));
    }

    public void createFallenLogModels(ResourceAdder resourceAdder, LogData logData) {
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + logData.name() + ".json"), JsonDefinedModCompatInstance.getFallenLogModelText(logData, ""));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + logData.name() + "_mossy.json"), JsonDefinedModCompatInstance.getFallenLogModelText(logData, "_mossy"));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + logData.name() + "_snowy.json"), JsonDefinedModCompatInstance.getFallenLogModelText(logData, "_snowy"));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/item/" + this.modid + "_" + logData.name() + ".json"), JsonDefinedModCompatInstance.getParentedModelText(this.modid + "_" + logData.name()));
    }

    public void createFallenLogRecipes(ResourceAdder resourceAdder, LogData logData) {
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("recipes/" + this.modid + "_" + logData.name() + ".json"), String.format("{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"missingwilds:fallen_logs\",\n  \"key\": {\n    \"L\": {\n      \"item\": \"%2$s\"\n    }\n  },\n  \"pattern\": [\n    \"LLL\",\n    \"L L\",\n    \"LLL\"\n  ],\n  \"result\": {\n    \"count\": 8,\n    \"item\": \"missingwilds:%1$s_%3$s\"\n  }\n}\n", this.modid, logData.blockId(), logData.name()));
    }

    public void createFallenLogAdvancement(ResourceAdder resourceAdder, LogData logData) {
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("advancements/recipes/items/" + this.modid + "_" + logData.name() + ".json"), String.format("{\n  \"parent\": \"minecraft:recipes/root\",\n  \"criteria\": {\n    \"has_log\": {\n      \"conditions\": {\n        \"items\": [\n          {\n            \"items\": [\n              \"%2$s\"\n            ]\n          }\n        ]\n      },\n      \"trigger\": \"minecraft:inventory_changed\"\n    },\n    \"has_the_recipe\": {\n      \"conditions\": {\n        \"recipe\": \"missingwilds:%1$s_%3$s\"\n      },\n      \"trigger\": \"minecraft:recipe_unlocked\"\n    }\n  },\n  \"requirements\": [\n    [\n      \"has_log\",\n      \"has_the_recipe\"\n    ]\n  ],\n  \"rewards\": {\n    \"recipes\": [\n      \"missingwilds:%1$s_%3$s\"\n    ]\n  }\n}\n", this.modid, logData.blockId(), logData.name()));
    }

    public void createFallenLogLootTable(ResourceAdder resourceAdder, LogData logData) {
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("loot_tables/blocks/" + this.modid + "_" + logData.name() + ".json"), String.format("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"missingwilds:%s_%s\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}\n", this.modid, logData.name()));
    }

    public void createJarModels(ResourceAdder resourceAdder, JarData jarData) {
        String regularJarName = jarData.name() + "_jar";
        String fireflyJarName = jarData.name() + "_firefly_jar";
        String foodJarName = jarData.name() + "_food_jar";
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("blockstates/" + this.modid + "_" + regularJarName + ".json"), JsonDefinedModCompatInstance.getJarBlockstateJson(regularJarName, this.modid));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("blockstates/" + this.modid + "_" + fireflyJarName + ".json"), JsonDefinedModCompatInstance.getJarBlockstateJson(fireflyJarName, this.modid));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("blockstates/" + this.modid + "_" + foodJarName + ".json"), JsonDefinedModCompatInstance.getJarBlockstateJson(foodJarName, this.modid));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + regularJarName + ".json"), JsonDefinedModCompatInstance.getJarModelText(false, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + fireflyJarName + ".json"), JsonDefinedModCompatInstance.getJarModelText(false, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + foodJarName + ".json"), JsonDefinedModCompatInstance.getJarModelText(false, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + regularJarName + "_open.json"), JsonDefinedModCompatInstance.getJarModelText(true, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + fireflyJarName + "_open.json"), JsonDefinedModCompatInstance.getJarModelText(true, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/block/" + this.modid + "_" + foodJarName + "_open.json"), JsonDefinedModCompatInstance.getJarModelText(true, jarData));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/item/" + this.modid + "_" + regularJarName + ".json"), JsonDefinedModCompatInstance.getParentedModelText(this.modid + "_" + regularJarName));
        resourceAdder.addText(PackType.CLIENT_RESOURCES, Constants.id("models/item/" + this.modid + "_" + fireflyJarName + ".json"), JsonDefinedModCompatInstance.getParentedModelText(this.modid + "_" + fireflyJarName));
    }

    public void createJarRecipe(ResourceAdder resourceAdder, JarData data) {
        ResourceLocation id = Constants.id(this.modid + "_" + data.name() + "_jar");
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("recipes/" + this.modid + "_" + data.name() + "_jar.json"), String.format("{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"category\": \"misc\",\n  \"group\": \"missingwilds:glass_jars\",\n  \"key\": {\n    \"G\": {\n      \"item\": \"%s\"\n    },\n    \"P\": {\n      \"tag\": \"minecraft:planks\"\n    }\n  },\n  \"pattern\": [\n    \"GPG\",\n    \"G G\",\n    \"GGG\"\n  ],\n  \"result\": {\n    \"item\": \"%s\"\n  },\n  \"show_notification\": true\n}\n", data.blockId(), id));
    }

    public void createJarAdvancement(ResourceAdder resourceAdder, JarData data) {
        ResourceLocation recipeId = Constants.id(this.modid + "_" + data.name() + "_jar");
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("advancements/recipes/items/" + this.modid + "_" + data.name() + ".json"), String.format("{\n  \"parent\": \"minecraft:recipes/root\",\n  \"criteria\": {\n    \"has_glass\": {\n      \"conditions\": {\n        \"items\": [\n          {\n            \"items\": [\n              \"%1$s\"\n            ]\n          }\n        ]\n      },\n      \"trigger\": \"minecraft:inventory_changed\"\n    },\n    \"has_the_recipe\": {\n      \"conditions\": {\n        \"recipe\": \"%2$s\"\n      },\n      \"trigger\": \"minecraft:recipe_unlocked\"\n    }\n  },\n  \"requirements\": [\n    [\n      \"has_glass\",\n      \"has_the_recipe\"\n    ]\n  ],\n  \"rewards\": {\n    \"recipes\": [\n      \"%2$s\"\n    ]\n  },\n  \"sends_telemetry_event\": false\n}\n", data.blockId(), recipeId));
    }

    public void createJarLootTables(ResourceAdder resourceAdder, JarData jarData) {
        String jsonString = "{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"%s\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}\n";
        String regularJarName = jarData.name() + "_jar";
        String fireflyJarName = jarData.name() + "_firefly_jar";
        String foodJarName = jarData.name() + "_food_jar";
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("loot_tables/blocks/" + this.modid + "_" + regularJarName + ".json"), String.format(jsonString, Constants.id(this.modid + "_" + regularJarName)));
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("loot_tables/blocks/" + this.modid + "_" + foodJarName + ".json"), String.format(jsonString, Constants.id(this.modid + "_" + regularJarName)));
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("loot_tables/blocks/" + this.modid + "_" + fireflyJarName + ".json"), String.format("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:copy_name\",\n              \"source\": \"block_entity\"\n            },\n            {\n              \"block\": \"%1$s\",\n              \"function\": \"minecraft:copy_state\",\n              \"properties\": [\n                \"light_level\"\n              ]\n            },\n            {\n              \"function\": \"minecraft:copy_nbt\",\n              \"ops\": [\n                {\n                  \"op\": \"replace\",\n                  \"source\": \"color\",\n                  \"target\": \"BlockEntityTag.color\"\n                }\n              ],\n              \"source\": \"block_entity\"\n            }\n          ],\n          \"name\": \"%1$s\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}\n", Constants.id(this.modid + "_" + fireflyJarName)));
    }

    public static String getJarModelText(boolean isOpen, JarData jarData) {
        if (isOpen) {
            return String.format("{\n  \"parent\": \"missingwilds:block/template/glass_jar_open_template\",\n  \"textures\": {\n    \"glass\": \"%s\",\n    \"jar\": \"%s\"\n  }\n}\n", jarData.blockTexture(), jarData.jarTexture());
        }
        return String.format("{\n  \"parent\": \"missingwilds:block/template/glass_jar_template\",\n  \"textures\": {\n    \"glass\": \"%s\",\n    \"jar\": \"%s\"\n  }\n}\n", jarData.blockTexture(), jarData.jarTexture());
    }

    public static String getFallenLogModelText(LogData data, String type) {
        return String.format("{\n  \"parent\": \"missingwilds:block/template/fallen_log_template%s\",\n  \"textures\": {\n    \"log\": \"%s\",\n    \"log_inner\": \"%s\"\n  }\n}\n", type, data.logTexture(), data.strippedLogTexture());
    }

    private static String getParentedModelText(String blockModel) {
        return String.format("{\n  \"parent\": \"missingwilds:block/%s\"\n}\n", blockModel);
    }

    public static void generateFallenLogTags(ResourceAdder resourceAdder) {
        List<ResourceLocation> logList = Services.PLATFORM.getModCompatHandler().getFallenLogBlocks().stream().map(RegistryObject::getId).toList();
        resourceAdder.addText(PackType.SERVER_DATA, Constants.id("tags/blocks/fallen_logs.json"), String.format("{\n    \"replace\": false,\n    \"values\": [\n        %s\n    ]\n    }\n", String.join((CharSequence)", ", logList.stream().map(log -> "\"" + log + "\"").toList())));
    }

    public static String getJarBlockstateJson(String id, String modId) {
        return String.format("{\n  \"variants\": {\n    \"covered=false\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s_open\"\n    },\n    \"covered=true\": {\n      \"model\": \"missingwilds:block/%2$s_%1$s\"\n    }\n  }\n}\n", id, modId);
    }

    public static interface ResourceAdder {
        public void add(PackType var1, ResourceLocation var2, byte[] var3);

        default public void addText(PackType type, ResourceLocation id, String text) {
            this.add(type, id, text.getBytes(StandardCharsets.UTF_8));
        }
    }
}

