/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ultrusmods.missingwilds.compat.ModCompatInstance;
import me.ultrusmods.missingwilds.data.JarData;
import me.ultrusmods.missingwilds.data.LogData;
import me.ultrusmods.missingwilds.register.RegistryObject;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class ModCompatHandler {
    public List<ModCompatInstance> enabledModCompats = new ArrayList<ModCompatInstance>();
    public final Map<LogData, RegistryObject<Item>> FALLEN_LOG_ITEMS = new HashMap<LogData, RegistryObject<Item>>();
    public final List<RegistryObject<Block>> FALLEN_LOG_BLOCKS = new ArrayList<RegistryObject<Block>>();
    public final List<RegistryObject<Item>> OTHER_ITEMS_TO_ITEM_GROUPS = new ArrayList<RegistryObject<Item>>();
    public final Map<JarData, RegistryObject<Block>> JAR_BLOCKS = new HashMap<JarData, RegistryObject<Block>>();
    public final Map<JarData, RegistryObject<Block>> FIREFLY_JAR_BLOCKS = new HashMap<JarData, RegistryObject<Block>>();
    public final Map<JarData, RegistryObject<Block>> FOOD_JAR_BLOCKS = new HashMap<JarData, RegistryObject<Block>>();

    public abstract void loadModCompat();

    public void init() {
        if (this.isJsonModCompatEnabled()) {
            this.loadModCompat();
        }
    }

    public abstract boolean isJsonModCompatEnabled();

    public List<ModCompatInstance> getModCompats() {
        return this.enabledModCompats;
    }

    public void addModCompat(ModCompatInstance modCompat) {
        this.enabledModCompats.add(modCompat);
    }

    public void addFallenLogItem(RegistryObject<Item> item, LogData logData) {
        this.FALLEN_LOG_ITEMS.put(logData, item);
    }

    public void addFallenLogBlock(RegistryObject<Block> block) {
        this.FALLEN_LOG_BLOCKS.add(block);
    }

    public Map<LogData, RegistryObject<Item>> getFallenLogItems() {
        return this.FALLEN_LOG_ITEMS;
    }

    public List<RegistryObject<Block>> getFallenLogBlocks() {
        return this.FALLEN_LOG_BLOCKS;
    }

    public void addJarBlock(JarData jarData, RegistryObject<Block> block) {
        this.JAR_BLOCKS.put(jarData, block);
    }

    public void addFoodJarBlock(JarData jarData, RegistryObject<Block> block) {
        this.FOOD_JAR_BLOCKS.put(jarData, block);
    }

    public void addFireflyJarBlock(JarData jarData, RegistryObject<Block> block) {
        this.FIREFLY_JAR_BLOCKS.put(jarData, block);
    }

    public Map<JarData, RegistryObject<Block>> getJarBlocks() {
        return this.JAR_BLOCKS;
    }

    public Map<JarData, RegistryObject<Block>> getFoodJarBlocks() {
        return this.FOOD_JAR_BLOCKS;
    }

    public Map<JarData, RegistryObject<Block>> getFireflyJarBlocks() {
        return this.FIREFLY_JAR_BLOCKS;
    }

    public void addItemToItemGroup(RegistryObject<Item> item) {
        this.OTHER_ITEMS_TO_ITEM_GROUPS.add(item);
    }
}

