/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.entity;

import me.ultrusmods.missingwilds.JarMaps;
import me.ultrusmods.missingwilds.item.FireflyJarItem;
import me.ultrusmods.missingwilds.particle.FireflyParticleOptions;
import me.ultrusmods.missingwilds.register.MissingWildsItems;
import me.ultrusmods.missingwilds.register.MissingWildsSounds;
import me.ultrusmods.missingwilds.tags.MissingWildsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FireflySwarm
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(FireflySwarm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STILL = SynchedEntityData.m_135353_(FireflySwarm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockPos nextPosition = null;
    private int waitTime = 0;
    private int pickNewPosTimer = 0;
    private boolean dayLightSafe = false;

    public FireflySwarm(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)3);
        this.f_19804_.m_135372_(STILL, (Object)true);
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
        $$0.m_128379_("DayLightSafe", this.dayLightSafe);
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
        this.dayLightSafe = $$0.m_128471_("DayLightSafe");
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(SIZE);
    }

    public boolean isStill() {
        return (Boolean)this.f_19804_.m_135370_(STILL);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_9236_().m_46461_() && !this.dayLightSafe && this.f_19796_.m_188503_(100) <= 10) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < this.getSize() * 3; ++i) {
                if (this.m_217043_().m_188503_(25) != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)new FireflyParticleOptions(0.6f, 0.92f, 0.2f, 100, 0.0035f), this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)this.f_19796_.m_188501_(), this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public EntityDimensions m_6972_(Pose $$0) {
        return super.m_6972_($$0).m_20388_(this.isStill() ? 1.0f : 0.1f);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_5789_() {
        return false;
    }

    protected void m_6138_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
    }

    protected void m_8024_() {
        super.m_8024_();
        ++this.pickNewPosTimer;
        if (this.nextPosition == null && this.waitTime <= 0 || this.pickNewPosTimer >= 200) {
            if ((double)this.f_19796_.m_188501_() < 0.2) {
                this.waitTime = this.f_19796_.m_216339_(200, 600);
            } else {
                BlockHitResult pos = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82520_((double)this.f_19796_.m_216339_(-8, 10), (double)this.f_19796_.m_216339_(-4, 6), (double)this.f_19796_.m_216339_(-8, 10)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (!this.m_9236_().m_8055_(pos.m_82425_()).m_60795_()) {
                    this.nextPosition = null;
                    this.setStill(true);
                } else {
                    this.nextPosition = pos.m_82425_();
                    this.setStill(false);
                    this.pickNewPosTimer = 0;
                }
            }
        }
        if (this.nextPosition != null) {
            this.m_20256_(this.m_20184_().m_165921_(new Vec3((double)(this.nextPosition.m_123341_() + this.f_19796_.m_216339_(-3, 4)) - this.m_20185_(), (double)this.nextPosition.m_123342_() - this.m_20186_(), (double)(this.nextPosition.m_123343_() + this.f_19796_.m_216339_(-3, 4)) - this.m_20189_()).m_82541_().m_82542_((double)0.3f, (double)0.3f, (double)0.3f), 0.1));
        }
        if (this.nextPosition != null && this.m_20275_(this.nextPosition.m_123341_(), this.nextPosition.m_123342_(), this.nextPosition.m_123343_()) < 3.0) {
            this.nextPosition = null;
            this.setStill(true);
        }
        --this.waitTime;
    }

    void setStill(boolean still) {
        this.f_19804_.m_135381_(STILL, (Object)still);
    }

    public void m_7350_(EntityDataAccessor<?> $$0) {
        if (STILL.equals($$0)) {
            this.m_6210_();
        }
        super.m_7350_($$0);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        BlockItem blockItem;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42590_)) {
            player.m_216990_(SoundEvents.f_11770_);
            player.m_21120_(hand).m_41774_(1);
            player.m_36356_(MissingWildsItems.FIREFLY_BOTTLE_ITEM.get().m_7968_());
            this.shrink();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (stack.m_41720_() instanceof FireflyJarItem) {
            FireflyJarItem.increaseLightLevel(stack, 3);
            player.m_5496_(MissingWildsSounds.JAR_OPEN.get(), 1.0f, 1.0f);
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && JarMaps.JAR_TO_FIREFLY_JAR.containsKey((Object)(blockItem = (BlockItem)item).m_40614_())) {
            player.m_5496_(MissingWildsSounds.JAR_OPEN.get(), 1.0f, 1.0f);
            ItemStack newStack = ((Block)JarMaps.JAR_TO_FIREFLY_JAR.get((Object)blockItem.m_40614_())).m_5456_().m_7968_();
            FireflyJarItem.increaseLightLevel(newStack, 3);
            player.m_21008_(hand, newStack);
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private void shrink() {
        if (this.getSize() > 1) {
            this.f_19804_.m_135381_(SIZE, (Object)(this.getSize() - 1));
        } else {
            this.m_146870_();
        }
    }

    public static boolean checkFireflySpawnRules(EntityType<? extends FireflySwarm> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        if (level.m_204166_(blockPos).m_203656_(MissingWildsTags.SPAWNS_FIREFLY_SWARMS) && blockPos.m_123342_() > 60 && blockPos.m_123342_() < 70) {
            return random.m_188501_() < 0.7f && random.m_188501_() > level.m_46940_();
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 16.0);
    }
}

