/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import me.ultrusmods.missingwilds.register.MissingWildsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class FireflyParticleOptions
implements ParticleOptions {
    public static final Codec<FireflyParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(options -> Float.valueOf(options.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(options -> Float.valueOf(options.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(options -> Float.valueOf(options.blue)), (App)Codec.FLOAT.fieldOf("scale").forGetter(options -> Float.valueOf(options.scale)), (App)Codec.FLOAT.fieldOf("speedMultiplier").forGetter(options -> Float.valueOf(options.speedMultiplier))).apply((Applicative)instance, FireflyParticleOptions::new));
    public static final ParticleOptions.Deserializer<FireflyParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<FireflyParticleOptions>(){

        public FireflyParticleOptions fromCommand(ParticleType<FireflyParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = reader.readFloat();
            reader.expect(' ');
            float green = reader.readFloat();
            reader.expect(' ');
            float blue = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            float speedMultiplier = reader.readFloat();
            return new FireflyParticleOptions(red, green, blue, scale, speedMultiplier);
        }

        public FireflyParticleOptions fromNetwork(ParticleType<FireflyParticleOptions> particleType, FriendlyByteBuf buf) {
            float red = buf.readFloat();
            float green = buf.readFloat();
            float blue = buf.readFloat();
            float scale = buf.readFloat();
            float speedMultiplier = buf.readFloat();
            return new FireflyParticleOptions(red, green, blue, scale, speedMultiplier);
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final int lifetime;
    private final float speedMultiplier;

    public FireflyParticleOptions(float red, float green, float blue, float scale, float speedMultiplier) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.lifetime = (int)(Math.random() * 120.0) + 180;
        this.scale = scale;
        this.speedMultiplier = speedMultiplier;
    }

    public FireflyParticleOptions(double red, double green, double blue, float scale, float speedMultiplier) {
        this((float)red, (float)green, (float)blue, scale, speedMultiplier);
    }

    public FireflyParticleOptions(float red, float green, float blue, int lifetime, float speedMultiplier) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.lifetime = lifetime;
        this.speedMultiplier = speedMultiplier;
        this.scale = 1.0f;
    }

    public ParticleType<FireflyParticleOptions> m_6012_() {
        return MissingWildsParticles.FIREFLY.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(this.speedMultiplier);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public float getScale() {
        return this.scale;
    }
}

