/*
 * Decompiled with CFR 0.152.
 */
package xyz.ketok.wilderness.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class FallenTreeFeature
extends Feature<Config> {
    public FallenTreeFeature() {
        super(Config.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        boolean generateStump;
        WorldGenLevel level = context.m_159774_();
        BlockPos startPos = context.m_159777_();
        Config config = (Config)context.m_159778_();
        RandomSource random = context.m_225041_();
        Direction direction = random.m_188499_() ? (random.m_188499_() ? Direction.EAST : Direction.WEST) : (random.m_188499_() ? Direction.NORTH : Direction.SOUTH);
        int length = config.length.m_214085_(random);
        boolean bl = generateStump = random.m_188501_() < 0.75f;
        if (!this.canPlace(level, startPos, length, direction, generateStump) && (direction = this.getValidDirection(level, startPos, length, generateStump)) == null) {
            return false;
        }
        HashSet<BlockPos> placedLogs = new HashSet<BlockPos>(length + (generateStump ? 1 : 0));
        if (generateStump) {
            level.m_7731_(startPos, config.block.m_213972_(random, startPos), 2);
            placedLogs.add(startPos);
            startPos = startPos.m_5484_(direction, 2);
        }
        for (int i = 0; i < length; ++i) {
            BlockPos pos = startPos.m_5484_(direction, i);
            BlockState block = config.block.m_213972_(random, pos);
            if (block.m_60734_() instanceof RotatedPillarBlock) {
                block = (BlockState)block.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
            }
            level.m_7731_(pos, block, 2);
            placedLogs.add(pos);
        }
        config.decorators.forEach(decorator -> decorator.m_214187_(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, block) -> level.m_7731_(pos, block, 19), random, placedLogs, Set.of(), Set.of())));
        return true;
    }

    private boolean canPlace(WorldGenLevel level, BlockPos startPos, int length, Direction direction, boolean generateStump) {
        if (generateStump) {
            length += 2;
        }
        for (int i = 0; i < length; ++i) {
            BlockPos pos = startPos.m_5484_(direction, i);
            if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos) && FallenTreeFeature.m_159759_((BlockState)level.m_8055_(pos.m_7495_()))) continue;
            return false;
        }
        return true;
    }

    private Direction getValidDirection(WorldGenLevel level, BlockPos startPos, int length, boolean generateStump) {
        for (Direction dir : List.of(Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH)) {
            if (!this.canPlace(level, startPos, length, dir, generateStump)) continue;
            return dir;
        }
        return null;
    }

    public record Config(BlockStateProvider block, IntProvider length, List<TreeDecorator> decorators) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(config -> config.block), (App)IntProvider.f_146533_.fieldOf("length").forGetter(config -> config.length), (App)Codec.list((Codec)TreeDecorator.f_70021_).fieldOf("decorators").forGetter(config -> config.decorators)).apply((Applicative)builder, Config::new));
    }
}

