/*
 * Decompiled with CFR 0.152.
 */
package xyz.ketok.wilderness.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;
import xyz.ketok.wilderness.registry.WdFeatures;

public class BlockOnLogDecorator
extends TreeDecorator {
    public static final Codec<BlockOnLogDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.f_61039_.fieldOf("block").forGetter(config -> config.block), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(config -> Float.valueOf(config.chance)), (App)Codec.BOOL.fieldOf("on_top").forGetter(config -> config.onTop)).apply((Applicative)builder, BlockOnLogDecorator::new));
    public final BlockState block;
    public final float chance;
    public final boolean onTop;

    public BlockOnLogDecorator(BlockState block, float chance, boolean onTop) {
        this.block = block;
        this.chance = chance;
        this.onTop = onTop;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)WdFeatures.TreeDecorators.BLOCK_ON_LOG.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        for (BlockPos pos : context.m_226068_()) {
            if (this.onTop) {
                BlockPos placePos = pos.m_7494_();
                if (!context.m_226059_(placePos) || !(context.m_226067_().m_188501_() < this.chance)) continue;
                context.m_226061_(placePos, this.block);
                continue;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos placePos = pos.m_121945_(dir);
                if (!context.m_226059_(placePos) || !(context.m_226067_().m_188501_() < this.chance)) continue;
                BlockState blockToPlace = this.block;
                if (blockToPlace.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    blockToPlace = (BlockState)blockToPlace.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir);
                }
                context.m_226061_(placePos, blockToPlace);
            }
        }
    }
}

