/*
 * Decompiled with CFR 0.152.
 */
package xyz.ketok.wilderness.forge.data.server.registry;

import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class WdBiomeBuilder {
    private BiomeGenerationSettings generation;
    private MobSpawnSettings spawns;
    private Float temperature;
    private Float downfall;
    private Biome.TemperatureModifier temperatureModifier = Biome.TemperatureModifier.NONE;
    private boolean hasPrecipitation = true;
    private BiomeSpecialEffects.Builder specialEffects = new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463);

    public WdBiomeBuilder generationAndSpawns(BiomeGenerationSettings.Builder generation, MobSpawnSettings.Builder spawns) {
        this.generation = generation.m_255380_();
        this.spawns = spawns.m_48381_();
        return this;
    }

    public WdBiomeBuilder temperatureAndDownfall(float temperature, float downfall) {
        this.temperature = Float.valueOf(temperature);
        this.downfall = Float.valueOf(downfall);
        this.specialEffects.m_48040_(WdBiomeBuilder.calculateSkyColor(temperature));
        return this;
    }

    public WdBiomeBuilder temperatureAdjustment(Biome.TemperatureModifier temperatureSettings) {
        this.temperatureModifier = temperatureSettings;
        return this;
    }

    public WdBiomeBuilder hasPrecipitation(boolean hasPrecipitation) {
        this.hasPrecipitation = hasPrecipitation;
        return this;
    }

    public WdBiomeBuilder specialEffects(Consumer<BiomeSpecialEffects.Builder> specialEffectsModifications) {
        specialEffectsModifications.accept(this.specialEffects);
        return this;
    }

    public Biome build() {
        if (this.generation != null && this.spawns != null && this.temperature != null && this.downfall != null) {
            return new Biome.BiomeBuilder().m_264558_(this.hasPrecipitation).m_47609_(this.temperature.floatValue()).m_47611_(this.downfall.floatValue()).m_47603_(this.specialEffects.m_48018_()).m_47605_(this.spawns).m_47601_(this.generation).m_47599_(this.temperatureModifier).m_47592_();
        }
        throw new IllegalStateException("You are missing parameters to build a proper biome");
    }

    private static int calculateSkyColor(float temperature) {
        float $$1 = temperature / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }
}

