/*
 * Decompiled with CFR 0.152.
 */
package xyz.ketok.wilderness.forge.data.server.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import xyz.ketok.wilderness.forge.data.server.registry.WdBiomeBuilder;
import xyz.ketok.wilderness.registry.dynamic.WdBiomes;
import xyz.ketok.wilderness.registry.dynamic.WdPlacedFeatures;

public class WdBiomeProvider {
    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(WdBiomes.OLD_GROWTH_FOREST, (Object)WdBiomeProvider.createOldGrowthForestBiome(context));
        context.m_255272_(WdBiomes.MIXED_FOREST, (Object)WdBiomeProvider.createMixedForestBiome(context));
    }

    private static Biome createOldGrowthForestBiome(BootstapContext<Biome> context) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        WdBiomeProvider.globalOverworldGeneration(generation);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WdPlacedFeatures.PATCH_GRASS_OLD_GROWTH);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WdPlacedFeatures.PATCH_TALL_GRASS_OLD_GROWTH);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WdPlacedFeatures.TREES_OLD_GROWTH_FOREST);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WdPlacedFeatures.BROWN_RED_MUSHROOM_PATCH);
        generation.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WdPlacedFeatures.FOREST_ROCK_RARE);
        generation.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WdPlacedFeatures.PATCH_MOSS);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 2, 2, 3));
        return new WdBiomeBuilder().generationAndSpawns(generation, spawns).temperatureAndDownfall(0.7f, 0.8f).build();
    }

    private static Biome createMixedForestBiome(BootstapContext<Biome> context) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        WdBiomeProvider.globalOverworldGeneration(generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195460_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)generation);
        generation.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, WdPlacedFeatures.TREES_MIXED_FOREST);
        generation.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WdPlacedFeatures.FOREST_ROCK_RARE);
        generation.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WdPlacedFeatures.PATCH_COARSE_DIRT);
        generation.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, WdPlacedFeatures.PATCH_PODZOL);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 2, 2, 3));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        return new WdBiomeBuilder().generationAndSpawns(generation, spawns).temperatureAndDownfall(0.5f, 0.8f).build();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder generation) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generation);
    }
}

