/*
 * Decompiled with CFR 0.152.
 */
package xyz.ketok.wilderness.region;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import xyz.ketok.wilderness.registry.dynamic.WdBiomes;

public class WildernessRegionBuilder {
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{null, null, null, null, null}, {null, null, WdBiomes.MIXED_FOREST, null, null}, {null, null, null, WdBiomes.OLD_GROWTH_FOREST, WdBiomes.OLD_GROWTH_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    private static final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, WdBiomes.MIXED_FOREST, null}, {null, null, null, null, null}, {null, null, null, null, null}};
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private static final float EROSION_DEEP_DARK_DRYNESS_THRESHOLD = -0.225f;
    private static final float DEPTH_DEEP_DARK_DRYNESS_THRESHOLD = 0.9f;
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> key) {
        this.addInlandBiomes(key);
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(consumer, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(consumer, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(consumer, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter param) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter parameter2 = this.humidities[j];
                ResourceKey<Biome> resourceKey = this.pickMiddleBiome(i, j, param);
                ResourceKey<Biome> resourceKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, param);
                ResourceKey<Biome> resourceKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, param);
                ResourceKey<Biome> resourceKey4 = this.pickPlateauBiome(i, j, param);
                ResourceKey<Biome> resourceKey5 = this.pickShatteredBiome(i, j, param);
                ResourceKey<Biome> resourceKey6 = this.maybePickWindsweptSavannaBiome(i, j, param, resourceKey5);
                ResourceKey<Biome> resourceKey7 = this.pickPeakBiome(i, j, param);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], param, 0.0f, resourceKey7);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], param, 0.0f, resourceKey3);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], param, 0.0f, resourceKey7);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], param, 0.0f, resourceKey4);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.midInlandContinentalness, this.erosions[3], param, 0.0f, resourceKey2);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.farInlandContinentalness, this.erosions[3], param, 0.0f, resourceKey4);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey6);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey5);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], param, 0.0f, resourceKey);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter param) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter parameter2 = this.humidities[j];
                ResourceKey<Biome> resourceKey = this.pickMiddleBiome(i, j, param);
                ResourceKey<Biome> resourceKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, param);
                ResourceKey<Biome> resourceKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, param);
                ResourceKey<Biome> resourceKey4 = this.pickPlateauBiome(i, j, param);
                ResourceKey<Biome> resourceKey5 = this.pickShatteredBiome(i, j, param);
                ResourceKey<Biome> resourceKey6 = this.maybePickWindsweptSavannaBiome(i, j, param, resourceKey);
                ResourceKey<Biome> resourceKey7 = this.pickSlopeBiome(i, j, param);
                ResourceKey<Biome> resourceKey8 = this.pickPeakBiome(i, j, param);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, this.erosions[0], param, 0.0f, resourceKey7);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], param, 0.0f, resourceKey8);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, this.erosions[1], param, 0.0f, resourceKey3);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], param, 0.0f, resourceKey7);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], param, 0.0f, resourceKey4);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.midInlandContinentalness, this.erosions[3], param, 0.0f, resourceKey2);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.farInlandContinentalness, this.erosions[3], param, 0.0f, resourceKey4);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey6);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey5);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], param, 0.0f, resourceKey);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter param) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter parameter2 = this.humidities[j];
                ResourceKey<Biome> resourceKey = this.pickMiddleBiome(i, j, param);
                ResourceKey<Biome> resourceKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, param);
                ResourceKey<Biome> resourceKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, param);
                ResourceKey<Biome> resourceKey4 = this.pickShatteredBiome(i, j, param);
                ResourceKey<Biome> resourceKey5 = this.pickPlateauBiome(i, j, param);
                ResourceKey<Biome> resourceKey6 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourceKey7 = this.maybePickWindsweptSavannaBiome(i, j, param, resourceKey);
                ResourceKey<Biome> resourceKey8 = this.pickShatteredCoastBiome(i, j, param);
                ResourceKey<Biome> resourceKey9 = this.pickSlopeBiome(i, j, param);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], param, 0.0f, resourceKey9);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], param, 0.0f, resourceKey3);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.farInlandContinentalness, this.erosions[1], param, 0.0f, i == 0 ? resourceKey9 : resourceKey5);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, this.erosions[2], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.midInlandContinentalness, this.erosions[2], param, 0.0f, resourceKey2);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.farInlandContinentalness, this.erosions[2], param, 0.0f, resourceKey5);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], param, 0.0f, resourceKey2);
                if (param.f_186814_() < 0L) {
                    this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[4], param, 0.0f, resourceKey6);
                    this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], param, 0.0f, resourceKey);
                } else {
                    this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], param, 0.0f, resourceKey);
                }
                this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[5], param, 0.0f, resourceKey8);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, this.erosions[5], param, 0.0f, resourceKey7);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey4);
                if (param.f_186814_() < 0L) {
                    this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[6], param, 0.0f, resourceKey6);
                } else {
                    this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[6], param, 0.0f, resourceKey);
                }
                if (i != 0) continue;
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], param, 0.0f, resourceKey);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter param) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter parameter2 = this.humidities[j];
                ResourceKey<Biome> resourceKey = this.pickMiddleBiome(i, j, param);
                ResourceKey<Biome> resourceKey2 = this.pickMiddleBiomeOrBadlandsIfHot(i, j, param);
                ResourceKey<Biome> resourceKey3 = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(i, j, param);
                ResourceKey<Biome> resourceKey4 = this.pickBeachBiome(i, j);
                ResourceKey<Biome> resourceKey5 = this.maybePickWindsweptSavannaBiome(i, j, param, resourceKey);
                ResourceKey<Biome> resourceKey6 = this.pickShatteredCoastBiome(i, j, param);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), param, 0.0f, resourceKey2);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), param, 0.0f, resourceKey3);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), param, 0.0f, resourceKey2);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), param, 0.0f, resourceKey4);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[5], param, 0.0f, resourceKey6);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.nearInlandContinentalness, this.erosions[5], param, 0.0f, resourceKey5);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], param, 0.0f, resourceKey);
                this.addSurfaceBiome(consumer, parameter, parameter2, this.coastContinentalness, this.erosions[6], param, 0.0f, resourceKey4);
                if (i != 0) continue;
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], param, 0.0f, resourceKey);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter param) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter parameter = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter parameter2 = this.humidities[j];
                ResourceKey<Biome> resourceKey = this.pickMiddleBiomeOrBadlandsIfHot(i, j, param);
                this.addSurfaceBiome(consumer, parameter, parameter2, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), param, 0.0f, resourceKey);
            }
        }
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter param) {
        if (param.f_186814_() < 0L) {
            return MIDDLE_BIOMES[temperature][humidity];
        }
        ResourceKey<Biome> resourceKey = MIDDLE_BIOMES_VARIANT[temperature][humidity];
        return resourceKey == null ? MIDDLE_BIOMES[temperature][humidity] : resourceKey;
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHot(int temperature, int humidity, Climate.Parameter param) {
        return temperature == 4 ? this.pickBadlandsBiome(humidity, param) : this.pickMiddleBiome(temperature, humidity, param);
    }

    private ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfCold(int temperature, int humidity, Climate.Parameter param) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, param) : this.pickMiddleBiomeOrBadlandsIfHot(temperature, humidity, param);
    }

    private ResourceKey<Biome> maybePickWindsweptSavannaBiome(int temperature, int humidity, Climate.Parameter param, ResourceKey<Biome> key) {
        return temperature > 1 && humidity < 4 && param.f_186814_() >= 0L ? null : key;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter param) {
        ResourceKey<Biome> resourceKey = param.f_186814_() >= 0L ? this.pickMiddleBiome(temperature, humidity, param) : this.pickBeachBiome(temperature, humidity);
        return this.maybePickWindsweptSavannaBiome(temperature, humidity, param, resourceKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature, int humidity) {
        return null;
    }

    private ResourceKey<Biome> pickBadlandsBiome(int humidity, Climate.Parameter param) {
        return null;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter param) {
        return null;
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter param) {
        return null;
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter param) {
        return null;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter param) {
        return this.pickMiddleBiome(temperature, humidity, param);
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter depth, float weirdness, ResourceKey<Biome> key) {
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)depth, (float)weirdness), key));
        consumer.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)depth, (float)weirdness), key));
    }
}

