/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.client.gui.component.ToggleButton;
import me.paulf.fairylights.util.styledstring.Style;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StyledStringBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public final class StyledTextFieldWidget
extends AbstractWidget {
    private static final Predicate<String> ALWAYS_TRUE = str -> true;
    private static final Function<String, String> IDENTITY_CHARACTER_TRANSFORMER = c -> c;
    private final Font font;
    private final int multiClickInterval = StyledTextFieldWidget.getMultiClickInterval();
    private final ColorButton colorBtn;
    private final ToggleButton boldBtn;
    private final ToggleButton italicBtn;
    private final ToggleButton underlineBtn;
    private final ToggleButton strikethroughBtn;
    private StyledString value;
    private int maxLength = 32;
    private int tick;
    private boolean hasBackground = true;
    private boolean isBlurable = true;
    private boolean isFocused;
    private boolean isWritable = true;
    private boolean isVisible = true;
    private int lineScrollOffset;
    private int caret;
    private int selectionEnd;
    private int writableTextColor = 0xE0E0E0;
    private int readonlyTextColor = 0x707070;
    private boolean isDraggingSelection;
    private boolean hasDraggedSelecton;
    private boolean isPressed;
    private long lastClickTime;
    private int multiClicks;
    private Function<String, String> charInputTransformer = IDENTITY_CHARACTER_TRANSFORMER;
    private Predicate<String> validator = ALWAYS_TRUE;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private Style currentStyle;

    public StyledTextFieldWidget(Font font, ColorButton colorBtn, ToggleButton boldBtn, ToggleButton italicBtn, ToggleButton underlineBtn, ToggleButton strikethroughBtn, int x, int y, int width, int height, Component msg) {
        super(x, y, width, height, msg);
        this.font = font;
        this.colorBtn = colorBtn;
        this.boldBtn = boldBtn;
        this.italicBtn = italicBtn;
        this.underlineBtn = underlineBtn;
        this.strikethroughBtn = strikethroughBtn;
        this.setValue0(new StyledString());
        this.setStyle(new Style());
    }

    public void setIsBlurable(boolean isBlurable) {
        this.isBlurable = isBlurable;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void updateStyling(ChatFormatting styling, boolean state) {
        int start = this.caret;
        int end = this.selectionEnd;
        if (start == end) {
            this.withStyling(styling, state);
        } else {
            if (end < start) {
                int t = start;
                start = end;
                end = t;
            }
            this.setValue0(this.value.withStyling(start, end, styling, state));
            this.updateSelectionControls();
        }
    }

    public void setColor(ChatFormatting color) {
        this.setStyle(this.currentStyle.withColor(color));
    }

    public void withStyling(ChatFormatting styling, boolean state) {
        this.setStyle(this.currentStyle.withStyling(styling, state));
    }

    public void setStyle(Style style) {
        this.currentStyle = style;
        this.colorBtn.setDisplayColor(this.currentStyle.getColor());
        this.boldBtn.setValue(style.isBold());
        this.italicBtn.setValue(style.isItalic());
        this.underlineBtn.setValue(style.isUnderline());
        this.strikethroughBtn.setValue(style.isStrikethrough());
    }

    public ChatFormatting getColor() {
        return this.currentStyle.getColor();
    }

    public void setValue(String value) {
        this.setValue(new StyledString(value, this.currentStyle));
    }

    public void setValue(StyledString value) {
        if (this.validator.test(value.toUnstyledString())) {
            if (value.length() > this.maxLength) {
                this.setValue0(value.substring(0, this.maxLength));
            } else {
                this.setValue0(value);
            }
        }
    }

    private void setValue0(StyledString value) {
        this.value = value;
        for (ChangeListener listener : this.changeListeners) {
            listener.onChange(value);
        }
    }

    public String getUnstyledValue() {
        return this.value.toUnstyledString();
    }

    public StyledString getValue() {
        return this.value;
    }

    public String getUnstyledSelectedText() {
        return this.getSelectedText().toUnstyledString();
    }

    public StyledString getSelectedText() {
        int end = this.selectionEnd;
        int start = this.caret;
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        return this.value.substring(start, end);
    }

    public void setCaretStart() {
        this.setCaret(0);
    }

    public void setCaretEnd() {
        this.setCaret(this.value.length());
    }

    public void setCaret(int pos) {
        this.setCaret(pos, true);
    }

    public void setCaret(int pos, boolean changeColor) {
        this.caret = Mth.m_14045_((int)pos, (int)0, (int)this.value.length());
        this.setSelectionPos(this.caret);
        if (changeColor) {
            this.setCurrentStyleByIndex(this.caret);
        }
        this.tick = 0;
    }

    private void setCurrentStyleByIndex(int index) {
        if (this.value.length() > 0) {
            this.setStyle(this.value.styleAt(index <= 0 ? 0 : index - 1));
        }
    }

    public int getCaret() {
        return this.caret;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public Style getStyle() {
        return this.currentStyle;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setHasBackground(boolean hasBackground) {
        this.hasBackground = hasBackground;
    }

    public void setTextColor(int writableTextColor) {
        this.writableTextColor = writableTextColor & 0xFFFFFF;
    }

    public void setReadonlyTextColor(int readonlyTextColor) {
        this.readonlyTextColor = readonlyTextColor & 0xFFFFFF;
    }

    public void m_93692_(boolean isFocused) {
        if (isFocused) {
            if (!this.isFocused) {
                this.tick = 0;
            }
        } else if (this.selectionEnd != this.caret) {
            this.setSelectionPos(this.caret);
        }
        this.isFocused = isFocused;
    }

    public boolean m_93696_() {
        return this.isFocused;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }

    public void setCharInputTransformer(Function<String, String> charTransformer) {
        this.charInputTransformer = charTransformer;
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public int getInnerWidth() {
        return this.hasBackground ? this.f_93618_ - 8 : this.f_93618_;
    }

    public void setSelectionPos(int pos) {
        int w;
        int len = this.value.length();
        this.selectionEnd = Mth.m_14045_((int)pos, (int)0, (int)len);
        if (this.lineScrollOffset > len) {
            this.lineScrollOffset = len;
        }
        if (this.selectionEnd > (w = StyledTextFieldWidget.trimToWidth(this.value.substring(this.lineScrollOffset), this.font, this.getInnerWidth(), true).length()) + this.lineScrollOffset) {
            this.lineScrollOffset = this.selectionEnd - w;
        } else if (this.selectionEnd <= this.lineScrollOffset) {
            this.lineScrollOffset = this.selectionEnd;
        }
        this.lineScrollOffset = Mth.m_14045_((int)this.lineScrollOffset, (int)0, (int)len);
        if (this.caret != this.selectionEnd) {
            this.updateSelectionControls();
        }
    }

    private void updateSelectionControls() {
        StyledString selected = this.getSelectedText();
        ChatFormatting color = null;
        boolean consistantColor = true;
        boolean bold = true;
        boolean italic = true;
        boolean underline = true;
        boolean strikethrough = true;
        for (int i = 0; i < selected.length(); ++i) {
            Style s = selected.styleAt(i);
            if (color != null && color != s.getColor()) {
                color = null;
                consistantColor = false;
            }
            if (consistantColor) {
                color = s.getColor();
            }
            if (!s.isBold()) {
                bold = false;
            }
            if (!s.isItalic()) {
                italic = false;
            }
            if (!s.isUnderline()) {
                underline = false;
            }
            if (s.isStrikethrough()) continue;
            strikethrough = false;
        }
        this.setStyle(new Style(color == null ? this.currentStyle.getColor() : color, bold, strikethrough, underline, italic, false));
        if (!consistantColor) {
            this.colorBtn.removeDisplayColor();
        }
    }

    public void registerChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
        listener.onChange(this.value);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public void tick() {
        ++this.tick;
    }

    public void m_94757_(double x, double y) {
        int mouseX = (int)x;
        if (this.isPressed && this.caret != this.selectionEnd) {
            int max;
            int upper;
            int lower;
            if (this.hasBackground) {
                lower = this.m_252754_() + 15;
                upper = this.m_252754_() + this.f_93618_ - 16;
            } else {
                lower = this.m_252754_() + 11;
                upper = this.m_252754_() + this.f_93618_ - 12;
            }
            boolean scrolled = false;
            if (mouseX < lower) {
                if (this.lineScrollOffset > 0) {
                    int rate = (2 - (mouseX - this.m_252754_()) / 5) * 2 + 2;
                    this.lineScrollOffset -= rate;
                    if (this.lineScrollOffset < 0) {
                        this.lineScrollOffset = 0;
                    }
                    scrolled = true;
                }
            } else if (mouseX > upper && this.lineScrollOffset < (max = this.value.length() - StyledTextFieldWidget.trimToWidth(this.value, this.font, this.getInnerWidth(), true).length())) {
                int rate = (2 + (mouseX - this.m_252754_() - this.f_93618_ + 1) / 5) * 2 + 2;
                this.lineScrollOffset += rate;
                if (this.lineScrollOffset > max) {
                    this.lineScrollOffset = max;
                }
                scrolled = true;
            }
            if (scrolled && !this.hasDraggedSelecton) {
                int relativeX = mouseX - this.m_252754_();
                if (this.hasBackground) {
                    relativeX -= 2;
                }
                this.setSelectionPos(this.getIndexInTextByX(relativeX));
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused) {
            return false;
        }
        if (Screen.m_96634_((int)keyCode)) {
            this.setCaretEnd();
            this.setSelectionPos(0);
        } else if (Screen.m_96632_((int)keyCode)) {
            this.setClipboardString(this.getSelectedText());
        } else if (Screen.m_96630_((int)keyCode)) {
            if (this.isWritable) {
                StyledString str = this.getClipboardString();
                if (Screen.m_96638_()) {
                    this.writeText(str.toUnstyledString());
                } else {
                    this.writeText(str);
                }
            }
        } else if (Screen.m_96628_((int)keyCode)) {
            this.setClipboardString(this.getSelectedText());
            if (this.isWritable) {
                this.writeText("");
            }
        } else if (EditLetteredConnectionScreen.isControlOp(keyCode, 92)) {
            if (this.caret == this.selectionEnd) {
                this.resetCurrentFormatting();
            } else {
                this.resetSelectedFormatting();
            }
        } else {
            switch (keyCode) {
                case 259: {
                    if (Screen.m_96637_()) {
                        if (!this.isWritable) break;
                        this.deleteWords(-1);
                        break;
                    }
                    if (!this.isWritable) break;
                    this.deleteFromCursor(-1);
                    break;
                }
                case 268: {
                    if (Screen.m_96638_()) {
                        this.setSelectionPos(0);
                        break;
                    }
                    this.setCaretStart();
                    break;
                }
                case 263: {
                    if (Screen.m_96638_()) {
                        if (Screen.m_96637_()) {
                            this.setSelectionPos(this.skipWords(-1, this.getSelectionEnd()));
                            break;
                        }
                        this.setSelectionPos(this.getSelectionEnd() - 1);
                        break;
                    }
                    if (Screen.m_96637_()) {
                        this.setCaret(this.skipWords(-1));
                        break;
                    }
                    if (this.getSelectedText().isEmpty()) {
                        this.moveCursorBy(-1);
                        break;
                    }
                    this.setCaret(Math.min(this.caret, this.selectionEnd));
                    break;
                }
                case 262: {
                    if (Screen.m_96638_()) {
                        if (Screen.m_96637_()) {
                            this.setSelectionPos(this.skipWords(1, this.getSelectionEnd()));
                            break;
                        }
                        this.setSelectionPos(this.getSelectionEnd() + 1);
                        break;
                    }
                    if (Screen.m_96637_()) {
                        this.setCaret(this.skipWords(1));
                        break;
                    }
                    if (this.getSelectedText().isEmpty()) {
                        this.moveCursorBy(1);
                        break;
                    }
                    this.setCaret(Math.max(this.caret, this.selectionEnd));
                    break;
                }
                case 269: {
                    if (Screen.m_96638_()) {
                        this.setSelectionPos(this.value.length());
                        break;
                    }
                    this.setCaretEnd();
                    break;
                }
                case 261: {
                    if (Screen.m_96637_()) {
                        if (!this.isWritable) break;
                        this.deleteWords(1);
                        break;
                    }
                    if (!this.isWritable) break;
                    this.deleteFromCursor(1);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        if (SharedConstants.m_136188_((char)typedChar)) {
            String writeChar = this.charInputTransformer.apply(Character.toString(typedChar));
            if (this.isWritable) {
                this.writeText(writeChar);
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean hovered;
        boolean bl = hovered = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
        if (this.isBlurable) {
            this.m_93692_(hovered);
        } else if (!hovered) {
            this.setCaret(Math.min(this.caret, this.selectionEnd));
        }
        if (this.isFocused && hovered && button == 0) {
            int relativeX = Mth.m_14107_((double)(mouseX - (double)this.m_252754_()));
            if (this.hasBackground) {
                relativeX -= 2;
            }
            int idx = this.getIndexInTextByX(relativeX);
            long now = Util.m_137550_();
            if (now - this.lastClickTime <= (long)this.multiClickInterval) {
                ++this.multiClicks;
                if (this.multiClicks > 3) {
                    this.multiClicks = 1;
                }
            } else {
                this.multiClicks = 1;
            }
            this.lastClickTime = now;
            if (Screen.m_96638_()) {
                int end = this.selectionEnd;
                this.setCaret(idx);
                this.setSelectionPos(end);
            } else {
                this.clickIndex(idx);
            }
            this.isPressed = true;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clickIndex(int pos) {
        int low;
        int high;
        block9: {
            int max;
            switch (this.multiClicks) {
                case 1: {
                    int start = this.caret;
                    int end = this.selectionEnd;
                    if (end < start) {
                        int t = start;
                        start = end;
                        end = t;
                    }
                    this.isDraggingSelection = this.caret != this.selectionEnd && pos >= start && pos < end;
                    if (this.isDraggingSelection) return;
                    this.setCaret(pos);
                    this.hasDraggedSelecton = false;
                    return;
                }
                case 2: {
                    if (pos < this.value.length() && this.value.charAt(pos) == ' ') {
                        high = pos;
                        max = this.value.length() - 1;
                        break;
                    }
                    int low2 = this.value.lastIndexOf(' ', pos);
                    int high2 = this.value.indexOf(' ', pos);
                    this.setCaret(high2 == -1 ? this.value.length() : high2);
                    this.setSelectionPos(low2 + 1);
                    return;
                }
                case 3: {
                    this.setCaretEnd();
                    this.setSelectionPos(0);
                    return;
                }
                default: {
                    return;
                }
            }
            for (low = pos - 1; low >= 0; --low) {
                if (this.value.charAt(low) == ' ') continue;
                ++low;
                break;
            }
            while (high < max) {
                if (this.value.charAt(++high) == ' ') continue;
                break block9;
            }
            ++high;
        }
        this.setCaret(high);
        this.setSelectionPos(low);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isPressed = false;
            if (this.isDraggingSelection) {
                boolean hovered;
                boolean bl = hovered = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
                if (hovered) {
                    int pos;
                    int relativeX = Mth.m_14107_((double)(mouseX - (double)this.m_252754_()));
                    if (this.hasBackground) {
                        relativeX -= 2;
                    }
                    if (((pos = this.getIndexInTextByX(relativeX)) - this.caret) * (pos - this.selectionEnd) > 0) {
                        StyledString selection = this.getSelectedText();
                        this.writeText("");
                        if (pos - this.caret - (this.selectionEnd - pos) > 0) {
                            pos -= selection.length();
                        }
                        this.setCaret(pos);
                        this.writeText(selection);
                        this.setCaret(pos);
                        this.setSelectionPos(pos + selection.length());
                    } else {
                        this.setCaret(pos);
                    }
                }
                this.isDraggingSelection = false;
                this.hasDraggedSelecton = false;
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.isFocused && this.isPressed && button == 0) {
            int relativeX = Mth.m_14107_((double)(mouseX - (double)this.m_252754_()));
            if (this.hasBackground) {
                relativeX -= 2;
            }
            if (this.isDraggingSelection) {
                this.hasDraggedSelecton = true;
            } else {
                this.setSelectionPos(this.getIndexInTextByX(relativeX));
            }
            return true;
        }
        return false;
    }

    public void writeText(String input) {
        if (!this.colorBtn.hasDisplayColor()) {
            this.setCurrentStyleByIndex(Math.min(this.selectionEnd, this.caret));
        }
        this.writeText(new StyledString(input, this.currentStyle), false);
    }

    public void writeText(StyledString input) {
        this.writeText(input, true);
    }

    public void writeText(StyledString input, boolean changeColor) {
        StyledString v;
        int length;
        StyledStringBuilder val = new StyledStringBuilder();
        StyledString finput = StyledTextFieldWidget.filterAllowedCharacters(input);
        int endIdx = this.selectionEnd;
        int startIdx = this.caret;
        if (endIdx < startIdx) {
            int t = startIdx;
            startIdx = endIdx;
            endIdx = t;
        }
        int available = this.maxLength - this.value.length() - (startIdx - endIdx);
        if (this.value.length() > 0) {
            val.append(this.value.substring(0, startIdx));
        }
        if (available < finput.length()) {
            val.append(finput.substring(0, available));
            length = available;
        } else {
            val.append(finput);
            length = finput.length();
        }
        if (this.value.length() > 0 && endIdx < this.value.length()) {
            val.append(this.value.substring(endIdx));
        }
        if (this.validator.test((v = val.toStyledString()).toUnstyledString())) {
            this.setValue0(v);
            this.moveCursorBy(startIdx - this.selectionEnd + length, changeColor);
        }
    }

    public static boolean isAllowedCharacter(char character) {
        return character >= ' ' && character != '\u007f';
    }

    private static StyledString filterAllowedCharacters(StyledString str) {
        StyledStringBuilder bldr = new StyledStringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            if (!StyledTextFieldWidget.isAllowedCharacter(chr)) continue;
            bldr.append(chr, str.styleAt(i));
        }
        return bldr.toStyledString();
    }

    public void deleteWords(int num) {
        this.deleteFromCursor(this.skipWords(num) - this.caret);
    }

    public void deleteFromCursor(int num) {
        if (this.value.length() > 0) {
            if (this.selectionEnd != this.caret) {
                this.writeText("");
            } else {
                StyledString v;
                boolean reverse = num < 0;
                int endIdx = reverse ? this.caret + num : this.caret;
                int startIdx = reverse ? this.caret : this.caret + num;
                StyledStringBuilder val = new StyledStringBuilder();
                Style style = null;
                if (endIdx > 0) {
                    if (endIdx < this.value.length()) {
                        style = this.value.styleAt(endIdx);
                    }
                    val.append(this.value.substring(0, endIdx));
                }
                if (startIdx < this.value.length()) {
                    if (startIdx > 0 && style == null) {
                        style = this.value.styleAt(startIdx - 1);
                    }
                    val.append(this.value.substring(startIdx));
                }
                if (this.validator.test((v = val.toStyledString()).toUnstyledString())) {
                    this.setValue0(v);
                    if (reverse) {
                        this.moveCursorBy(num, false);
                    }
                    if (style == null) {
                        style = this.currentStyle;
                    }
                    this.setStyle(style);
                }
            }
        }
    }

    public int skipWords(int n) {
        return this.skipWords(n, n < 0 ? Math.min(this.selectionEnd, this.caret) : Math.max(this.selectionEnd, this.caret));
    }

    public int skipWords(int n, int pos) {
        int idx = pos;
        boolean reverse = n < 0;
        int len = this.value.length();
        int count = Math.abs(n);
        for (int word = 0; word < count; ++word) {
            if (reverse) {
                while (idx > 0 && this.value.charAt(idx - 1) == ' ') {
                    --idx;
                }
                while (idx > 0 && this.value.charAt(idx - 1) != ' ') {
                    --idx;
                }
                if (idx != 0) continue;
                break;
            }
            while (idx < len && this.value.charAt(idx) == ' ') {
                ++idx;
            }
            while (idx < len && this.value.charAt(idx) != ' ') {
                ++idx;
            }
            if (idx == len) break;
        }
        return idx;
    }

    public void moveCursorBy(int num) {
        this.setCaret(this.selectionEnd + num, true);
    }

    public void moveCursorBy(int num, boolean changeColor) {
        this.setCaret(this.selectionEnd + num, changeColor);
    }

    private int getIndexInTextByX(int x) {
        StyledString s = StyledTextFieldWidget.trimToWidth(this.value.substring(this.lineScrollOffset), this.font, this.getInnerWidth());
        return StyledTextFieldWidget.trimToWidth(s, this.font, x).length() + this.lineScrollOffset;
    }

    private void resetCurrentFormatting() {
        this.setStyle(new Style());
        this.tick = 0;
    }

    private void resetSelectedFormatting() {
        int end = this.selectionEnd;
        int start = this.caret;
        if (end < start) {
            int t = start;
            start = end;
            end = t;
        }
        this.setValue0(this.value.withStyling(start, end, new Style()));
    }

    public void m_87963_(GuiGraphics stack, int mouseX, int mouseY, float delta) {
        int caretX;
        if (!this.isVisible) {
            return;
        }
        if (this.hasBackground) {
            stack.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -1432313696);
            stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        }
        int textColor = this.isWritable ? this.writableTextColor : this.readonlyTextColor;
        int visibleCaret = this.caret - this.lineScrollOffset;
        int visibleSelectionEnd = this.selectionEnd - this.lineScrollOffset;
        StyledString visibleText = StyledTextFieldWidget.trimToWidth(this.value.substring(this.lineScrollOffset), this.font, this.getInnerWidth());
        boolean isCaretVisible = visibleCaret >= 0 && visibleCaret <= visibleText.length();
        boolean drawSelection = visibleSelectionEnd != visibleCaret;
        boolean drawCaret = !drawSelection && this.isFocused && this.tick / 6 % 2 == 0 && isCaretVisible;
        int offsetX = this.hasBackground ? this.m_252754_() + 4 : this.m_252754_();
        int offsetY = this.hasBackground ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
        int textX = offsetX;
        if (visibleSelectionEnd > visibleText.length()) {
            visibleSelectionEnd = visibleText.length();
        }
        if (visibleText.length() > 0) {
            Component beforeCaret = (isCaretVisible ? visibleText.substring(0, visibleCaret) : visibleText).toTextComponent();
            textX = stack.m_280614_(this.font, beforeCaret, offsetX, offsetY, textColor, true);
        }
        if (isCaretVisible) {
            caretX = --textX;
        } else {
            int n = caretX = visibleCaret > 0 ? offsetX + this.f_93618_ - 6 : offsetX;
        }
        if (visibleText.length() > 0 && isCaretVisible && visibleCaret < visibleText.length()) {
            textX = stack.m_280614_(this.font, visibleText.substring(visibleCaret).toTextComponent(), textX, offsetY, textColor, true);
        }
        if (drawCaret) {
            int rgb = StyledString.getColor(this.currentStyle.getColor());
            if (this.currentStyle.isItalic()) {
                Objects.requireNonNull(this.font);
                stack.m_280509_(caretX - 1, caretX + 1, offsetY - 2, offsetY + 1 + 9, rgb);
            } else {
                Objects.requireNonNull(this.font);
                stack.m_280509_(caretX, offsetY - 2, caretX + 1, offsetY + 1 + 9, 0xFF000000 | rgb);
            }
        }
        if (drawSelection) {
            int start;
            int selectionX = offsetX + (visibleSelectionEnd < 0 ? 0 : StyledTextFieldWidget.getWidth(visibleText.substring(0, visibleSelectionEnd), this.font));
            int end = selectionX;
            if (end < (start = caretX)) {
                int t = start;
                start = end;
                end = t;
            }
            Objects.requireNonNull(this.font);
            this.drawSelectionHighlight(stack, start - 1, offsetY - 2, end, offsetY + 1 + 9);
        }
        if (this.hasDraggedSelecton) {
            if (this.f_93622_) {
                int pos;
                int relativeX = mouseX - this.m_252754_();
                if (this.hasBackground) {
                    relativeX -= 2;
                }
                if ((pos = this.getIndexInTextByX(relativeX) - this.lineScrollOffset) >= 0 && pos <= visibleText.length()) {
                    int x = StyledTextFieldWidget.getWidth(visibleText.substring(0, pos), this.font);
                    int rgb = StyledString.getColor(this.currentStyle.getColor());
                    Objects.requireNonNull(this.font);
                    stack.m_280509_(offsetX + x, offsetY - 2, offsetX + x + 1, offsetY + 1 + 9, 0xFF000000 | rgb);
                }
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            stack.m_280614_(this.font, this.getSelectedText().toTextComponent(), mouseX + 5, mouseY + 5, textColor | 0xBF000000, true);
            RenderSystem.disableBlend();
        }
    }

    private void drawSelectionHighlight(GuiGraphics stack, int startX, int startY, int endX, int endY) {
        if (endX > this.m_252754_() + this.f_93618_) {
            endX = this.m_252754_() + this.f_93618_;
        }
        if (startX > this.m_252754_() + this.f_93618_) {
            startX = this.m_252754_() + this.f_93618_;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.m_280509_(startX, startY, endX, endY, 0x33FFFFFF);
        RenderSystem.disableBlend();
    }

    public StyledString getClipboardString() {
        String str = Minecraft.m_91087_().f_91068_.m_90876_();
        if (str.indexOf(167) == -1) {
            return new StyledString(str, this.currentStyle);
        }
        return StyledString.valueOf(str);
    }

    private void setClipboardString(StyledString value) {
        Minecraft.m_91087_().f_91068_.m_90911_(value.toString());
    }

    private static int getMultiClickInterval() {
        return 250;
    }

    protected MutableComponent m_5646_() {
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{this.m_6035_(), this.value.toUnstyledString()});
    }

    protected void m_168797_(NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.value.toUnstyledString()}));
    }

    private static int getWidth(StyledString styledString, Font font) {
        char[] chars = styledString.toCharArray();
        Style[] styling = styledString.getStyling();
        int w = 0;
        int len = styledString.length();
        for (int i = 0; i < len; ++i) {
            w += font.m_92895_(Character.toString(chars[i]));
            if (!styling[i].isBold()) continue;
            ++w;
        }
        return w;
    }

    private static StyledString trimToWidth(StyledString styledString, Font font, int width) {
        return StyledTextFieldWidget.trimToWidth(styledString, font, width, false);
    }

    private static StyledString trimToWidth(StyledString styledString, Font font, int width, boolean reverse) {
        char[] chars = styledString.toCharArray();
        Style[] styling = styledString.getStyling();
        int len = styledString.length();
        StyledStringBuilder str = new StyledStringBuilder();
        int start = reverse ? len - 1 : 0;
        int step = reverse ? -1 : 1;
        int w = 0;
        for (int i = start; i >= 0 && i < len && w < width; i += step) {
            w += font.m_92895_(Character.toString(chars[i]));
            if (styling[i].isBold()) {
                ++w;
            }
            if (w > width) break;
            if (reverse) {
                str.insert(0, styledString.substring(i, i + 1));
                continue;
            }
            str.append(styledString.substring(i, i + 1));
        }
        return str.toStyledString();
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(StyledString var1);
    }
}

