/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class EasyMeshBuilder {
    private final String name;
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    private final CubeListBuilder cubes;
    private final List<EasyMeshBuilder> children;

    public EasyMeshBuilder(String name) {
        this.name = name;
        this.cubes = new CubeListBuilder();
        this.children = new ArrayList<EasyMeshBuilder>();
    }

    public EasyMeshBuilder(String name, int u, int v) {
        this(name);
        this.setTextureOffset(u, v);
    }

    public EasyMeshBuilder setTextureOffset(int u, int v) {
        this.cubes.m_171514_(u, v);
        return this;
    }

    public EasyMeshBuilder addBox(float x, float y, float z, float width, float height, float depth) {
        this.cubes.m_171481_(x, y, z, width, height, depth);
        return this;
    }

    public EasyMeshBuilder addBox(float x, float y, float z, float width, float height, float depth, float expand) {
        this.cubes.m_171488_(x, y, z, width, height, depth, new CubeDeformation(expand));
        return this;
    }

    public void addChild(EasyMeshBuilder child) {
        this.children.add(child);
    }

    public void setRotationPoint(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setRotationAngles(float x, float y, float z) {
        this.xRot = x;
        this.yRot = y;
        this.zRot = z;
    }

    public void build(PartDefinition parent) {
        PartDefinition part = parent.m_171599_(this.name, this.cubes, PartPose.m_171423_((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot));
        for (EasyMeshBuilder child : this.children) {
            child.build(part);
        }
    }

    public LayerDefinition build(int xTexSize, int yTexSize) {
        MeshDefinition mesh = new MeshDefinition();
        this.build(mesh.m_171576_());
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)xTexSize, (int)yTexSize);
    }
}

