/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.util.Curve;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public abstract class ConnectionRenderer<C extends Connection> {
    private final WireModel model;
    private final float wireInflate;

    protected ConnectionRenderer(Function<ModelLayerLocation, ModelPart> baker, ModelLayerLocation wireModelLocation) {
        this(baker, wireModelLocation, 0.0f);
    }

    protected ConnectionRenderer(Function<ModelLayerLocation, ModelPart> baker, ModelLayerLocation wireModelLocation, float wireInflate) {
        this.model = new WireModel(baker.apply(wireModelLocation));
        this.wireInflate = wireInflate;
    }

    public void render(C conn, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        Curve currCat = ((Connection)conn).getCatenary();
        Curve prevCat = ((Connection)conn).getPrevCatenary();
        if (currCat != null && prevCat != null) {
            Curve cat = prevCat.lerp(currCat, delta);
            Curve.SegmentIterator it = cat.iterator();
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.m_119194_(source, RenderType::m_110452_);
            int color = this.getWireColor(conn);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            while (it.next()) {
                matrix.m_85836_();
                matrix.m_252880_(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                matrix.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - it.getYaw()));
                matrix.m_252781_(Axis.f_252529_.m_252961_(-it.getPitch()));
                matrix.m_85841_(1.0f + this.wireInflate, 1.0f, it.getLength() * 16.0f);
                this.model.m_7695_(matrix, buf, packedLight, packedOverlay, r, g, b, 1.0f);
                matrix.m_85849_();
                this.renderSegment(conn, it, delta, matrix, packedLight, source, packedOverlay);
            }
            this.render(conn, cat, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    protected int getWireColor(C conn) {
        return 0xFFFFFF;
    }

    protected void render(C conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
    }

    protected void renderSegment(C connection, Curve.SegmentView it, float delta, PoseStack matrix, int packedLight, MultiBufferSource source, int packedOverlay) {
    }

    public static class WireModel
    extends Model {
        final ModelPart root;

        WireModel(ModelPart root) {
            super(RenderType::m_110452_);
            this.root = root;
        }

        public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
            this.root.m_104306_(matrix, builder, light, overlay, r, g, b, a);
        }

        public static LayerDefinition createLayer(int u, int v, int size) {
            MeshDefinition mesh = new MeshDefinition();
            mesh.m_171576_().m_171599_("root", CubeListBuilder.m_171558_().m_171514_(u, v).m_171481_((float)(-size) * 0.5f, (float)(-size) * 0.5f, 0.0f, (float)size, (float)size, 1.0f), PartPose.f_171404_);
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
        }
    }
}

