/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.RandomArray;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class GarlandTinselRenderer
extends ConnectionRenderer<GarlandTinselConnection> {
    private static final RandomArray RAND = new RandomArray(9171L, 128);
    private final StripModel strip;

    public GarlandTinselRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.TINSEL_WIRE);
        this.strip = new StripModel(baker.apply(FLModelLayers.TINSEL_STRIP));
    }

    @Override
    protected int getWireColor(GarlandTinselConnection conn) {
        return conn.getColor();
    }

    @Override
    protected void renderSegment(GarlandTinselConnection connection, Curve.SegmentView it, float delta, PoseStack matrix, int packedLight, MultiBufferSource source, int packedOverlay) {
        super.renderSegment(connection, it, delta, matrix, packedLight, source, packedOverlay);
        int color = connection.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        matrix.m_85836_();
        matrix.m_252880_(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
        matrix.m_252781_(Axis.f_252436_.m_252961_(-it.getYaw()));
        matrix.m_252781_(Axis.f_252403_.m_252961_(it.getPitch()));
        float length = it.getLength();
        int rings = Mth.m_14167_((float)(length * 64.0f));
        int hash = connection.getUUID().hashCode();
        int index = it.getIndex();
        VertexConsumer buf = ClientProxy.SOLID_TEXTURE.m_119194_(source, RenderType::m_110452_);
        for (int i = 0; i < rings; ++i) {
            double t = (float)i / (float)rings * length;
            matrix.m_85836_();
            matrix.m_85837_(t, 0.0, 0.0);
            float rotX = RAND.get(31 * (index + 31 * i) + hash) * 22.0f;
            float rotY = RAND.get(31 * (index + 3 + 31 * i) + hash) * 180.0f;
            float rotZ = RAND.get(31 * (index + 7 + 31 * i) + hash) * 180.0f;
            matrix.m_252781_(Axis.f_252529_.m_252977_(rotZ));
            matrix.m_252781_(Axis.f_252436_.m_252977_(rotY));
            matrix.m_252781_(Axis.f_252403_.m_252977_(rotX));
            matrix.m_85841_(1.0f, RAND.get(i * 63) * 0.1f + 1.0f, 0.5f);
            this.strip.m_7695_(matrix, buf, packedLight, packedOverlay, r, g, b, 1.0f);
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(62, 0, 1);
    }

    public static class StripModel
    extends Model {
        final ModelPart root;

        StripModel(ModelPart root) {
            super(RenderType::m_110452_);
            this.root = root;
        }

        public static LayerDefinition createLayer() {
            MeshDefinition mesh = new MeshDefinition();
            mesh.m_171576_().m_171599_("root", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171481_(-0.5f, -3.0f, 0.0f, 1.0f, 6.0f, 0.0f), PartPose.f_171404_);
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
        }

        public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
            this.root.m_104306_(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

