/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Locale;
import java.util.function.Function;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.feature.Letter;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class LetterBuntingRenderer
extends ConnectionRenderer<LetterBuntingConnection> {
    public static final Int2ObjectMap<ResourceLocation> MODELS = (Int2ObjectMap)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ&!?".chars().collect(Int2ObjectOpenHashMap::new, (map, cp) -> map.put(cp, (Object)new ResourceLocation("fairylights", "entity/letter/" + Character.getName(cp).toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "_"))), Int2ObjectOpenHashMap::putAll);

    public LetterBuntingRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.LETTER_WIRE);
    }

    @Override
    protected void render(LetterBuntingConnection conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        Letter[] letters = conn.getLetters();
        if (letters == null) {
            return;
        }
        int count = letters.length;
        if (count == 0) {
            return;
        }
        VertexConsumer buf = source.m_6299_(Sheets.m_110790_());
        for (Letter letter : letters) {
            ResourceLocation path = (ResourceLocation)MODELS.get((int)letter.getLetter());
            if (path == null) continue;
            int color = StyledString.getColor(letter.getStyle().getColor());
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Vec3 pos = letter.getPoint(delta);
            matrix.m_85836_();
            matrix.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            matrix.m_252781_(Axis.f_252436_.m_252961_(-letter.getYaw(delta)));
            matrix.m_252781_(Axis.f_252403_.m_252961_(letter.getPitch(delta)));
            matrix.m_252781_(Axis.f_252529_.m_252961_(letter.getRoll(delta)));
            matrix.m_252880_(-0.5f, -1.03125f, -0.5f);
            FastenerRenderer.renderBakedModel(path, matrix, buf, r, g, b, packedLight, packedOverlay);
            matrix.m_85849_();
        }
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(0, 17, 1);
    }
}

