/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.paulf.fairylights.data.GenericRecipeBuilder;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.Tags;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="fairylights", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGatherer {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableGenerator(gen));
    }

    static Consumer<FinishedRecipe> addNbt(Consumer<FinishedRecipe> consumer, CompoundTag nbt) {
        return recipe -> consumer.accept(new ForwardingFinishedRecipe((FinishedRecipe)recipe, nbt){
            final /* synthetic */ FinishedRecipe val$recipe;
            final /* synthetic */ CompoundTag val$nbt;
            {
                this.val$recipe = finishedRecipe;
                this.val$nbt = compoundTag;
            }

            @Override
            protected FinishedRecipe delegate() {
                return this.val$recipe;
            }

            @Override
            public void m_7917_(JsonObject json) {
                super.m_7917_(json);
                json.getAsJsonObject("result").addProperty("nbt", this.val$nbt.toString());
            }
        });
    }

    static class RecipeGenerator
    extends RecipeProvider {
        RecipeGenerator(PackOutput generator) {
            super(generator);
        }

        protected void m_245200_(Consumer<FinishedRecipe> consumer) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("text", (Tag)StyledString.serialize(new StyledString()));
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.LETTER_BUNTING.get())).m_126130_("I-I").m_126130_("PBF").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('-'), Tags.Items.STRING).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42532_).m_206416_(Character.valueOf('F'), Tags.Items.FEATHERS).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_string", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.STRING)).m_176498_(DataGatherer.addNbt(consumer, nbt));
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.GARLAND.get()), (int)2).m_126130_("I-I").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('-'), (ItemLike)Items.f_42029_).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_vine", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42029_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.OIL_LANTERN.get()), (int)4).m_126130_(" I ").m_126130_("STS").m_126130_("IGI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_42000_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_torch", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42000_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.CANDLE_LANTERN.get()), (int)4).m_126130_(" I ").m_126130_("GTG").m_126130_("IGI").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_42000_).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_torch", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42000_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)FLItems.INCANDESCENT_LIGHT.get()), (int)4).m_126130_(" I ").m_126130_("ITI").m_126130_(" G ").m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_42000_).m_126132_("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126132_("has_torch", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42000_)).m_176498_(consumer);
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS.get()).unlockedBy("has_lights", (CriterionTriggerInstance)RecipeGenerator.m_206406_(FLCraftingRecipes.LIGHTS)).build(consumer, new ResourceLocation("fairylights", "hanging_lights"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS_AUGMENTATION.get()).build(consumer, new ResourceLocation("fairylights", "hanging_lights_augmentation"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.TINSEL_GARLAND.get()).unlockedBy("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_string", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.STRING)).build(consumer, new ResourceLocation("fairylights", "tinsel_garland"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING.get()).unlockedBy("has_pennants", (CriterionTriggerInstance)RecipeGenerator.m_206406_(FLCraftingRecipes.PENNANTS)).build(consumer, new ResourceLocation("fairylights", "pennant_bunting"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING_AUGMENTATION.get()).build(consumer, new ResourceLocation("fairylights", "pennant_bunting_augmentation"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.EDIT_COLOR.get()).build(consumer, new ResourceLocation("fairylights", "edit_color"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.COPY_COLOR.get()).build(consumer, new ResourceLocation("fairylights", "copy_color"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.TRIANGLE_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "triangle_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SPEARHEAD_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "spearhead_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SWALLOWTAIL_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "swallowtail_pennant"));
            this.pennantRecipe((RecipeSerializer)FLCraftingRecipes.SQUARE_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "square_pennant"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.FAIRY_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "fairy_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.PAPER_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "paper_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.ORB_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "orb_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.FLOWER_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "flower_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.CANDLE_LANTERN_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "candle_lantern_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.OIL_LANTERN_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "oil_lantern_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.JACK_O_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "jack_o_lantern"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SKULL_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "skull_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.GHOST_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "ghost_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SPIDER_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "spider_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.WITCH_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "witch_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.SNOWFLAKE_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "snowflake_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.HEART_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "heart_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.MOON_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "moon_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.STAR_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "star_light"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.ICICLE_LIGHTS.get()).build(consumer, new ResourceLocation("fairylights", "icicle_lights"));
            this.lightRecipe((RecipeSerializer)FLCraftingRecipes.METEOR_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "meteor_light"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.LIGHT_TWINKLE.get()).build(consumer, new ResourceLocation("fairylights", "light_twinkle"));
            GenericRecipeBuilder.customRecipe((RecipeSerializer)FLCraftingRecipes.COLOR_CHANGING_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "color_changing_light"));
        }

        GenericRecipeBuilder lightRecipe(RecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).unlockedBy("has_iron", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_dye", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.DYES));
        }

        GenericRecipeBuilder pennantRecipe(RecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).unlockedBy("has_paper", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Items.f_42516_)).unlockedBy("has_string", (CriterionTriggerInstance)RecipeGenerator.m_206406_((TagKey)Tags.Items.STRING));
        }
    }

    static class LootTableGenerator
    extends LootTableProvider {
        LootTableGenerator(DataGenerator generator) {
            super(generator.getPackOutput(), Set.of(), VanillaLootTableProvider.m_247452_((PackOutput)generator.getPackOutput()).getTables());
        }

        public List<LootTableProvider.SubProviderEntry> getTables() {
            return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(BlockLootTableGenerator::new, LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext tracker) {
            map.forEach((name, table) -> table.m_79136_(tracker));
        }
    }

    static abstract class ForwardingFinishedRecipe
    implements FinishedRecipe {
        ForwardingFinishedRecipe() {
        }

        protected abstract FinishedRecipe delegate();

        public void m_7917_(JsonObject json) {
            this.delegate().m_7917_(json);
        }

        public ResourceLocation m_6445_() {
            return this.delegate().m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.delegate().m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.delegate().m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.delegate().m_6448_();
        }
    }

    static class BlockLootTableGenerator
    extends BlockLootSubProvider {
        protected BlockLootTableGenerator() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected Iterable<Block> getKnownBlocks() {
            return FLBlocks.REG.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        protected void m_245660_() {
            this.m_247577_((Block)FLBlocks.FASTENER.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.FAIRY_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.PAPER_LANTERN.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.ORB_LANTERN.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.FLOWER_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.CANDLE_LANTERN_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.OIL_LANTERN_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.JACK_O_LANTERN.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.SKULL_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.GHOST_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.SPIDER_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.WITCH_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.SNOWFLAKE_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.HEART_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.MOON_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.STAR_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.ICICLE_LIGHTS.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.METEOR_LIGHT.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.OIL_LANTERN.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.CANDLE_LANTERN.get(), BlockLootTableGenerator.m_246386_());
            this.m_247577_((Block)FLBlocks.INCANDESCENT_LIGHT.get(), BlockLootTableGenerator.m_246386_());
        }
    }
}

