/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.accessor.PlayerFastenerAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class PlayerFastener
extends EntityFastener<Player> {
    public PlayerFastener(Player entity) {
        super(entity);
    }

    @Override
    public Vec3 getConnectionPoint() {
        double dy;
        double forwardDist;
        Vec3 point = super.getConnectionPoint();
        if (((Player)this.entity).m_21255_()) {
            return point;
        }
        double angle = (((Player)this.entity).f_20883_ - 90.0f) * ((float)Math.PI / 180);
        double perpAngle = angle - 1.5707963267948966;
        boolean sneaking = ((Player)this.entity).m_6047_();
        double perpDist = 0.4 * (double)(this.matchesStack(((Player)this.entity).m_21205_()) ? 1 : -1);
        if (sneaking) {
            forwardDist = 0.0;
            dy = 0.6;
        } else {
            forwardDist = 0.2;
            dy = 0.8;
        }
        double dx = Math.cos(perpAngle) * perpDist - Math.cos(angle) * forwardDist;
        double dz = Math.sin(perpAngle) * perpDist - Math.sin(angle) * forwardDist;
        return point.m_82520_(dx, dy, dz);
    }

    @Override
    public boolean isMoving() {
        return true;
    }

    @Override
    public boolean update() {
        if (!(this.hasNoConnections() || this.matchesStack(((Player)this.entity).m_21205_()) || this.matchesStack(((Player)this.entity).m_21206_()))) {
            for (Connection connection : this.getAllConnections()) {
                if (connection.shouldDrop()) continue;
                connection.remove();
            }
        }
        return super.update();
    }

    private boolean matchesStack(ItemStack stack) {
        return this.getFirstConnection().filter(connection -> connection.matches(stack)).isPresent();
    }

    @Override
    public void resistSnap(Vec3 from) {
        double dist = this.getConnectionPoint().m_82554_(from);
        if (dist > 32.0) {
            double arcX;
            double arcY;
            double arcZ;
            double dx = ((Player)this.entity).m_20185_() - from.f_82479_;
            double dy = ((Player)this.entity).m_20186_() - from.f_82480_;
            double dz = ((Player)this.entity).m_20189_() - from.f_82481_;
            double vectorX = dx / dist;
            double vectorY = dy / dist;
            double vectorZ = dz / dist;
            double factor = Math.min((dist - 32.0) / 5.0, 5.0);
            Vec3 motion = ((Player)this.entity).m_20184_();
            double tangent = Math.cos(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz))) * Math.signum(motion.f_82480_);
            double speed = motion.m_82553_();
            double swing = Math.abs(speed) < 1.0E-6 ? 0.0 : (1.0 - Math.abs(motion.f_82480_ / speed - tangent)) * 0.1;
            double mag = Math.sqrt(motion.f_82479_ * motion.f_82479_ + tangent * tangent + motion.f_82481_ * motion.f_82481_);
            if (dy > 0.0 || Math.abs(mag) < 1.0E-6) {
                arcZ = 0.0;
                arcY = 0.0;
                arcX = 0.0;
            } else {
                arcX = motion.f_82479_ / mag * swing;
                arcY = tangent / mag * swing;
                arcZ = motion.f_82481_ / mag * swing;
            }
            ((Player)this.entity).m_20334_(motion.f_82479_ + vectorX * -Math.abs(vectorX) * factor + arcX, motion.f_82480_ + vectorY * -Math.abs(vectorY) * factor + arcY, motion.f_82481_ + vectorZ * -Math.abs(vectorZ) * factor + arcZ);
            ((Player)this.entity).f_19789_ = 0.0f;
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(this.entity));
            }
        }
    }

    @Override
    public PlayerFastenerAccessor createAccessor() {
        return new PlayerFastenerAccessor(this);
    }
}

