/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemHandCards;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MinoCommand {
    private static final SimpleCommandExceptionType ERROR_NO_GAME = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"game.minopp.play.no_game"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"minopp").then(Commands.m_82127_((String)"shout").executes(context -> {
            boolean success = Mino.onServerChatMessage("mino", ((CommandSourceStack)context.getSource()).m_81375_());
            if (!success) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"game.minopp.play.no_game")).create();
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_table_award").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack holdingItem = player.m_21205_();
            if (holdingItem.m_41619_()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Requirement: Hold an item"));
                return 0;
            }
            if (!player.m_20075_().m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Requirement: Stand on a table"));
                return 0;
            }
            BlockPos corePos = BlockMinoTable.getCore(player.m_20075_(), player.m_20097_());
            BlockEntity patt0$temp = player.m_284548_().m_7702_(corePos);
            if (patt0$temp instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                tableEntity.award = holdingItem.m_41777_();
                tableEntity.sync();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Table award set"), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Requirement: Stand on a table"));
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set_table_demo").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"demo", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            if (!player.m_20075_().m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Requirement: Stand on a table"));
                return 0;
            }
            BlockPos corePos = BlockMinoTable.getCore(player.m_20075_(), player.m_20097_());
            BlockEntity patt0$temp = player.m_284548_().m_7702_(corePos);
            if (patt0$temp instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                tableEntity.demo = BoolArgumentType.getBool((CommandContext)context, (String)"demo");
                tableEntity.sync();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Table demo set"), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Requirement: Stand on a table"));
            return 0;
        }))));
    }

    private static void withPlayerAndGame(CommandContext<CommandSourceStack> context, BiConsumer<CardGame, CardPlayer> action) throws CommandSyntaxException {
        CardPlayer cardPlayer;
        BlockEntityMinoTable tableEntity;
        BlockPos gamePos = ItemHandCards.getHandCardGamePos((Player)((CommandSourceStack)context.getSource()).m_81375_());
        if (gamePos == null) {
            throw ERROR_NO_GAME.create();
        }
        BlockEntity blockEntity = ((CommandSourceStack)context.getSource()).m_81372_().m_7702_(gamePos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            tableEntity = (BlockEntityMinoTable)blockEntity;
            if (tableEntity.game == null) {
                throw ERROR_NO_GAME.create();
            }
            cardPlayer = tableEntity.game.deAmputate(ItemHandCards.getCardPlayer((Player)((CommandSourceStack)context.getSource()).m_81375_()));
            if (cardPlayer == null) {
                throw ERROR_NO_GAME.create();
            }
        } else {
            throw ERROR_NO_GAME.create();
        }
        action.accept(tableEntity.game, cardPlayer);
        tableEntity.sync();
    }
}

