/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.block;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.SeatActionTakenEffectEvent;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.network.S2CActionEphemeralPacket;
import cn.zbx1425.minopp.network.S2CEffectListPacket;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityMinoTable
extends BlockEntity {
    public Map<Direction, CardPlayer> players = new HashMap<Direction, CardPlayer>();
    public CardGame game = null;
    public ActionMessage state = ActionMessage.NO_GAME;
    public List<Pair<ActionMessage, Long>> clientMessageList = new ArrayList<Pair<ActionMessage, Long>>();
    public ItemStack award = ItemStack.f_41583_;
    public boolean demo = false;
    public static final List<Direction> PLAYER_ORDER = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
    private static final int PLAYER_RANGE = 20;

    public BlockEntityMinoTable(BlockPos blockPos, BlockState blockState) {
        super(Mino.BLOCK_ENTITY_TYPE_MINO_TABLE.get(), blockPos, blockState);
        for (Direction direction : PLAYER_ORDER) {
            this.players.put(direction, null);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<Direction, CardPlayer> entry : this.players.entrySet()) {
            if (entry.getValue() == null) continue;
            playersTag.m_128365_(entry.getKey().m_7912_(), (Tag)entry.getValue().toTag());
        }
        compoundTag.m_128365_("players", (Tag)playersTag);
        if (this.game != null) {
            compoundTag.m_128365_("game", (Tag)this.game.toTag());
        }
        compoundTag.m_128365_("state", (Tag)this.state.toTag());
        if (!this.award.m_41619_()) {
            compoundTag.m_128365_("award", (Tag)this.award.m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("demo", this.demo);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        CompoundTag playersTag = compoundTag.m_128469_("players");
        for (Direction direction : PLAYER_ORDER) {
            if (playersTag.m_128441_(direction.m_7912_())) {
                this.players.put(direction, new CardPlayer(playersTag.m_128469_(direction.m_7912_())));
                continue;
            }
            this.players.put(direction, null);
        }
        CardGame previousGame = this.game;
        this.game = compoundTag.m_128441_("game") ? new CardGame(compoundTag.m_128469_("game")) : null;
        ActionMessage newState = new ActionMessage(compoundTag.m_128469_("state"));
        if (!newState.equals(this.state)) {
            if (previousGame == null && this.game != null) {
                this.clientMessageList.clear();
            } else {
                this.clientMessageList.add((Pair<ActionMessage, Long>)new Pair((Object)this.state, (Object)(System.currentTimeMillis() + 16000L)));
            }
            this.state = newState;
            this.clientMessageList.removeIf(entry -> ((ActionMessage)entry.getFirst()).type() == ActionMessage.Type.FAIL);
        }
        this.award = compoundTag.m_128425_("award", 10) ? ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("award")) : ItemStack.f_41583_;
        this.demo = compoundTag.m_128471_("demo");
    }

    public List<CardPlayer> getPlayersList() {
        ArrayList<CardPlayer> playersList = new ArrayList<CardPlayer>();
        for (Direction direction : PLAYER_ORDER) {
            if (this.players.get(direction) == null) continue;
            playersList.add(this.players.get(direction));
        }
        return playersList;
    }

    public List<Direction> getEmptyDirections() {
        ArrayList<Direction> emptyDirections = new ArrayList<Direction>();
        for (Direction direction : PLAYER_ORDER) {
            if (this.players.get(direction) != null) continue;
            emptyDirections.add(direction);
        }
        return emptyDirections;
    }

    public void joinPlayerToTable(CardPlayer cardPlayer, Vec3 playerPos) {
        if (this.game != null) {
            return;
        }
        BlockPos centerPos = this.m_58899_().m_7918_(1, 0, 1);
        Vec3 playerOffset = playerPos.m_82492_((double)centerPos.m_123341_(), (double)centerPos.m_123342_(), (double)centerPos.m_123343_());
        Direction playerDirection = Direction.m_122364_((double)(Mth.m_14136_((double)playerOffset.f_82481_, (double)playerOffset.f_82479_) * 180.0 / Math.PI - 90.0));
        for (Direction checkDir : this.players.keySet()) {
            if (!cardPlayer.equals(this.players.get(checkDir))) continue;
            this.players.put(checkDir, null);
        }
        this.players.put(playerDirection, cardPlayer);
        this.sync();
    }

    public void startGame(CardPlayer initiator) {
        if (this.game != null) {
            return;
        }
        List<CardPlayer> playerList = this.getPlayersList();
        if (playerList.size() < 2) {
            return;
        }
        AABB searchArea = AABB.m_165882_((Vec3)Vec3.m_272021_((Vec3i)this.m_58899_(), (double)1.0, (double)1.0, (double)1.0), (double)20.0, (double)20.0, (double)20.0);
        for (CardPlayer cardPlayer : playerList) {
            boolean playerFound = false;
            for (Entity entity : this.f_58857_.m_45933_(null, searchArea)) {
                if (entity instanceof Player) {
                    Player mcPlayer = (Player)entity;
                    if (cardPlayer.uuid.equals(mcPlayer.m_36316_().getId())) {
                        ItemStack handCard = new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS.get());
                        ItemHandCards.setCardGameBinding(handCard, this.m_58899_(), cardPlayer.uuid);
                        if (Inventory.m_36045_((int)mcPlayer.m_150109_().f_35977_) && mcPlayer.m_150109_().m_36056_().m_41619_()) {
                            mcPlayer.m_150109_().m_6836_(mcPlayer.m_150109_().f_35977_, handCard);
                            playerFound = true;
                        } else {
                            ItemEntity itemEntity;
                            boolean addSuccessful = mcPlayer.m_150109_().m_36054_(handCard);
                            if (!addSuccessful && (itemEntity = mcPlayer.m_36176_(handCard, false)) != null) {
                                itemEntity.m_32061_();
                                itemEntity.m_266426_(mcPlayer.m_20148_());
                            }
                            mcPlayer.m_5661_((Component)Component.m_237115_((String)"game.minopp.play.hand_card_in_inventory"), false);
                            playerFound = true;
                        }
                    }
                } else if (cardPlayer.uuid.equals(entity.m_20148_())) {
                    playerFound = true;
                }
                if (!playerFound) continue;
                break;
            }
            if (playerFound) continue;
            this.destroyGame(initiator);
            this.state = ActionReport.builder((CardPlayer)initiator).panic((Component)Component.m_237110_((String)"game.minopp.play.player_unavailable", (Object[])new Object[]{cardPlayer.name})).state;
            return;
        }
        this.players.values().forEach(p -> {
            if (p != null) {
                p.hand.clear();
                p.hasShoutedMino = false;
            }
        });
        this.game = new CardGame(this.getPlayersList());
        this.state = this.game.initiate((CardPlayer)initiator, (int)7).state;
        this.sendSeatActionTakenToAll();
        this.sync();
    }

    public void destroyGame(CardPlayer initiator) {
        if (this.game != null) {
            this.sendSeatActionTakenToAll();
        }
        this.game = null;
        for (Player mcPlayer : this.f_58857_.m_6907_()) {
            for (ItemStack invItem : mcPlayer.m_150109_().f_35974_) {
                ItemHandCards.CardGameBinding binding;
                if (!invItem.m_150930_((Item)Mino.ITEM_HAND_CARDS.get()) || (binding = ItemHandCards.getCardGameBinding(invItem)) == null || !binding.tablePos().equals((Object)this.m_58899_())) continue;
                mcPlayer.m_150109_().m_36057_(invItem);
            }
        }
        for (CardPlayer cardPlayer : this.players.values()) {
            Entity entity;
            if (cardPlayer == null || !((entity = ((ServerLevel)this.f_58857_).m_8791_(cardPlayer.uuid)) instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = livingEntity.m_21120_(hand);
                if (!stack.m_150930_((Item)Mino.ITEM_HAND_CARDS.get())) continue;
                livingEntity.m_21008_(hand, ItemStack.f_41583_);
            }
        }
        this.players.values().forEach(p -> {
            if (p != null) {
                p.hand.clear();
                p.hasShoutedMino = false;
            }
        });
        this.state = ActionReport.builder((CardPlayer)initiator).gameDestroyed().state;
        this.sync();
    }

    public void resetSeats(CardPlayer initiator) {
        this.sendSeatActionTakenToAll();
        this.players.replaceAll((d, v) -> null);
        this.state = ActionReport.builder((CardPlayer)initiator).panic((Component)Component.m_237110_((String)"game.minopp.play.seats_reset", (Object[])new Object[]{initiator.name})).state;
        this.sync();
    }

    public void handleActionResult(ActionReport result, CardPlayer cardPlayer, ServerPlayer player) {
        if (result != null) {
            if (result.shouldDestroyGame) {
                this.destroyGame(cardPlayer);
            }
            if (result.state != null) {
                this.state = result.state;
            }
            for (ActionMessage message : result.messages) {
                switch (message.type()) {
                    case FAIL: {
                        if (player == null) break;
                        S2CActionEphemeralPacket.sendS2C(player, this.m_58899_(), message);
                        break;
                    }
                    case MESSAGE_ALL: {
                        this.sendMessageToAll(message);
                    }
                }
            }
            if (!result.effects.isEmpty()) {
                MinecraftServer server = ((ServerLevel)this.f_58857_).m_7654_();
                BlockPos tableCenterPos = this.m_58899_().m_7918_(1, 0, 1);
                for (EffectEvent effect : result.effects) {
                    effect.summonServer((ServerLevel)this.f_58857_, tableCenterPos, this);
                }
                for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                    if (serverPlayer.m_9236_().m_46472_() != this.f_58857_.m_46472_() || !(serverPlayer.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)tableCenterPos)) <= 256.0)) continue;
                    boolean playerPartOfGame = this.getPlayersList().stream().anyMatch(p -> p.uuid.equals(serverPlayer.m_36316_().getId()));
                    S2CEffectListPacket.sendS2C(serverPlayer, result.effects, tableCenterPos, playerPartOfGame);
                }
            }
            this.sync();
        }
    }

    private void sendMessageToAll(ActionMessage message) {
        for (CardPlayer player : this.getPlayersList()) {
            Player mcPlayer = this.f_58857_.m_46003_(player.uuid);
            if (mcPlayer == null) continue;
            S2CActionEphemeralPacket.sendS2C((ServerPlayer)mcPlayer, this.m_58899_(), message);
        }
    }

    private void sendSeatActionTakenToAll() {
        for (CardPlayer player : this.getPlayersList()) {
            Player mcPlayer = this.f_58857_.m_46003_(player.uuid);
            BlockPos tableCenterPos = this.m_58899_().m_7918_(1, 0, 1);
            List<EffectEvent> events = List.of(new SeatActionTakenEffectEvent(player.uuid));
            if (mcPlayer == null) continue;
            S2CEffectListPacket.sendS2C((ServerPlayer)mcPlayer, events, tableCenterPos, true);
        }
    }

    public void sync() {
        this.m_6596_();
        BlockState blockState = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), blockState, blockState, 2);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

