/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.block;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.MinoClient;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.SeatControlScreen;
import cn.zbx1425.minopp.gui.TurnDeadMan;
import cn.zbx1425.minopp.gui.WildSelectionScreen;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.mixin.KeyMappingAccessor;
import cn.zbx1425.minopp.network.C2SPlayCardPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMinoTable
extends Block
implements EntityBlock {
    public static final EnumProperty<TablePartType> PART = EnumProperty.m_61587_((String)"part", TablePartType.class);
    private static final VoxelShape VOXEL_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.9, (double)16.0);

    public BlockMinoTable() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60955_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return this.useWithoutItem(blockState, level, blockPos, player, hitResult);
        }
        if (level.f_46443_ && itemStack.m_150930_((Item)Mino.ITEM_HAND_CARDS.get())) {
            BlockPos corePos = BlockMinoTable.getCore(blockState, blockPos);
            ItemHandCards.CardGameBinding gameBinding = ItemHandCards.getCardGameBinding(itemStack);
            int handIndex = ItemHandCards.getClientHandIndex(itemStack);
            CardPlayer playerWithoutHand = ItemHandCards.getCardPlayer(player);
            BlockEntity blockEntity = level.m_7702_(corePos);
            if (blockEntity instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                if (tableEntity.game != null) {
                    if (gameBinding == null || !gameBinding.tablePos().equals((Object)corePos)) {
                        player.m_5661_((Component)Component.m_237115_((String)"game.minopp.play.no_player"), true);
                        return InteractionResult.FAIL;
                    }
                    TurnDeadMan.pedal();
                    CardPlayer realPlayer = tableEntity.game.deAmputate(playerWithoutHand);
                    if (realPlayer == null) {
                        return InteractionResult.FAIL;
                    }
                    if (Client.isCursorHittingPile()) {
                        C2SPlayCardPacket.Client.sendPlayNoCardC2S(corePos, playerWithoutHand);
                    } else {
                        Card selectedCard = realPlayer.hand.get(Mth.m_14045_((int)handIndex, (int)0, (int)(realPlayer.hand.size() - 1)));
                        if (selectedCard.suit == Card.Suit.WILD) {
                            Client.openWildSelectionScreen(corePos, playerWithoutHand, selectedCard, Client.isShoutModifierHeld());
                        } else {
                            C2SPlayCardPacket.Client.sendPlayCardC2S(corePos, playerWithoutHand, selectedCard, null, Client.isShoutModifierHeld());
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(blockState, level, blockPos, player, hand, hitResult);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockPos corePos = BlockMinoTable.getCore(blockState, blockPos);
        BlockEntity blockEntity = level.m_7702_(corePos);
        if (blockEntity instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
            CardPlayer cardPlayer = ItemHandCards.getCardPlayer(player);
            if (tableEntity.demo) {
                player.m_5661_((Component)Component.m_237115_((String)"game.minopp.play.table_in_demo"), true);
                return InteractionResult.FAIL;
            }
            if (level.f_46443_) {
                Client.openSeatControlScreen(corePos);
                return InteractionResult.SUCCESS;
            }
            if (tableEntity.game == null && !player.m_36341_()) {
                tableEntity.joinPlayerToTable(cardPlayer, player.m_20182_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos firstPartPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        for (int i = 0; i < 4; ++i) {
            boolean isPlaceable;
            TablePartType part = TablePartType.values()[i];
            BlockPos thisPartPos = firstPartPos.m_7918_(part.xOff, 0, part.zOff);
            boolean bl = isPlaceable = level.m_8055_(thisPartPos).m_60629_(blockPlaceContext) && level.m_6857_().m_61937_(thisPartPos);
            if (isPlaceable) continue;
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)TablePartType.X_LESS_Z_LESS));
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (!level.f_46443_) {
            for (int i = 1; i < 4; ++i) {
                TablePartType thisPart = TablePartType.values()[i];
                BlockPos thisPartPos = blockPos.m_7918_(thisPart.xOff, 0, thisPart.zOff);
                level.m_7731_(thisPartPos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)thisPart)), 19);
            }
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        BlockPos firstPartPos = BlockMinoTable.getCore(blockState, blockPos);
        for (int i = 0; i < 4; ++i) {
            TablePartType thisPart = TablePartType.values()[i];
            BlockPos thisPartPos = firstPartPos.m_7918_(thisPart.xOff, 0, thisPart.zOff);
            if (levelAccessor.m_8055_(thisPartPos).m_60713_((Block)this)) continue;
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            BlockPos firstPartPos = BlockMinoTable.getCore(blockState, blockPos);
            for (int i = 0; i < 4; ++i) {
                TablePartType thisPart = TablePartType.values()[i];
                BlockPos thisPartPos = firstPartPos.m_7918_(thisPart.xOff, 0, thisPart.zOff);
                level.m_7731_(thisPartPos, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public static BlockPos getCore(BlockState blockState, BlockPos blockPos) {
        if (!blockState.m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
            return blockPos;
        }
        TablePartType part = (TablePartType)((Object)blockState.m_61143_(PART));
        return blockPos.m_7918_(-part.xOff, 0, -part.zOff);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if (blockState.m_61143_(PART) != TablePartType.X_LESS_Z_LESS) {
            return null;
        }
        return new BlockEntityMinoTable(blockPos, blockState);
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VOXEL_SHAPE;
    }

    public static class Client {
        public static void openWildSelectionScreen(BlockPos corePos, CardPlayer player, Card selectedCard, boolean shout) {
            Minecraft.m_91087_().m_91152_((Screen)new WildSelectionScreen(corePos, player, selectedCard, shout));
        }

        public static void openSeatControlScreen(BlockPos corePos) {
            Minecraft.m_91087_().m_91152_((Screen)new SeatControlScreen(corePos));
        }

        public static boolean isShoutModifierHeld() {
            InputConstants.Key boundKey = ((KeyMappingAccessor)MinoClient.KEY_SHOUT_MODIFIER.get()).getKey();
            return boundKey.m_84868_() == InputConstants.Type.KEYSYM && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)boundKey.m_84873_());
        }

        @Nullable
        public static BlockPos getCursorPickedGame() {
            BlockPos potentialTablePos;
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (hitResult.m_6662_() == HitResult.Type.BLOCK && level.m_8055_(potentialTablePos = ((BlockHitResult)hitResult).m_82425_()).m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
                return BlockMinoTable.getCore(level.m_8055_(potentialTablePos), potentialTablePos);
            }
            return null;
        }

        public static boolean isCursorHittingPile() {
            BlockPos gamePos = Client.getCursorPickedGame();
            if (gamePos == null) {
                return false;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockEntity blockEntity = level.m_7702_(gamePos);
            if (blockEntity instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
                if (tableEntity.game == null) {
                    return false;
                }
                AABB pileAabb = Client.getPileAabb(tableEntity);
                Entity cameraEntity = Minecraft.m_91087_().m_91288_();
                float partialTicks = Minecraft.m_91087_().m_91296_();
                float hitDistance = 20.0f;
                Vec3 rayBegin = cameraEntity.m_20299_(partialTicks);
                Vec3 rayDir = cameraEntity.m_20252_(partialTicks);
                Vec3 rayEnd = rayBegin.m_82520_(rayDir.f_82479_ * (double)hitDistance, rayDir.f_82480_ * (double)hitDistance, rayDir.f_82481_ * (double)hitDistance);
                return pileAabb.m_82338_(gamePos).m_82371_(rayBegin, rayEnd).isPresent();
            }
            return true;
        }

        public static AABB getPileAabb(BlockEntityMinoTable tableEntity) {
            if (tableEntity.game == null) {
                return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            return AABB.m_165882_((Vec3)new Vec3(0.5, 0.94, 0.5), (double)0.3, (double)0.0625, (double)0.5).m_82363_(0.0, Math.ceil((float)tableEntity.game.deck.size() / 5.0f) * 0.0625 * (double)0.3f, 0.0);
        }
    }

    public static enum TablePartType implements StringRepresentable
    {
        X_LESS_Z_LESS,
        X_LESS_Z_MORE,
        X_MORE_Z_LESS,
        X_MORE_Z_MORE;

        public final int xOff = this.ordinal() / 2;
        public final int zOff = this.ordinal() % 2;

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

