/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.effect;

import cn.zbx1425.minopp.effect.EffectEvent;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayPriorityQueue;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EffectQueue {
    private final PriorityQueue<TimedEvent> queue = new ObjectArrayPriorityQueue(Comparator.comparingLong(a -> a.time));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Level level) {
        long time = System.currentTimeMillis();
        PriorityQueue<TimedEvent> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            while (!this.queue.isEmpty() && ((TimedEvent)this.queue.first()).time <= time) {
                ((TimedEvent)this.queue.dequeue()).summon(level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<EffectEvent> events, BlockPos origin, Player self, boolean selfIsPartOfSourceGame) {
        PriorityQueue<TimedEvent> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            long time = System.currentTimeMillis();
            for (EffectEvent event : events) {
                if (!event.target().isEmpty() && !event.target().get().equals(self.m_36316_().getId())) continue;
                this.queue.enqueue((Object)new TimedEvent(event, time, origin, selfIsPartOfSourceGame));
            }
        }
    }

    private static class TimedEvent {
        private final EffectEvent event;
        private final long time;
        private final BlockPos origin;
        private final boolean selfIsPartOfSourceGame;

        public TimedEvent(EffectEvent incoming, long baseTime, BlockPos origin, boolean selfIsPartOfSourceGame) {
            this.event = incoming;
            this.time = baseTime + (long)incoming.timeOffset();
            this.origin = origin;
            this.selfIsPartOfSourceGame = selfIsPartOfSourceGame;
        }

        public void summon(Level level) {
            this.event.summonClient(level, this.origin, this.selfIsPartOfSourceGame);
        }
    }
}

