/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.effect.GrantRewardEffectEvent;
import cn.zbx1425.minopp.effect.PlayerFireworkEffectEvent;
import cn.zbx1425.minopp.effect.PlayerGlowEffectEvent;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class CardGame {
    public List<CardPlayer> players;
    public int currentPlayerIndex;
    public int drawCount;
    public boolean isSkipping;
    public PlayerActionPhase currentPlayerPhase;
    public boolean isAntiClockwise;
    public List<Card> deck = new ArrayList<Card>();
    public List<Card> discardDeck = new ArrayList<Card>();
    public Card topCard;

    public CardGame(List<CardPlayer> players) {
        this.players = players;
    }

    public ActionReport initiate(CardPlayer cardPlayer, int initialCardCount) {
        if (this.players.size() < 2) {
            return ActionReport.NO_GAME;
        }
        this.currentPlayerIndex = new Random().nextInt(this.players.size());
        this.drawCount = 0;
        this.isSkipping = false;
        this.currentPlayerPhase = PlayerActionPhase.DISCARD_HAND;
        this.isAntiClockwise = false;
        this.deck = Card.createDeck();
        Collections.shuffle(this.deck);
        for (int i = 0; i < initialCardCount; ++i) {
            for (CardPlayer player : this.players) {
                player.hand.add(this.deck.remove(this.deck.size() - 1));
            }
        }
        Card tobeTopCard = this.deck.remove(this.deck.size() - 1);
        while (tobeTopCard.family != Card.Family.NUMBER || tobeTopCard.suit == Card.Suit.WILD) {
            this.deck.add(tobeTopCard);
            Collections.shuffle(this.deck);
            tobeTopCard = this.deck.remove(this.deck.size() - 1);
        }
        this.topCard = tobeTopCard;
        return ActionReport.builder(this, cardPlayer).sound(Mino.id("game.play"), 0).sound(Mino.id("game.turn_notice"), 500, this.players.get(this.currentPlayerIndex)).gameStarted();
    }

    public ActionReport playCard(CardPlayer cardPlayer, Card card, Card.Suit wildSelection, boolean shout) {
        ActionReport report = ActionReport.builder(this, cardPlayer);
        int playerIndex = this.players.indexOf(cardPlayer);
        if (playerIndex == -1) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.no_player"));
        }
        if (!cardPlayer.hand.contains(card)) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.not_your_card"));
        }
        boolean isCut = false;
        if (this.topCard.equals(card) && playerIndex != this.currentPlayerIndex && this.topCard.suit != Card.Suit.WILD) {
            isCut = true;
        } else if (playerIndex != this.currentPlayerIndex) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.not_your_turn"));
        }
        if (!card.canPlayOn(this.topCard)) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.invalid_card"));
        }
        if (card.suit == Card.Suit.WILD && card.family == Card.Family.DRAW) {
            for (Card otherCard : cardPlayer.hand) {
                if (otherCard.equals(card) || !otherCard.canPlayOn(this.topCard)) continue;
                return report.fail((Component)Component.m_237115_((String)"game.minopp.play.rule_forbid"));
            }
        }
        if (isCut) {
            this.currentPlayerIndex = playerIndex;
        }
        this.doDiscardCard(cardPlayer, card, report);
        if (cardPlayer.hand.isEmpty()) {
            report.sound(Mino.id("game.win"), 0);
            report.effect(new PlayerGlowEffectEvent(cardPlayer.uuid, 120));
            report.effect(new GrantRewardEffectEvent(cardPlayer.uuid));
            for (int i = 0; i < 5; ++i) {
                report.effect(new PlayerFireworkEffectEvent(i * 1000 + 500, cardPlayer.uuid, PlayerFireworkEffectEvent.WIN_EXPLOSION));
            }
            return report.gameWon();
        }
        if (card.suit == Card.Suit.WILD) {
            this.topCard = this.topCard.withEquivSuit(wildSelection);
        }
        switch (card.family) {
            case SKIP: {
                this.isSkipping = true;
                break;
            }
            case REVERSE: {
                if (this.players.size() == 2) {
                    this.isSkipping = true;
                    break;
                }
                this.isAntiClockwise = !this.isAntiClockwise;
                break;
            }
            case DRAW: {
                this.drawCount -= card.number;
            }
        }
        if (shout) {
            report.combineWith(this.shoutMino(cardPlayer));
        }
        this.advanceTurn(report);
        return isCut ? report.cut() : report.played();
    }

    public ActionReport playNoCard(CardPlayer cardPlayer) {
        boolean drawn;
        ActionReport report = ActionReport.builder(this, cardPlayer);
        int playerIndex = this.players.indexOf(cardPlayer);
        if (playerIndex == -1) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.no_player"));
        }
        if (playerIndex != this.currentPlayerIndex) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.not_your_turn"));
        }
        boolean bl = drawn = this.currentPlayerPhase == PlayerActionPhase.DISCARD_DRAWN;
        if (this.currentPlayerPhase == PlayerActionPhase.DISCARD_HAND) {
            int drawCount;
            int n = drawCount = this.drawCount == 0 ? 1 : this.drawCount;
            if (!this.doDrawCard(cardPlayer, drawCount, report)) {
                return report.panic((Component)Component.m_237115_((String)"game.minopp.play.deck_depleted"));
            }
            if (this.drawCount > 0) {
                this.topCard = this.topCard.withEquivFamily(Card.Family.NUMBER);
                this.drawCount = 0;
            }
            this.currentPlayerPhase = PlayerActionPhase.DISCARD_DRAWN;
            report.sound(Mino.id("game.turn_notice_again"), 500 * (drawCount > 1 ? drawCount + 1 : 1), cardPlayer);
            return report.drew(drawCount);
        }
        if (this.currentPlayerPhase == PlayerActionPhase.DISCARD_DRAWN) {
            report.sound(Mino.id("game.pass"), 0);
            this.advanceTurn(report);
        }
        return report.playedNoCard(drawn);
    }

    public ActionReport shoutMino(CardPlayer realPlayer) {
        ActionReport report = ActionReport.builder(this, realPlayer);
        if (!realPlayer.hasShoutedMino) {
            if (realPlayer.hand.size() <= 1) {
                realPlayer.hasShoutedMino = true;
                report.sound(Mino.id("game.mino_shout"), 0);
                return report.messageAll((Component)Component.m_237110_((String)"game.minopp.play.mino_shout", (Object[])new Object[]{realPlayer.name}));
            }
            if (!this.doDrawCard(realPlayer, 2, report)) {
                return report.panic((Component)Component.m_237115_((String)"game.minopp.play.deck_depleted"));
            }
            realPlayer.hasShoutedMino = true;
            report.sound(Mino.id("game.mino_shout"), 0);
            report.sound(Mino.id("game.mino_shout_invalid"), 500);
            return report.messageAll((Component)Component.m_237110_((String)"game.minopp.play.mino_shout_invalid", (Object[])new Object[]{realPlayer.name}));
        }
        return null;
    }

    public ActionReport doubtMino(CardPlayer srcPlayer, UUID targetPlayerWithoutHand) {
        ActionReport report = ActionReport.builder(this, srcPlayer);
        CardPlayer targetPlayer = this.deAmputate(targetPlayerWithoutHand);
        if (targetPlayer == null) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.no_player"));
        }
        if (this.players.get(this.currentPlayerIndex).equals(targetPlayer)) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.doubt_target_playing"));
        }
        if (srcPlayer.equals(targetPlayer)) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.doubt_target_self"));
        }
        if (targetPlayer.hasShoutedMino) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.doubt_target_shouted"));
        }
        if (targetPlayer.hand.size() > 1) {
            return report.fail((Component)Component.m_237115_((String)"game.minopp.play.doubt_target_hand"));
        }
        if (!this.doDrawCard(targetPlayer, 2, report)) {
            return report.panic((Component)Component.m_237115_((String)"game.minopp.play.deck_depleted"));
        }
        targetPlayer.hasShoutedMino = true;
        report.sound(Mino.id("game.doubt_success"), 0);
        return report.messageAll((Component)Component.m_237110_((String)"game.minopp.play.doubt_success", (Object[])new Object[]{srcPlayer.name, targetPlayer.name}));
    }

    public void doDiscardCard(CardPlayer player, Card card, ActionReport report) {
        this.discardDeck.add(this.topCard.eraseEquiv());
        this.topCard = card;
        player.hand.remove(card);
        report.sound(Mino.id("game.play"), 0);
    }

    public boolean doDrawCard(CardPlayer cardPlayer, int drawCount, ActionReport report) {
        if (this.deck.size() < drawCount) {
            Collections.shuffle(this.discardDeck);
            this.deck.addAll(this.discardDeck);
            this.discardDeck.clear();
        }
        if (this.deck.size() < drawCount) {
            return false;
        }
        for (int i = 0; i < drawCount; ++i) {
            cardPlayer.hand.add(this.deck.remove(this.deck.size() - 1));
            report.sound(Mino.id("game.draw"), 500 * i);
            if (drawCount <= 1) continue;
            report.sound(Mino.id("game.draw_multi"), 500 * i + 200);
        }
        return true;
    }

    private void advanceTurn(ActionReport report) {
        this.currentPlayerPhase = PlayerActionPhase.DISCARD_HAND;
        if (this.isSkipping) {
            this.currentPlayerIndex = (this.currentPlayerIndex + (this.isAntiClockwise ? -1 : 1)) % this.players.size();
        }
        this.currentPlayerIndex = (this.currentPlayerIndex + (this.isAntiClockwise ? -1 : 1)) % this.players.size();
        if (this.currentPlayerIndex < 0) {
            this.currentPlayerIndex += this.players.size();
        }
        this.isSkipping = false;
        CardPlayer currentPlayer = this.players.get(this.currentPlayerIndex);
        currentPlayer.hasShoutedMino = false;
        report.sound(Mino.id("game.turn_notice"), 500, currentPlayer);
    }

    public CardPlayer deAmputate(CardPlayer playerWithoutHand) {
        return this.players.stream().filter(p -> p.equals(playerWithoutHand)).findFirst().orElse(null);
    }

    public CardPlayer deAmputate(UUID uuid) {
        return this.players.stream().filter(p -> p.uuid.equals(uuid)).findFirst().orElse(null);
    }

    public CardGame(CompoundTag tag) {
        this.currentPlayerIndex = tag.m_128451_("currentPlayer");
        this.drawCount = tag.m_128451_("drawCount");
        this.isSkipping = tag.m_128471_("isSkipping");
        this.currentPlayerPhase = PlayerActionPhase.valueOf(tag.m_128461_("currentPlayerPhase"));
        this.isAntiClockwise = tag.m_128471_("isAntiClockwise");
        this.deck = new ArrayList<Card>(tag.m_128437_("deck", 10).stream().map(t -> new Card((CompoundTag)t)).toList());
        this.discardDeck = new ArrayList<Card>(tag.m_128437_("discardDeck", 10).stream().map(t -> new Card((CompoundTag)t)).toList());
        this.topCard = new Card(tag.m_128469_("topCard"));
        this.players = new ArrayList<CardPlayer>(tag.m_128437_("players", 10).stream().map(t -> new CardPlayer((CompoundTag)t)).toList());
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("currentPlayer", this.currentPlayerIndex);
        tag.m_128405_("drawCount", this.drawCount);
        tag.m_128379_("isSkipping", this.isSkipping);
        tag.m_128359_("currentPlayerPhase", this.currentPlayerPhase.name());
        tag.m_128379_("isAntiClockwise", this.isAntiClockwise);
        ListTag deckTag = new ListTag();
        deckTag.addAll(this.deck.stream().map(Card::toTag).toList());
        tag.m_128365_("deck", (Tag)deckTag);
        ListTag discardDeckTag = new ListTag();
        discardDeckTag.addAll(this.discardDeck.stream().map(Card::toTag).toList());
        tag.m_128365_("discardDeck", (Tag)discardDeckTag);
        tag.m_128365_("topCard", (Tag)this.topCard.toTag());
        ListTag playersTag = new ListTag();
        playersTag.addAll(this.players.stream().map(CardPlayer::toTag).toList());
        tag.m_128365_("players", (Tag)playersTag);
        return tag;
    }

    public static enum PlayerActionPhase {
        DISCARD_HAND,
        DISCARD_DRAWN;

    }
}

