/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.game.Card;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class CardPlayer {
    public UUID uuid;
    public String name;
    public List<Card> hand = new ArrayList<Card>();
    public boolean hasShoutedMino = false;

    public CardPlayer(Player mcPlayer) {
        this.uuid = mcPlayer.m_36316_().getId();
        this.name = mcPlayer.m_36316_().getName();
    }

    public CardPlayer(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public CardPlayer(CompoundTag tag) {
        this.uuid = tag.m_128342_("uuid");
        this.name = tag.m_128461_("name");
        this.hand = new ArrayList<Card>(tag.m_128437_("hand", 10).stream().map(t -> new Card((CompoundTag)t)).toList());
        this.hasShoutedMino = tag.m_128471_("hasShoutedMino");
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", this.uuid);
        tag.m_128359_("name", this.name);
        ListTag handTag = new ListTag();
        handTag.addAll(this.hand.stream().map(Card::toTag).toList());
        tag.m_128365_("hand", (Tag)handTag);
        tag.m_128379_("hasShoutedMino", this.hasShoutedMino);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardPlayer that = (CardPlayer)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

