/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.item;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemDataUtils {
    public static final String MINO_DATA = "minopp_data";
    public static final String CARD_GAME_BINDING_TABLE_POS = "card_game_binding_table_pos";
    public static final String CARD_GAME_BINDING_BEARER_ID = "card_game_binding_bearer_id";
    public static final String CLIENT_HAND_INDEX = "client_hand_index";

    @NotNull
    public static CompoundTag getDataMap(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(MINO_DATA, 10)) {
            return tag.m_128469_(MINO_DATA);
        }
        CompoundTag dataMap = new CompoundTag();
        tag.m_128365_(MINO_DATA, (Tag)dataMap);
        return dataMap;
    }

    @Nullable
    public static CompoundTag getDataMapIfPresent(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MINO_DATA, 10)) {
            return tag.m_128469_(MINO_DATA);
        }
        return null;
    }

    public static boolean hasData(ItemStack stack, String key, int type) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap != null && dataMap.m_128425_(key, type);
    }

    public static void removeData(ItemStack stack, String key) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        if (dataMap != null) {
            dataMap.m_128473_(key);
            if (dataMap.m_128456_()) {
                stack.m_41749_(MINO_DATA);
            }
        }
    }

    public static int getHandIndex(ItemStack stack) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap == null ? 0 : dataMap.m_128451_(CLIENT_HAND_INDEX);
    }

    public static BlockPos getBlockPos(ItemStack stack) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        return dataMap == null ? null : BlockPos.m_122022_((long)dataMap.m_128454_(CARD_GAME_BINDING_TABLE_POS));
    }

    @Nullable
    public static UUID getBearerId(ItemStack stack) {
        CompoundTag dataMap = ItemDataUtils.getDataMapIfPresent(stack);
        if (dataMap != null && dataMap.m_128403_(CARD_GAME_BINDING_BEARER_ID)) {
            return dataMap.m_128342_(CARD_GAME_BINDING_BEARER_ID);
        }
        return null;
    }

    public static void setHandIndex(ItemStack stack, int index) {
        ItemDataUtils.getDataMap(stack).m_128405_(CLIENT_HAND_INDEX, index);
    }

    public static void setBlockPos(ItemStack stack, BlockPos blockPos) {
        ItemDataUtils.getDataMap(stack).m_128356_(CARD_GAME_BINDING_TABLE_POS, blockPos.m_121878_());
    }

    public static void setBearerId(ItemStack stack, @Nullable UUID uuid) {
        if (uuid == null) {
            ItemDataUtils.removeData(stack, CARD_GAME_BINDING_BEARER_ID);
        } else {
            ItemDataUtils.getDataMap(stack).m_128362_(CARD_GAME_BINDING_BEARER_ID, uuid);
        }
    }

    public static void setCardGameBinding(ItemStack stack, BlockPos blockPos, UUID uuid) {
        ItemDataUtils.setBlockPos(stack, blockPos);
        ItemDataUtils.setBearerId(stack, uuid);
    }
}

