/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.item;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.platform.GroupedItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ItemHandCards
extends GroupedItem {
    private static final String NBT_TABLE_POS = "TablePos";
    private static final String NBT_BEARER_ID = "BearerId";
    private static final String NBT_CLIENT_HAND_INDEX = "ClientHandIndex";

    public ItemHandCards() {
        super(() -> null, p -> p.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        BlockEntity blockEntity;
        if (usedHand != InteractionHand.MAIN_HAND) {
            return super.m_7203_(level, player, usedHand);
        }
        BlockPos gamePos = ItemHandCards.getHandCardGamePos(player);
        if (gamePos != null && (blockEntity = level.m_7702_(gamePos)) instanceof BlockEntityMinoTable) {
            BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)blockEntity;
            if (tableEntity.game != null && tableEntity.getPlayersList().stream().anyMatch(p -> p.uuid.equals(player.m_36316_().getId()))) {
                return InteractionResultHolder.m_19100_((Object)player.m_21120_(usedHand));
            }
        }
        player.m_21008_(usedHand, ItemStack.f_41583_);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
    }

    public static CardPlayer getCardPlayer(Player player) {
        return new CardPlayer(player);
    }

    public static BlockPos getHandCardGamePos(Player player) {
        if (!player.m_21205_().m_150930_((Item)Mino.ITEM_HAND_CARDS.get())) {
            return null;
        }
        CompoundTag tag = player.m_21205_().m_41783_();
        if (tag == null || !tag.m_128441_(NBT_TABLE_POS)) {
            return null;
        }
        BlockPos tablePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(NBT_TABLE_POS));
        BlockState blockState = player.m_9236_().m_8055_(tablePos);
        if (!blockState.m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
            return null;
        }
        return BlockMinoTable.getCore(blockState, tablePos);
    }

    public static int getClientHandIndex(Player player) {
        if (player.m_21205_().m_150930_((Item)Mino.ITEM_HAND_CARDS.get())) {
            CompoundTag tag = player.m_21205_().m_41783_();
            return tag != null ? tag.m_128451_(NBT_CLIENT_HAND_INDEX) : 0;
        }
        return 0;
    }

    public static void setCardGameBinding(ItemStack stack, BlockPos tablePos, UUID bearerId) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(NBT_TABLE_POS, (Tag)NbtUtils.m_129224_((BlockPos)tablePos));
        tag.m_128362_(NBT_BEARER_ID, bearerId);
    }

    public static void setCardGameBinding(ItemStack stack, CardGameBinding binding) {
        ItemHandCards.setCardGameBinding(stack, binding.tablePos(), binding.bearerId());
    }

    public static void setClientHandIndex(ItemStack stack, int index) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(NBT_CLIENT_HAND_INDEX, index);
    }

    public static int getClientHandIndex(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(NBT_CLIENT_HAND_INDEX);
    }

    public static CardGameBinding getCardGameBinding(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(NBT_TABLE_POS) || !tag.m_128441_(NBT_BEARER_ID)) {
            return null;
        }
        return new CardGameBinding(NbtUtils.m_129239_((CompoundTag)tag.m_128469_(NBT_TABLE_POS)), tag.m_128342_(NBT_BEARER_ID));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CardGameBinding binding = ItemHandCards.getCardGameBinding(stack);
        if (binding != null) {
            tooltipComponents.add((Component)Component.m_237113_((String)("Table: " + binding.tablePos().m_123344_())));
            if (Minecraft.m_91087_().f_91074_ != null && binding.bearerId().equals(Minecraft.m_91087_().f_91074_.m_36316_().getId())) {
                tooltipComponents.add((Component)Component.m_237113_((String)"NOT YOUR CARD!").m_130940_(ChatFormatting.RED));
            }
        }
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
    }

    public record CardGameBinding(BlockPos tablePos, UUID bearerId) {
    }
}

