/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.network;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.item.ItemHandCards;
import cn.zbx1425.minopp.platform.ClientPlatform;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class C2SSeatControlPacket {
    public static final ResourceLocation ID = Mino.id("seat_control");

    public static void handleC2S(MinecraftServer server, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos gamePos = packet.m_130135_();
        int action = packet.readInt();
        ServerLevel level = player.m_284548_();
        server.execute(() -> {
            BlockEntity patt0$temp = level.m_7702_(gamePos);
            if (patt0$temp instanceof BlockEntityMinoTable) {
                BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                List<CardPlayer> playersList = tableEntity.getPlayersList();
                CardPlayer cardPlayer = ItemHandCards.getCardPlayer((Player)player);
                if (tableEntity.demo) {
                    player.m_5661_((Component)Component.m_237115_((String)"game.minopp.play.table_in_demo"), true);
                    return;
                }
                switch (action) {
                    case 1: {
                        if (tableEntity.game != null) break;
                        if (playersList.size() < 2) {
                            player.m_5661_((Component)Component.m_237115_((String)"game.minopp.play.no_enough_player"), true);
                            return;
                        }
                        tableEntity.startGame(cardPlayer);
                        break;
                    }
                    case 0: {
                        if (tableEntity.game == null) break;
                        tableEntity.destroyGame(cardPlayer);
                        break;
                    }
                    case -1: {
                        if (tableEntity.game != null) break;
                        tableEntity.resetSeats(cardPlayer);
                    }
                }
            }
        });
    }

    public static class Client {
        public static void sendGameEnableC2S(BlockPos gamePos, boolean gameEnable) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130064_(gamePos);
            packet.writeInt(gameEnable ? 1 : 0);
            ClientPlatform.sendPacketToServer(ID, packet);
        }

        public static void sendResetSeatsC2S(BlockPos gamePos) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130064_(gamePos);
            packet.writeInt(-1);
            ClientPlatform.sendPacketToServer(ID, packet);
        }
    }
}

