/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.network;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.MinoClient;
import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.EffectEvents;
import cn.zbx1425.minopp.platform.ServerPlatform;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class S2CEffectListPacket {
    public static final ResourceLocation ID = Mino.id("effect_list");

    public static void sendS2C(ServerPlayer target, List<EffectEvent> sounds, BlockPos origin, boolean playerPartOfSourceGame) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(sounds.size());
        for (EffectEvent event : sounds) {
            packet.m_130085_(event.type().id());
            EffectEvent.Type<? extends EffectEvent> type = event.type();
            EffectEvent.Serializer<? extends EffectEvent> serializer = type.serializer();
            serializer.serialize(packet, event);
        }
        packet.m_130064_(origin);
        packet.writeBoolean(playerPartOfSourceGame);
        ServerPlatform.sendPacketToPlayer(target, ID, packet);
    }

    public static class Client {
        public static void handleS2C(FriendlyByteBuf packet) {
            int size = packet.readInt();
            ArrayList<EffectEvent> sounds = new ArrayList<EffectEvent>(size);
            for (int i = 0; i < size; ++i) {
                ResourceLocation id = packet.m_130281_();
                EffectEvent.Type<?> type = EffectEvents.REGISTRY.get(id);
                sounds.add((EffectEvent)type.serializer().deserialize(packet));
            }
            BlockPos origin = packet.m_130135_();
            boolean playerPartOfSourceGame = packet.readBoolean();
            MinoClient.SOUND_QUEUE.addAll(sounds, origin, (Player)Minecraft.m_91087_().f_91074_, playerPartOfSourceGame);
        }
    }
}

