/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.render;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.platform.RegistryObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlockEntityMinoTableRenderer
implements BlockEntityRenderer<BlockEntityMinoTable> {
    private static final RegistryObject<ItemStack> HAND_CARDS_MODEL_PLACEHOLDER = new RegistryObject<ItemStack>(() -> new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS_MODEL_PLACEHOLDER.get()));
    private static final RegistryObject<ItemStack> HAND_CARDS_ENCHANTED_MODEL_PLACEHOLDER = new RegistryObject<ItemStack>(() -> {
        ItemStack stack = new ItemStack((ItemLike)Mino.ITEM_HAND_CARDS_MODEL_PLACEHOLDER.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("Enchanted", true);
        return stack;
    });
    private ItemRenderer itemRenderer;

    public BlockEntityMinoTableRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
    }

    public void render(BlockEntityMinoTable blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.game == null) {
            return;
        }
        if (BlockMinoTable.Client.isCursorHittingPile()) {
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)multiBufferSource.m_6299_(RenderType.m_110504_()), (AABB)BlockMinoTable.Client.getPileAabb(blockEntity), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.94, 0.5);
        poseStack.m_85841_(0.4f, 0.3f, 0.4f);
        BakedModel model = this.itemRenderer.m_174264_(HAND_CARDS_MODEL_PLACEHOLDER.get(), null, null, 0);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(-1.5707964f));
        Random deckRandom = new Random(1L);
        int ci = 0;
        while ((double)ci < Math.ceil((float)blockEntity.game.deck.size() / 5.0f)) {
            poseStack.m_85837_((double)deckRandom.nextFloat() * 0.1 - 0.05, (double)deckRandom.nextFloat() * 0.1 - 0.05, 0.0625);
            this.itemRenderer.m_115143_(HAND_CARDS_MODEL_PLACEHOLDER.get(), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, packedLight, packedOverlay, model);
            ++ci;
        }
        poseStack.m_85849_();
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)Mino.id("textures/gui/deck.png")));
        poseStack.m_85836_();
        poseStack.m_85837_(1.0, 0.9625, 1.0);
        poseStack.m_85841_(0.2f, 0.2f, 0.2f);
        poseStack.m_252781_(Axis.f_252529_.m_252961_(-1.5707964f));
        Random discardRandom = new Random(1L);
        for (int ci2 = 0; ci2 <= blockEntity.game.discardDeck.size(); ++ci2) {
            poseStack.m_85836_();
            poseStack.m_252880_(discardRandom.nextFloat() * 6.0f - 3.0f, discardRandom.nextFloat() * 6.0f - 3.0f, (float)ci2 / 32.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252961_(discardRandom.nextFloat() * 2.0f * (float)Math.PI));
            Card card = ci2 == blockEntity.game.discardDeck.size() ? blockEntity.game.topCard : blockEntity.game.discardDeck.get(ci2);
            float cardU = (switch (card.family) {
                default -> throw new IncompatibleClassChangeError();
                case Card.Family.NUMBER -> Math.abs(card.number) * 16;
                case Card.Family.SKIP -> 160.0f;
                case Card.Family.DRAW -> 176.0f;
                case Card.Family.REVERSE -> 192.0f;
            }) / 256.0f;
            float cardV = (float)(card.suit.ordinal() * 25) / 128.0f;
            float cardUW = 0.0625f;
            float cardVH = 0.1953125f;
            int color = ci2 == blockEntity.game.discardDeck.size() ? -1 : -4473925;
            Matrix4f pose = poseStack.m_85850_().m_252922_();
            Matrix3f normalPose = poseStack.m_85850_().m_252943_();
            vertexConsumer.m_252986_(pose, -0.52f, 0.8f, 0.0f).m_193479_(-16777216).m_7421_(cardU, cardV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, -0.52f, -0.8f, 0.0f).m_193479_(-16777216).m_7421_(cardU, cardV + cardVH).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, 0.52f, -0.8f, 0.0f).m_193479_(-16777216).m_7421_(cardU + cardUW, cardV + cardVH).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, 0.52f, 0.8f, 0.0f).m_193479_(-16777216).m_7421_(cardU + cardUW, cardV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            poseStack.m_252880_(0.0f, 0.0f, 0.015625f);
            vertexConsumer.m_252986_(pose, -0.5f, 0.78f, 0.0f).m_193479_(color).m_7421_(cardU, cardV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, -0.5f, -0.78f, 0.0f).m_193479_(color).m_7421_(cardU, cardV + cardVH).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, 0.5f, -0.78f, 0.0f).m_193479_(color).m_7421_(cardU + cardUW, cardV + cardVH).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(pose, 0.5f, 0.78f, 0.0f).m_193479_(color).m_7421_(cardU + cardUW, cardV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalPose, 0.0f, 0.0f, 1.0f).m_5752_();
            if (ci2 == blockEntity.game.discardDeck.size()) {
                Font font = Minecraft.m_91087_().f_91062_;
                poseStack.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                poseStack.m_85841_(0.03f, -0.03f, 0.03f);
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                float g = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
                int k = (int)(g * 255.0f) << 24;
                Component component = card.suit == Card.Suit.WILD ? card.getDisplayName().m_6881_().m_7220_((Component)Component.m_237115_((String)("game.minopp.card.suit." + card.getEquivSuit().name().toLowerCase()))) : card.getDisplayName();
                float h = -font.m_92852_((FormattedText)component) / 2;
                font.m_272077_(component, h, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.SEE_THROUGH, k, 0xF000F0);
                font.m_272077_(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Math.PI));
                font.m_272077_(component, h, 0.0f, 0x20FFFFFF, false, matrix4f, multiBufferSource, Font.DisplayMode.SEE_THROUGH, k, 0xF000F0);
                font.m_272077_(component, h, 0.0f, -1, false, matrix4f, multiBufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(BlockEntityMinoTable blockEntity) {
        return true;
    }
}

