/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.render;

import cn.zbx1425.minopp.entity.EntityAutoPlayer;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EntityAutoPlayerRenderer
extends LivingEntityRenderer<EntityAutoPlayer, PlayerModel<EntityAutoPlayer>> {
    private static final String SLIM_NAME = "slim";
    private PlayerModel<EntityAutoPlayer> slimModel;
    private PlayerModel<EntityAutoPlayer> wideModel;

    public EntityAutoPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true), 0.5f);
        this.slimModel = (PlayerModel)this.f_115290_;
        this.wideModel = new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(EntityAutoPlayer entity) {
        Optional<GameProfile> result = entity.clientSkinGameProfile;
        if (result.isPresent()) {
            SkinManager skinManager = Minecraft.m_91087_().m_91109_();
            return skinManager.m_240306_(result.get());
        }
        return new ResourceLocation("textures/entity/player/slim/alex.png");
    }

    public void render(EntityAutoPlayer entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Optional<GameProfile> result = entity.clientSkinGameProfile;
        this.f_115290_ = this.wideModel;
        if (result.isPresent()) {
            Map info = Minecraft.m_91087_().m_91109_().m_118815_(result.get());
            if (info.containsKey(MinecraftProfileTexture.Type.SKIN) && SLIM_NAME.equals(((MinecraftProfileTexture)info.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model"))) {
                this.f_115290_ = this.slimModel;
            }
        } else {
            this.f_115290_ = this.slimModel;
        }
        PlayerModel playerModel = (PlayerModel)this.m_7200_();
        playerModel.m_8009_(true);
        ItemStack handStack = entity.m_21205_();
        playerModel.f_102816_ = !handStack.m_41619_() ? HumanoidModel.ArmPose.ITEM : HumanoidModel.ArmPose.EMPTY;
        super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

