/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.DynmapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.Pl3xMapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiveAtlasConnection
extends MapConnection {
    public static final Pattern dynmapRegexPattern = Pattern.compile("\\n +dynmap: \\{\\n(.*\\n)*?.*}\\n");
    public static final Pattern Pl3xMapRegexPattern = Pattern.compile("\n +\t+ +pl3xmap: \"(.+?)\"\n");
    List<MapConnection> mapConnections = new ArrayList<MapConnection>();
    int mapIndex;

    @Override
    public void setCurrentDimension(String currentDimension) {
        for (MapConnection connection : this.mapConnections) {
            connection.setCurrentDimension(currentDimension);
        }
    }

    public LiveAtlasConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.setupConnections(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.setupConnections(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your LiveAtlas link is broken!");
                }
                throw e;
            }
        }
    }

    private void setupConnections(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        String g;
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        String liveAtlasHTML = HTTP.makeTextHttpRequest(URI.create(baseURL).toURL(), true);
        Matcher matcher = dynmapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            g = matcher.group();
            try {
                this.mapConnections.add(new DynmapConnection(baseURL, g));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating Dynmap connection for LiveAtlas");
            }
        }
        matcher = Pl3xMapRegexPattern.matcher(liveAtlasHTML);
        while (matcher.find()) {
            g = matcher.group(1);
            try {
                this.mapConnections.add(new Pl3xMapConnection(baseURL, g));
            }
            catch (Exception e) {
                AbstractModInitializer.LOGGER.error("error creating Pl3xMap connection for LiveAtlas");
                e.printStackTrace();
            }
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        if (this.mapConnections.isEmpty()) {
            return new HashMap<String, PlayerPosition>();
        }
        if (CommonModConfig.Instance.debugMode()) {
            HashMap<String, PlayerPosition> debug = new HashMap<String, PlayerPosition>();
            for (MapConnection mapConnection : this.mapConnections) {
                debug.putAll(mapConnection.getPlayerPositions());
            }
            return debug;
        }
        HashMap<String, PlayerPosition> map = this.mapConnections.get(this.mapIndex).getPlayerPositions();
        if (this.mapConnections.get((int)this.mapIndex).foundPlayer) {
            return map;
        }
        int i = 0;
        for (MapConnection mapConnection : this.mapConnections) {
            if (i == this.mapIndex) {
                ++i;
                continue;
            }
            HashMap<String, PlayerPosition> map2 = mapConnection.getPlayerPositions();
            if (mapConnection.foundPlayer) {
                this.mapIndex = i;
                return map2;
            }
            ++i;
        }
        return map;
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        if (this.mapConnections.isEmpty()) {
            return new HashMap<String, WaypointPosition>();
        }
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        return this.mapConnections.get(this.mapIndex).getWaypointPositions();
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        HashSet<String> layers = new HashSet<String>();
        for (MapConnection connection : this.mapConnections) {
            layers.addAll(connection.getMarkerLayers());
        }
        return layers;
    }
}

