/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.remote_player_waypoints_for_xaero.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.AbstractModInitializer;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.CommonModConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.HTTP;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.PlayerPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.UpdateTask;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.WaypointPosition;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.MapConnection;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.connections.Pl3xMapConfiguration;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapAltMarkerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapMarkerLayerConfig;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapMarkerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.mapUpdates.Pl3xMapPlayerUpdate;
import de.the_build_craft.remote_player_waypoints_for_xaero.common.wrappers.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Pl3xMapConnection
extends MapConnection {
    private String markerLayerStringTemplate = "";
    private String markerStringTemplate = "";
    int version;
    private String lastMarkerDimension = "";
    private HashMap<String, WaypointPosition> lastResult = new HashMap();

    public Pl3xMapConnection(CommonModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Remote Player Waypoints For Xaero's Map]: Error: Your Pl3xMap link is broken!");
                }
                throw e;
            }
        }
    }

    public Pl3xMapConnection(String baseURL, String link) throws IOException {
        Matcher matcher = Pattern.compile(".*?//\\w*(\\.\\w+)+(:\\w+)?").matcher((CharSequence)baseURL);
        if (!matcher.find()) {
            throw new RuntimeException("wrong url pattern");
        }
        baseURL = matcher.group();
        if (((String)link).contains("//")) {
            baseURL = link;
        } else {
            if (!((String)link).startsWith("/")) {
                link = "/" + (String)link;
            }
            baseURL = (String)baseURL + (String)link;
        }
        if (((String)baseURL).endsWith("/")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 1);
        }
        this.setup((String)baseURL);
    }

    private void generateLink(CommonModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        this.setup(this.getBaseURL(serverEntry, useHttps));
    }

    private void setup(String baseURL) throws IOException {
        this.onlineMapConfigLink = baseURL + "/tiles/settings.json";
        this.markerLayerStringTemplate = baseURL + "/tiles/{world}/markers.json";
        if (HTTP.makeTextHttpRequest(URI.create(this.onlineMapConfigLink).toURL()).contains("\"players\":[")) {
            this.version = 0;
            this.queryURL = URI.create(this.onlineMapConfigLink).toURL();
            this.markerStringTemplate = baseURL + "/tiles/{world}/markers/{layerName}.json";
        } else {
            this.version = 1;
            this.queryURL = URI.create(baseURL + "/tiles/players.json").toURL();
        }
        this.getPlayerPositions();
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.Instance.debugMode()) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            Pl3xMapPlayerUpdate.Player player = update.players[i];
            if (this.version == 0) {
                positions[i] = new PlayerPosition(player.name, player.position.x, CommonModConfig.Instance.defaultY(), player.position.z, player.world);
                continue;
            }
            if (this.version != 1) continue;
            positions[i] = new PlayerPosition(player.name, player.x, CommonModConfig.Instance.defaultY(), player.z, player.world);
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public HashMap<String, WaypointPosition> getWaypointPositions() throws IOException {
        if (this.markerLayerStringTemplate.isEmpty() || this.currentDimension.isEmpty()) {
            return new HashMap<String, WaypointPosition>();
        }
        CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
        if (serverEntry.markerVisibilityMode == CommonModConfig.ServerEntry.MarkerVisibilityMode.Auto) {
            CommonModConfig.Instance.setMarkerLayers(serverEntry.ip, new ArrayList<String>(this.getMarkerLayers()));
        }
        if (this.markerStringTemplate.isEmpty() && this.version == 0) {
            return new HashMap<String, WaypointPosition>();
        }
        if (this.lastMarkerDimension.equals(this.currentDimension)) {
            return this.lastResult;
        }
        this.lastMarkerDimension = this.currentDimension;
        HashMap<String, WaypointPosition> positions = new HashMap<String, WaypointPosition>();
        if (this.version == 0) {
            for (String layer : this.getMarkerLayers(false)) {
                Pl3xMapMarkerUpdate[] markers;
                Type apiResponseType = new TypeToken<Pl3xMapMarkerUpdate[]>(){}.getType();
                URL reqUrl = URI.create(this.markerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-")).replace("{layerName}", layer)).toURL();
                for (Pl3xMapMarkerUpdate marker : markers = (Pl3xMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType)) {
                    if (!Objects.equals(marker.type, "icon")) continue;
                    WaypointPosition newWaypointPosition = new WaypointPosition(marker.options.tooltip.content, marker.data.point.x, CommonModConfig.Instance.defaultY(), marker.data.point.z);
                    positions.put(newWaypointPosition.name, newWaypointPosition);
                }
            }
        } else if (this.version == 1) {
            Pl3xMapAltMarkerUpdate[] markerLayers;
            Type apiResponseType = new TypeToken<Pl3xMapAltMarkerUpdate[]>(){}.getType();
            URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
            for (Pl3xMapAltMarkerUpdate layer : markerLayers = (Pl3xMapAltMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType)) {
                if (Objects.equals(layer.id, "pl3xmap_players") || !serverEntry.includeMarkerLayer(layer.id)) continue;
                for (Pl3xMapAltMarkerUpdate.Marker marker : layer.markers) {
                    if (!Objects.equals(marker.type, "icon")) continue;
                    WaypointPosition newWaypointPosition = new WaypointPosition(marker.tooltip, marker.point.x, CommonModConfig.Instance.defaultY(), marker.point.z);
                    positions.put(newWaypointPosition.name, newWaypointPosition);
                }
            }
        }
        this.lastResult = positions;
        return positions;
    }

    @Override
    public HashSet<String> getMarkerLayers() {
        return this.getMarkerLayers(true);
    }

    private HashSet<String> getMarkerLayers(boolean all) {
        try {
            if (this.version == 0) {
                Type apiResponseType = new TypeToken<Pl3xMapMarkerLayerConfig[]>(){}.getType();
                if (all) {
                    Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
                    HashSet<String> layerSet = new HashSet<String>();
                    for (Pl3xMapPlayerUpdate.WorldSetting ws : update.worldSettings) {
                        Pl3xMapMarkerLayerConfig[] mls;
                        for (Pl3xMapMarkerLayerConfig ml : mls = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                            if (Objects.equals(ml.key, "pl3xmap_players")) continue;
                            layerSet.add(ml.key);
                        }
                    }
                    return layerSet;
                }
                URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
                Pl3xMapMarkerLayerConfig[] markerLayers = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
                HashSet<String> layers = new HashSet<String>();
                CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
                for (Pl3xMapMarkerLayerConfig layer : markerLayers) {
                    if (Objects.equals(layer.key, "pl3xmap_players") || !serverEntry.includeMarkerLayer(layer.key)) continue;
                    layers.add(layer.key);
                }
                return layers;
            }
            if (this.version == 1) {
                Type apiResponseType = new TypeToken<Pl3xMapAltMarkerUpdate[]>(){}.getType();
                if (all) {
                    Pl3xMapConfiguration configuration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), Pl3xMapConfiguration.class);
                    HashSet<String> layerSet = new HashSet<String>();
                    for (Pl3xMapConfiguration.World ws : configuration.worlds) {
                        Pl3xMapAltMarkerUpdate[] mls;
                        for (Pl3xMapAltMarkerUpdate ml : mls = (Pl3xMapAltMarkerUpdate[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                            if (Objects.equals(ml.id, "pl3xmap_players")) continue;
                            layerSet.add(ml.id);
                        }
                    }
                    return layerSet;
                }
                URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
                Pl3xMapAltMarkerUpdate[] markerLayers = (Pl3xMapAltMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
                HashSet<String> layers = new HashSet<String>();
                CommonModConfig.ServerEntry serverEntry = CommonModConfig.Instance.getCurrentServerEntry();
                for (Pl3xMapAltMarkerUpdate layer : markerLayers) {
                    if (Objects.equals(layer.id, "pl3xmap_players") || !serverEntry.includeMarkerLayer(layer.id)) continue;
                    layers.add(layer.id);
                }
                return layers;
            }
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

