/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.herbalbrews.core.registry.ScreenHandlerTypeRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;

public class TeaKettleGuiHandler
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData propertyDelegate;

    public TeaKettleGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(5));
    }

    public TeaKettleGuiHandler(int syncId, Inventory playerInventory, Container container, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerTypeRegistry.TEA_KETTLE_SCREEN_HANDLER.get(), syncId);
        int i;
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.m_38884_(this.propertyDelegate);
        this.m_38897_((Slot)new FurnaceResultSlot(playerInventory.f_35978_, container, 0, 91, 22));
        this.m_38897_(new Slot(container, 1, 13, 12));
        this.m_38897_(new Slot(container, 2, 31, 12));
        this.m_38897_(new Slot(container, 3, 13, 30));
        this.m_38897_(new Slot(container, 4, 31, 30));
        this.m_38897_(new Slot(container, 5, 31, 52){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(TagsRegistry.CONTAINER_ITEMS);
            }
        });
        this.m_38897_(new Slot(container, 6, 118, 43){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(TagsRegistry.SMALL_WATER_FILL) || stack.m_204117_(TagsRegistry.LARGE_WATER_FILL);
            }
        });
        this.m_38897_(new Slot(container, 7, 95, 58){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(TagsRegistry.HEAT_ITEMS);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.m_6413_(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.m_6413_(0);
        int total = this.propertyDelegate.m_6413_(4);
        if (total <= 0) {
            return 0;
        }
        return progress * arrowWidth / total;
    }

    public int getWaterLevel() {
        return this.propertyDelegate.m_6413_(2);
    }

    public int getHeatLevel() {
        return this.propertyDelegate.m_6413_(3);
    }

    public int getCookingTime() {
        return this.propertyDelegate.m_6413_(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.m_6413_(4);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack item = slot.m_7993_();
        ItemStack copy = item.m_41777_();
        if (index < 8) {
            if (!this.m_38903_(item, 8, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(item, copy);
        } else if (index < this.f_38839_.size() && (item.m_204117_(TagsRegistry.CONTAINER_ITEMS) ? !this.m_38903_(item, 5, 6, false) : (item.m_204117_(TagsRegistry.HEAT_ITEMS) ? !this.m_38903_(item, 7, 8, false) : (item.m_204117_(TagsRegistry.SMALL_WATER_FILL) || item.m_204117_(TagsRegistry.LARGE_WATER_FILL) ? !this.m_38903_(item, 6, 7, false) : !this.m_38903_(item, 0, 5, false))))) {
            return ItemStack.f_41583_;
        }
        if (item.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, item);
        return copy;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

