/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.block.StorageBlock;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CupcakeDisplayBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)0.0625, (double)0.875, (double)0.5625));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.3125, (double)0.9375, (double)0.375, (double)0.6875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.4375, (double)0.3125, (double)0.9375, (double)0.75, (double)0.6875));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.4375, (double)0.9375, (double)0.875, (double)0.5625));
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public CupcakeDisplayBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public int size() {
        return 6;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.CUPCAKE_DISPLAY;
    }

    @Override
    public boolean canInsertStack(ItemStack stack) {
        return true;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN, Direction.UP};
    }

    @Override
    public int getSection(Float x, Float y) {
        int i = y.floatValue() >= 0.5f ? 0 : 1;
        int j = CupcakeDisplayBlock.getXSection(x.floatValue());
        return j + i * 3;
    }

    private static int getXSection(float f) {
        if (f < 0.375f) {
            return 2;
        }
        return f < 0.6875f ? 1 : 0;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bakery.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

