/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllBlockEntityTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class NBTProcessors {
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> processors = new HashMap();
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> survivalProcessors = new HashMap();
    private static final UnaryOperator<CompoundTag> signProcessor;

    public static synchronized void addProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<CompoundTag> itemProcessor(String tagKey) {
        return data -> {
            CompoundTag compound = data.m_128469_(tagKey);
            if (!compound.m_128425_("tag", 10)) {
                return data;
            }
            CompoundTag itemTag = compound.m_128469_("tag");
            if (itemTag == null) {
                return data;
            }
            HashSet keys = new HashSet(itemTag.m_128431_());
            for (String key : keys) {
                if (!NBTProcessors.isUnsafeItemNBTKey(key)) continue;
                itemTag.m_128473_(key);
            }
            if (itemTag.m_128456_()) {
                compound.m_128473_("tag");
            }
            return data;
        };
    }

    public static ItemStack withUnsafeNBTDiscarded(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return stack;
        }
        ItemStack copy = stack.m_41777_();
        stack.m_41783_().m_128431_().stream().filter(NBTProcessors::isUnsafeItemNBTKey).forEach(arg_0 -> ((ItemStack)copy).m_41749_(arg_0));
        return copy;
    }

    public static boolean isUnsafeItemNBTKey(String name) {
        if (name.equals("StoredEnchantments")) {
            return false;
        }
        if (name.equals("Enchantments")) {
            return false;
        }
        if (name.contains("Potion")) {
            return false;
        }
        if (name.contains("Damage")) {
            return false;
        }
        return !name.equals("display");
    }

    public static boolean textComponentHasClickEvent(String json) {
        MutableComponent component = Component.Serializer.m_130701_((String)(json.isEmpty() ? "\"\"" : json));
        return component != null && component.m_7383_() != null && component.m_7383_().m_131182_() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static CompoundTag process(BlockState blockState, BlockEntity blockEntity, CompoundTag compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        BlockEntityType type = blockEntity.m_58903_();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (CompoundTag)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (CompoundTag)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof SpawnerBlockEntity) {
            return compound;
        }
        if (blockState.m_204336_(BlockTags.f_260523_)) {
            return (CompoundTag)signProcessor.apply(compound);
        }
        if (blockEntity.m_6326_()) {
            return null;
        }
        return compound;
    }

    static {
        NBTProcessors.addProcessor(BlockEntityType.f_58908_, data -> {
            if (!data.m_128425_("Book", 10)) {
                return data;
            }
            CompoundTag book = data.m_128469_("Book");
            if (!book.m_128425_("tag", 10)) {
                return data;
            }
            CompoundTag tag = book.m_128469_("tag");
            if (!tag.m_128425_("pages", 9)) {
                return data;
            }
            ListTag pages = tag.m_128437_("pages", 8);
            for (Tag inbt : pages) {
                if (!NBTProcessors.textComponentHasClickEvent(inbt.m_7916_())) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addProcessor((BlockEntityType)AllBlockEntityTypes.CREATIVE_CRATE.get(), NBTProcessors.itemProcessor("Filter"));
        NBTProcessors.addProcessor((BlockEntityType)AllBlockEntityTypes.PLACARD.get(), NBTProcessors.itemProcessor("Item"));
        signProcessor = data -> {
            for (String key : List.of("front_text", "back_text")) {
                CompoundTag textTag = data.m_128469_(key);
                if (!textTag.m_128425_("messages", 9)) continue;
                for (Tag tag : textTag.m_128437_("messages", 8)) {
                    StringTag stringTag;
                    if (!(tag instanceof StringTag) || !NBTProcessors.textComponentHasClickEvent((stringTag = (StringTag)tag).m_7916_())) continue;
                    return null;
                }
            }
            return data;
        };
    }
}

